/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.context;

import com.netflix.config.DynamicIntProperty;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.zuul.context.Cookies;
import com.netflix.zuul.context.Headers;
import com.netflix.zuul.context.HttpQueryParams;
import com.netflix.zuul.context.HttpRequestInfo;
import com.netflix.zuul.context.SessionContext;
import com.netflix.zuul.context.ZuulMessage;
import com.netflix.zuul.stats.Timing;
import io.netty.handler.codec.http.Cookie;
import io.netty.handler.codec.http.CookieDecoder;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.runners.MockitoJUnitRunner;
import rx.Observable;

public class HttpRequestMessage
extends ZuulMessage {
    private static final DynamicIntProperty MAX_BODY_SIZE_PROP = DynamicPropertyFactory.getInstance().getIntProperty("zuul.HttpRequestMessage.body.max.size", 15360000);
    private String protocol;
    private String method;
    private String path;
    private HttpQueryParams queryParams;
    private String clientIp;
    private String scheme;
    private int port;
    private String serverName;
    private HttpRequestInfo originalRequestInfo = null;

    public HttpRequestMessage(SessionContext context, String protocol, String method, String path, HttpQueryParams queryParams, Headers headers, String clientIp, String scheme, int port, String serverName) {
        super(context, headers);
        this.protocol = protocol;
        this.method = method;
        this.path = path;
        this.queryParams = queryParams == null ? new HttpQueryParams() : queryParams;
        this.clientIp = clientIp;
        this.scheme = scheme;
        this.port = port;
        this.serverName = serverName;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public HttpQueryParams getQueryParams() {
        return this.queryParams;
    }

    public String getPathAndQuery() {
        if (this.queryParams != null && this.queryParams.entries().size() > 0) {
            return this.getPath() + "?" + this.queryParams.toEncodedString();
        }
        return this.getPath();
    }

    public String getClientIp() {
        return this.clientIp;
    }

    public void setClientIp(String clientIp) {
        this.clientIp = clientIp;
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public Cookies parseCookies() {
        Cookies cookies = new Cookies();
        for (String aCookieHeader : this.getHeaders().get("cookie")) {
            Set decode = CookieDecoder.decode((String)aCookieHeader);
            for (Cookie cookie : decode) {
                cookies.add(cookie);
            }
        }
        return cookies;
    }

    @Override
    public int getMaxBodySize() {
        return MAX_BODY_SIZE_PROP.get();
    }

    @Override
    public Observable<byte[]> bufferBody() {
        Timing timing = this.getContext().getTimings().getRequestBodyRead();
        timing.start();
        return super.bufferBody().finallyDo(() -> timing.end());
    }

    @Override
    public ZuulMessage clone() {
        return super.clone();
    }

    @Override
    public String getInfoForLogging() {
        StringBuilder sb = new StringBuilder().append("uri=").append(this.reconstructURI().toString()).append(", method=").append(this.getMethod());
        return sb.toString();
    }

    public HttpRequestInfo copyRequestInfo() {
        return new HttpRequestInfo(this.protocol, this.method, this.path, this.queryParams.clone(), this.headers.clone(), this.clientIp, this.scheme, this.port);
    }

    public void storeOriginalRequestInfo() {
        this.originalRequestInfo = this.copyRequestInfo();
    }

    public HttpRequestInfo getOriginalRequestInfo() {
        return this.originalRequestInfo;
    }

    public String getOriginalHost() {
        String host = this.headers.getFirst("X-Forwarded-Host");
        if (host == null && (host = this.headers.getFirst("Host")) == null) {
            host = this.getServerName();
        }
        return host;
    }

    public String getOriginalScheme() {
        String scheme = this.headers.getFirst("X-Forwarded-Proto");
        if (scheme == null) {
            scheme = this.getScheme();
        }
        return scheme;
    }

    public int getOriginalPort() {
        String portStr = this.headers.getFirst("X-Forwarded-Port");
        int port = portStr == null ? this.getPort() : Integer.parseInt(portStr);
        return port;
    }

    public URI reconstructURI() {
        URI uri;
        String scheme = this.getOriginalScheme();
        String host = this.getOriginalHost();
        int port = this.getOriginalPort();
        if ("http".equalsIgnoreCase(scheme) && 80 == port || "https".equalsIgnoreCase(scheme) && 443 == port) {
            port = -1;
        }
        String queryStr = null;
        if (this.queryParams != null && this.queryParams.entries().size() > 0) {
            queryStr = this.queryParams.toEncodedString();
        }
        try {
            uri = new URI(scheme, null, host, port, this.path, queryStr, null);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Error reconstructing request URI!", e);
        }
        return uri;
    }

    @RunWith(value=MockitoJUnitRunner.class)
    public static class TestUnit {
        HttpRequestMessage request;

        @Test
        public void testOriginalRequestInfo() {
            HttpQueryParams queryParams = new HttpQueryParams();
            queryParams.add("flag", "5");
            Headers headers = new Headers();
            headers.add("Host", "blah.netflix.com");
            this.request = new HttpRequestMessage(new SessionContext(), "HTTP/1.1", "POST", "/some/where", queryParams, headers, "192.168.0.2", "https", 7002, "localhost");
            this.request.storeOriginalRequestInfo();
            HttpRequestInfo originalRequest = this.request.getOriginalRequestInfo();
            Assert.assertEquals((long)this.request.getPort(), (long)originalRequest.getPort());
            Assert.assertEquals((Object)this.request.getPath(), (Object)originalRequest.getPath());
            Assert.assertEquals((Object)this.request.getQueryParams().getFirst("flag"), (Object)originalRequest.getQueryParams().getFirst("flag"));
            Assert.assertEquals((Object)this.request.getHeaders().getFirst("Host"), (Object)originalRequest.getHeaders().getFirst("Host"));
            this.request.setPort(8080);
            this.request.setPath("/another/place");
            this.request.getQueryParams().set("flag", "20");
            this.request.getHeaders().set("Host", "wah.netflix.com");
            Assert.assertEquals((long)7002L, (long)originalRequest.getPort());
            Assert.assertEquals((Object)"/some/where", (Object)originalRequest.getPath());
            Assert.assertEquals((Object)"5", (Object)originalRequest.getQueryParams().getFirst("flag"));
            Assert.assertEquals((Object)"blah.netflix.com", (Object)originalRequest.getHeaders().getFirst("Host"));
        }

        @Test
        public void testReconstructURI() {
            HttpQueryParams queryParams = new HttpQueryParams();
            queryParams.add("flag", "5");
            Headers headers = new Headers();
            headers.add("Host", "blah.netflix.com");
            this.request = new HttpRequestMessage(new SessionContext(), "HTTP/1.1", "POST", "/some/where", queryParams, headers, "192.168.0.2", "https", 7002, "localhost");
            Assert.assertEquals((Object)"https://blah.netflix.com:7002/some/where?flag=5", (Object)this.request.reconstructURI().toString());
            queryParams = new HttpQueryParams();
            headers = new Headers();
            headers.add("X-Forwarded-Host", "place.netflix.com");
            headers.add("X-Forwarded-Port", "80");
            this.request = new HttpRequestMessage(new SessionContext(), "HTTP/1.1", "POST", "/some/where", queryParams, headers, "192.168.0.2", "http", 7002, "localhost");
            Assert.assertEquals((Object)"http://place.netflix.com/some/where", (Object)this.request.reconstructURI().toString());
            queryParams = new HttpQueryParams();
            headers = new Headers();
            headers.add("X-Forwarded-Host", "place.netflix.com");
            headers.add("X-Forwarded-Proto", "https");
            headers.add("X-Forwarded-Port", "443");
            this.request = new HttpRequestMessage(new SessionContext(), "HTTP/1.1", "POST", "/some/where", queryParams, headers, "192.168.0.2", "http", 7002, "localhost");
            Assert.assertEquals((Object)"https://place.netflix.com/some/where", (Object)this.request.reconstructURI().toString());
            queryParams = new HttpQueryParams();
            headers = new Headers();
            this.request = new HttpRequestMessage(new SessionContext(), "HTTP/1.1", "POST", "/some/where", queryParams, headers, "192.168.0.2", "http", 7002, "localhost");
            Assert.assertEquals((Object)"http://localhost:7002/some/where", (Object)this.request.reconstructURI().toString());
            queryParams = new HttpQueryParams();
            queryParams.add("flag", "5");
            queryParams.add("flag B", "9");
            headers = new Headers();
            this.request = new HttpRequestMessage(new SessionContext(), "HTTP/1.1", "POST", "/some where", queryParams, headers, "192.168.0.2", "https", 7002, "localhost");
            Assert.assertEquals((Object)"https://localhost:7002/some%20where?flag=5&flag+B=9", (Object)this.request.reconstructURI().toString());
        }
    }
}

