/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.context;

import com.netflix.config.DynamicIntProperty;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.zuul.context.Cookies;
import com.netflix.zuul.context.Headers;
import com.netflix.zuul.context.HttpRequestMessage;
import com.netflix.zuul.context.SessionContext;
import com.netflix.zuul.context.ZuulMessage;
import com.netflix.zuul.stats.Timing;
import io.netty.handler.codec.http.Cookie;
import io.netty.handler.codec.http.CookieDecoder;
import io.netty.handler.codec.http.ServerCookieEncoder;
import rx.Observable;

public class HttpResponseMessage
extends ZuulMessage {
    private static final DynamicIntProperty MAX_BODY_SIZE_PROP = DynamicPropertyFactory.getInstance().getIntProperty("zuul.HttpResponseMessage.body.max.size", 25600000);
    private HttpRequestMessage request;
    private int status;

    public HttpResponseMessage(SessionContext context, HttpRequestMessage request, int defaultStatus) {
        super(context);
        this.request = request;
        this.status = defaultStatus;
    }

    public HttpResponseMessage(SessionContext context, Headers headers, HttpRequestMessage request, int status) {
        super(context, headers);
        this.request = request;
        this.status = status;
    }

    public HttpRequestMessage getRequest() {
        return this.request;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    @Override
    public int getMaxBodySize() {
        return MAX_BODY_SIZE_PROP.get();
    }

    @Override
    public Observable<byte[]> bufferBody() {
        Timing timing = this.getContext().getTimings().getResponseBodyRead();
        timing.start();
        return super.bufferBody().finallyDo(() -> timing.end());
    }

    public Cookies parseSetCookieHeader(String setCookieValue) {
        Cookies cookies = new Cookies();
        for (Cookie cookie : CookieDecoder.decode((String)setCookieValue)) {
            cookies.add(cookie);
        }
        return cookies;
    }

    public boolean hasSetCookieWithName(String cookieName) {
        boolean has = false;
        block0: for (String setCookieValue : this.getHeaders().get("Set-Cookie")) {
            for (Cookie cookie : CookieDecoder.decode((String)setCookieValue)) {
                if (!cookie.getName().equalsIgnoreCase(cookieName)) continue;
                has = true;
                continue block0;
            }
        }
        return has;
    }

    public void addSetCookie(Cookie cookie) {
        this.getHeaders().set("Set-Cookie", ServerCookieEncoder.encode((Cookie)cookie));
    }

    @Override
    public ZuulMessage clone() {
        return super.clone();
    }

    @Override
    public String getInfoForLogging() {
        StringBuilder sb = new StringBuilder().append(this.getRequest().getInfoForLogging()).append(",proxy-status=").append(this.getStatus());
        return sb.toString();
    }
}

