/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.context;

import com.netflix.zuul.filters.FilterError;
import com.netflix.zuul.filters.FilterPriority;
import com.netflix.zuul.stats.Timings;
import com.netflix.zuul.util.DeepCopy;
import java.io.NotSerializableException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.runners.MockitoJUnitRunner;

public class SessionContext
extends HashMap<String, Object>
implements Cloneable {
    private static final String KEY_VIP = "routeVIP";
    private static final String KEY_ENDPOINT = "_endpoint";
    private static final String KEY_APPLY_FILTERS_PRIORITY = "_filter_priority";
    private static final String KEY_TIMINGS = "_timings";
    private static final String KEY_EVENT_PROPS = "eventProperties";
    private static final String KEY_FILTER_ERRORS = "_filter_errors";
    private static final String KEY_FILTER_EXECS = "_filter_executions";

    public SessionContext() {
        this.put(KEY_APPLY_FILTERS_PRIORITY, FilterPriority.LOW);
        this.put(KEY_TIMINGS, new Timings());
        this.put(KEY_FILTER_EXECS, new StringBuilder());
        this.put(KEY_EVENT_PROPS, new HashMap());
        this.put(KEY_FILTER_ERRORS, new ArrayList());
    }

    @Override
    public SessionContext clone() {
        return (SessionContext)super.clone();
    }

    public String getString(String key) {
        return (String)this.get(key);
    }

    public boolean getBoolean(String key) {
        return this.getBoolean(key, false);
    }

    public boolean getBoolean(String key, boolean defaultResponse) {
        Boolean b = (Boolean)this.get(key);
        if (b != null) {
            return b;
        }
        return defaultResponse;
    }

    public void set(String key) {
        this.put(key, Boolean.TRUE);
    }

    public void set(String key, Object value) {
        if (value != null) {
            this.put(key, value);
        } else {
            this.remove(key);
        }
    }

    public SessionContext copy() {
        SessionContext copy = new SessionContext();
        Iterator it = this.keySet().iterator();
        String key = (String)it.next();
        while (key != null) {
            Object orig = this.get(key);
            try {
                Object copyValue = DeepCopy.copy(orig);
                if (copyValue != null) {
                    copy.set(key, copyValue);
                } else {
                    copy.set(key, orig);
                }
            }
            catch (NotSerializableException e) {
                copy.set(key, orig);
            }
            if (it.hasNext()) {
                key = (String)it.next();
                continue;
            }
            key = null;
        }
        return copy;
    }

    public Throwable getError() {
        return (Throwable)this.get("_error");
    }

    public void setError(Throwable th) {
        this.put("_error", th);
    }

    public String getErrorEndpoint() {
        return (String)this.get("_error-endpoint");
    }

    public void setErrorEndpoint(String name) {
        this.put("_error-endpoint", name);
    }

    public void setDebugRouting(boolean bDebug) {
        this.set("debugRouting", bDebug);
    }

    public boolean debugRouting() {
        return this.getBoolean("debugRouting");
    }

    public void setDebugRequestHeadersOnly(boolean bHeadersOnly) {
        this.set("debugRequestHeadersOnly", bHeadersOnly);
    }

    public boolean debugRequestHeadersOnly() {
        return this.getBoolean("debugRequestHeadersOnly");
    }

    public void setDebugRequest(boolean bDebug) {
        this.set("debugRequest", bDebug);
    }

    public boolean debugRequest() {
        return this.getBoolean("debugRequest");
    }

    public void removeRouteHost() {
        this.remove("routeHost");
    }

    public void setRouteHost(URL routeHost) {
        this.set("routeHost", routeHost);
    }

    public URL getRouteHost() {
        return (URL)this.get("routeHost");
    }

    public void addFilterExecutionSummary(String name, String status, long time) {
        StringBuilder sb = this.getFilterExecutionSummary();
        if (sb.length() > 0) {
            sb.append(", ");
        }
        sb.append(name).append('[').append(status).append(']').append('[').append(time).append("ms]");
    }

    public StringBuilder getFilterExecutionSummary() {
        return (StringBuilder)this.get(KEY_FILTER_EXECS);
    }

    public boolean shouldSendErrorResponse() {
        return this.getBoolean("shouldSendErrorResponse", false);
    }

    public void setShouldSendErrorResponse(boolean should) {
        this.set("shouldSendErrorResponse", should);
    }

    public boolean errorResponseSent() {
        return this.getBoolean("errorResponseSent", false);
    }

    public void setErrorResponseSent(boolean should) {
        this.set("errorResponseSent", should);
    }

    public String getRouteVIP() {
        return (String)this.get(KEY_VIP);
    }

    public void setRouteVIP(String sVip) {
        this.set(KEY_VIP, sVip);
    }

    public void setEndpoint(String endpoint) {
        this.put(KEY_ENDPOINT, endpoint);
    }

    public String getEndpoint() {
        return (String)this.get(KEY_ENDPOINT);
    }

    public FilterPriority getFilterPriorityToApply() {
        return (FilterPriority)((Object)this.get(KEY_APPLY_FILTERS_PRIORITY));
    }

    public void setFilterPriorityToApply(FilterPriority priority) {
        if (priority == null) {
            throw new NullPointerException("Passed FilterPriority is null!");
        }
        this.set(KEY_APPLY_FILTERS_PRIORITY, (Object)priority);
    }

    public void setEventProperty(String key, Object value) {
        this.getEventProperties().put(key, value);
    }

    public Map<String, Object> getEventProperties() {
        return (Map)this.get(KEY_EVENT_PROPS);
    }

    public List<FilterError> getFilterErrors() {
        return (List)this.get(KEY_FILTER_ERRORS);
    }

    public Timings getTimings() {
        return (Timings)this.get(KEY_TIMINGS);
    }

    public void setOriginReportedDuration(int duration) {
        this.put("_originReportedDuration", duration);
    }

    public int getOriginReportedDuration() {
        Object value = this.get("_originReportedDuration");
        if (value != null) {
            return (Integer)value;
        }
        return -1;
    }

    @RunWith(value=MockitoJUnitRunner.class)
    public static class UnitTest {
        @Test
        public void testBoolean() {
            SessionContext context = new SessionContext();
            Assert.assertEquals((Object)context.getBoolean("boolean_test"), (Object)Boolean.FALSE);
            Assert.assertEquals((Object)context.getBoolean("boolean_test", true), (Object)true);
        }
    }
}

