/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.context;

import com.netflix.config.DynamicIntProperty;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.zuul.bytebuf.ByteBufUtils;
import com.netflix.zuul.context.Headers;
import com.netflix.zuul.context.SessionContext;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.charset.Charset;
import rx.Observable;

public class ZuulMessage
implements Cloneable {
    protected static final DynamicIntProperty MAX_BODY_SIZE_PROP = DynamicPropertyFactory.getInstance().getIntProperty("zuul.message.body.max.size", 25600000);
    private static final Charset CS_UTF8 = Charset.forName("UTF-8");
    protected final SessionContext context;
    protected Headers headers;
    protected Observable<ByteBuf> bodyStream = null;
    protected boolean bodyBuffered = false;
    protected byte[] body = null;

    public ZuulMessage(SessionContext context) {
        this(context, new Headers());
    }

    public ZuulMessage(SessionContext context, Headers headers) {
        this.context = context;
        this.headers = headers == null ? new Headers() : headers;
    }

    public SessionContext getContext() {
        return this.context;
    }

    public Headers getHeaders() {
        return this.headers;
    }

    public void setHeaders(Headers newHeaders) {
        this.headers = newHeaders;
    }

    public byte[] getBody() {
        return this.body;
    }

    public void setBody(byte[] body) {
        this.body = body;
        this.bodyStream = Observable.just((Object)Unpooled.wrappedBuffer((byte[])this.body));
        this.bodyBuffered = true;
    }

    public void setBodyAsText(String bodyText, Charset cs) {
        this.setBody(bodyText.getBytes(cs));
    }

    public void setBodyAsText(String bodyText) {
        this.setBodyAsText(bodyText, CS_UTF8);
    }

    public Observable<byte[]> bufferBody() {
        if (this.isBodyBuffered()) {
            return Observable.just((Object)this.getBody());
        }
        return ByteBufUtils.aggregate(this.getBodyStream(), this.getMaxBodySize()).map(bb -> {
            byte[] body = ByteBufUtils.toBytes(bb);
            this.setBody(body);
            return body;
        });
    }

    public int getMaxBodySize() {
        return MAX_BODY_SIZE_PROP.get();
    }

    public boolean isBodyBuffered() {
        return this.bodyBuffered;
    }

    public Observable<ByteBuf> getBodyStream() {
        return this.bodyStream;
    }

    public void setBodyStream(Observable<ByteBuf> bodyStream) {
        this.bodyStream = bodyStream;
    }

    public ZuulMessage clone() {
        ZuulMessage copy = new ZuulMessage(this.context.clone(), this.headers.clone());
        copy.setBody((byte[])this.body.clone());
        return copy;
    }

    public String getInfoForLogging() {
        return "ZuulMessage";
    }
}

