/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.dependency.cassandra.hystrix;

import com.netflix.astyanax.Serializer;
import com.netflix.astyanax.model.ColumnFamily;
import com.netflix.astyanax.serializers.IntegerSerializer;
import com.netflix.astyanax.serializers.LongSerializer;
import com.netflix.astyanax.serializers.StringSerializer;
import com.netflix.hystrix.HystrixCommand;
import com.netflix.hystrix.HystrixCommandGroupKey;

public abstract class AbstractCassandraHystrixCommand<K>
extends HystrixCommand<K> {
    public AbstractCassandraHystrixCommand() {
        super(HystrixCommandGroupKey.Factory.asKey((String)"Cassandra"));
    }

    protected ColumnFamily getColumnFamilyViaColumnName(String columnFamilyName, Object rowKey) {
        return this.getColumnFamilyViaColumnName(columnFamilyName, rowKey.getClass());
    }

    protected ColumnFamily getColumnFamilyViaColumnName(String columnFamilyName, Class rowKeyClass) {
        if (rowKeyClass == String.class) {
            return new ColumnFamily(columnFamilyName, (Serializer)StringSerializer.get(), (Serializer)StringSerializer.get());
        }
        if (rowKeyClass == Integer.class) {
            return new ColumnFamily(columnFamilyName, (Serializer)IntegerSerializer.get(), (Serializer)StringSerializer.get());
        }
        if (rowKeyClass == Long.class) {
            return new ColumnFamily(columnFamilyName, (Serializer)LongSerializer.get(), (Serializer)StringSerializer.get());
        }
        throw new IllegalArgumentException("RowKeyType is not supported: " + rowKeyClass.getSimpleName() + ". String/Integer/Long are supported, or you can define the ColumnFamily yourself and use the other constructor.");
    }
}

