/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.dependency.cassandra.hystrix;

import com.netflix.astyanax.Keyspace;
import com.netflix.astyanax.model.ColumnFamily;
import com.netflix.astyanax.model.Rows;
import com.netflix.astyanax.query.RowSliceQuery;
import com.netflix.zuul.dependency.cassandra.CassandraCache;
import com.netflix.zuul.dependency.cassandra.hystrix.AbstractCassandraHystrixCommand;
import java.util.Arrays;

public class HystrixCassandraGetRowsByKeys<RowKeyType>
extends AbstractCassandraHystrixCommand<Rows<RowKeyType, String>> {
    private final Keyspace keyspace;
    private final ColumnFamily<RowKeyType, String> columnFamily;
    private final RowKeyType[] rowKeys;
    private final RowKeyType startKey;
    private final RowKeyType endKey;
    private final String startToken;
    private final String endToken;
    private final int maxRows;
    private String[] columns;
    private CassandraCache<Rows<RowKeyType, String>> fallbackCache = null;

    public HystrixCassandraGetRowsByKeys(Keyspace keyspace, ColumnFamily<RowKeyType, String> columnFamily, RowKeyType ... rowKeys) {
        this.keyspace = keyspace;
        this.columnFamily = columnFamily;
        this.rowKeys = rowKeys;
        this.startKey = null;
        this.endKey = null;
        this.startToken = null;
        this.endToken = null;
        this.maxRows = -1;
    }

    public HystrixCassandraGetRowsByKeys(Keyspace keyspace, ColumnFamily<RowKeyType, String> columnFamily, RowKeyType startKey, RowKeyType endKey, String startToken, String endToken, int maxRows) {
        this.keyspace = keyspace;
        this.columnFamily = columnFamily;
        this.rowKeys = null;
        this.startKey = startKey;
        this.endKey = endKey;
        this.startToken = startToken;
        this.endToken = endToken;
        this.maxRows = maxRows;
    }

    public HystrixCassandraGetRowsByKeys(Keyspace keyspace, String columnFamilyName, RowKeyType ... rowKeys) {
        this.keyspace = keyspace;
        this.columnFamily = this.getColumnFamilyViaColumnName(columnFamilyName, rowKeys[0]);
        this.rowKeys = rowKeys;
        this.startKey = null;
        this.endKey = null;
        this.startToken = null;
        this.endToken = null;
        this.maxRows = -1;
    }

    public HystrixCassandraGetRowsByKeys(Keyspace keyspace, String columnFamilyName, RowKeyType startKey, RowKeyType endKey, String startToken, String endToken, int maxRows) {
        this.keyspace = keyspace;
        this.columnFamily = this.getColumnFamilyViaColumnName(columnFamilyName, startKey);
        this.rowKeys = null;
        this.startKey = startKey;
        this.endKey = endKey;
        this.startToken = startToken;
        this.endToken = endToken;
        this.maxRows = maxRows;
    }

    protected Rows<RowKeyType, String> run() throws Exception {
        RowSliceQuery rowQuery = null;
        rowQuery = this.rowKeys != null ? this.keyspace.prepareQuery(this.columnFamily).getKeySlice((Object[])this.rowKeys) : this.keyspace.prepareQuery(this.columnFamily).getKeyRange(this.startKey, this.endKey, this.startToken, this.endToken, this.maxRows);
        if (this.columns != null) {
            rowQuery = rowQuery.withColumnSlice((Object[])this.columns);
        }
        Rows result = (Rows)rowQuery.execute().getResult();
        if (this.fallbackCache != null) {
            try {
                if (this.columns != null) {
                    this.fallbackCache.storeQuery(result, this.keyspace.toString(), this.columnFamily.getName(), Arrays.toString(this.rowKeys), String.valueOf(this.startKey), String.valueOf(this.endKey), this.startToken, this.endToken, String.valueOf(this.maxRows), Arrays.toString(this.columns));
                } else {
                    this.fallbackCache.storeQuery(result, this.keyspace.toString(), this.columnFamily.getName(), Arrays.toString(this.rowKeys), String.valueOf(this.startKey), String.valueOf(this.endKey), this.startToken, this.endToken, String.valueOf(this.maxRows));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public HystrixCassandraGetRowsByKeys<RowKeyType> withColumns(String ... columns) {
        this.columns = columns;
        return this;
    }

    public HystrixCassandraGetRowsByKeys<RowKeyType> setCache(CassandraCache<Rows<RowKeyType, String>> cache) {
        this.fallbackCache = cache;
        return this;
    }

    protected Rows<RowKeyType, String> getFallback() {
        return this.fallbackCache.fetchQuery(new String[0]);
    }
}

