/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.dependency.cassandra.hystrix;

import com.netflix.astyanax.Keyspace;
import com.netflix.astyanax.model.ColumnFamily;
import com.netflix.astyanax.model.CqlResult;
import com.netflix.astyanax.model.Rows;
import com.netflix.zuul.dependency.cassandra.CassandraCache;
import com.netflix.zuul.dependency.cassandra.hystrix.AbstractCassandraHystrixCommand;

public class HystrixCassandraGetRowsByQuery<RowKeyType>
extends AbstractCassandraHystrixCommand<Rows<RowKeyType, String>> {
    private final Keyspace keyspace;
    private final ColumnFamily<RowKeyType, String> columnFamily;
    private final String cql;
    private CassandraCache<Rows<RowKeyType, String>> fallbackCache = null;

    public HystrixCassandraGetRowsByQuery(Keyspace keyspace, ColumnFamily<RowKeyType, String> columnFamily, String cql) {
        this.keyspace = keyspace;
        this.columnFamily = columnFamily;
        this.cql = cql;
    }

    public HystrixCassandraGetRowsByQuery(Keyspace keyspace, String columnFamilyName, Class<?> columnFamilyKeyType, String cql) {
        this.keyspace = keyspace;
        this.columnFamily = this.getColumnFamilyViaColumnName(columnFamilyName, columnFamilyKeyType);
        this.cql = cql;
    }

    protected Rows<RowKeyType, String> run() throws Exception {
        CqlResult cqlresult = (CqlResult)this.keyspace.prepareQuery(this.columnFamily).withCql(this.cql).execute().getResult();
        Rows result = cqlresult.getRows();
        if (this.fallbackCache != null) {
            try {
                this.fallbackCache.storeQuery(result, this.keyspace.toString(), this.columnFamily.getName(), this.cql);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public HystrixCassandraGetRowsByQuery<RowKeyType> setCache(CassandraCache<Rows<RowKeyType, String>> cache) {
        this.fallbackCache = cache;
        return this;
    }

    protected Rows<RowKeyType, String> getFallback() {
        return this.fallbackCache != null ? this.fallbackCache.fetchQuery(new String[0]) : null;
    }
}

