/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.dependency.cassandra.hystrix;

import com.netflix.astyanax.ColumnListMutation;
import com.netflix.astyanax.Keyspace;
import com.netflix.astyanax.MutationBatch;
import com.netflix.astyanax.model.ColumnFamily;
import com.netflix.astyanax.model.ConsistencyLevel;
import com.netflix.zuul.dependency.cassandra.hystrix.AbstractCassandraHystrixCommand;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.Map;

public class HystrixCassandraPut<RowKeyType>
extends AbstractCassandraHystrixCommand<Void> {
    private final Keyspace keyspace;
    private final ColumnFamily<RowKeyType, String> columnFamily;
    private final RowKeyType rowKey;
    private final Map<String, Object> attributes;
    private Integer ttlSeconds = null;

    public HystrixCassandraPut(Keyspace keyspace, ColumnFamily<RowKeyType, String> columnFamily, RowKeyType rowKey, Map<String, Object> attributes) {
        this.keyspace = keyspace;
        this.columnFamily = columnFamily;
        this.rowKey = rowKey;
        this.attributes = attributes;
    }

    public HystrixCassandraPut(Keyspace keyspace, String columnFamilyName, RowKeyType rowKey, Map<String, Object> attributes) {
        this(keyspace, columnFamilyName, rowKey, attributes, -1);
    }

    public HystrixCassandraPut(Keyspace keyspace, String columnFamilyName, RowKeyType rowKey, Map<String, Object> attributes, int ttlSeconds) {
        this.keyspace = keyspace;
        this.columnFamily = this.getColumnFamilyViaColumnName(columnFamilyName, rowKey);
        this.rowKey = rowKey;
        this.attributes = attributes;
        if (ttlSeconds > 0) {
            this.ttlSeconds = ttlSeconds;
        }
    }

    protected Void run() throws Exception {
        MutationBatch m = this.keyspace.prepareMutationBatch().setConsistencyLevel(ConsistencyLevel.CL_QUORUM);
        ColumnListMutation cm = m.withRow(this.columnFamily, this.rowKey);
        for (String key : this.attributes.keySet()) {
            Object o = this.attributes.get(key);
            if (o == null) continue;
            if (o instanceof String) {
                cm.putColumn((Object)key, (String)o, this.ttlSeconds);
                continue;
            }
            if (o instanceof Boolean) {
                cm.putColumn((Object)key, ((Boolean)o).booleanValue(), this.ttlSeconds);
                continue;
            }
            if (o instanceof Integer) {
                cm.putColumn((Object)key, ((Integer)o).intValue(), this.ttlSeconds);
                continue;
            }
            if (o instanceof Long) {
                cm.putColumn((Object)key, ((Long)o).longValue(), this.ttlSeconds);
                continue;
            }
            if (o instanceof Double) {
                cm.putColumn((Object)key, ((Double)o).doubleValue(), this.ttlSeconds);
                continue;
            }
            if (o instanceof Date) {
                cm.putColumn((Object)key, (Date)o, this.ttlSeconds);
                continue;
            }
            if (o instanceof byte[]) {
                cm.putColumn((Object)key, (byte[])o, this.ttlSeconds);
                continue;
            }
            if (o instanceof ByteBuffer) {
                cm.putColumn((Object)key, (ByteBuffer)o, this.ttlSeconds);
                continue;
            }
            throw new IllegalArgumentException("Unsupported object instance type: " + o.getClass().getSimpleName());
        }
        m.execute();
        return null;
    }
}

