/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.dependency.httpclient.hystrix;

import com.netflix.config.DynamicPropertyFactory;
import com.netflix.hystrix.HystrixCommand;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandProperties;
import java.io.IOException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;

public class HostCommand
extends HystrixCommand<HttpResponse> {
    HttpClient httpclient;
    HttpHost httpHost;
    HttpRequest httpRequest;

    public HostCommand(HttpClient httpclient, HttpHost httpHost, HttpRequest httpRequest) {
        this("default", httpclient, httpHost, httpRequest);
    }

    public HostCommand(String commandKey, HttpClient httpclient, HttpHost httpHost, HttpRequest httpRequest) {
        super(HystrixCommand.Setter.withGroupKey((HystrixCommandGroupKey)HystrixCommandGroupKey.Factory.asKey((String)commandKey)).andCommandPropertiesDefaults(HystrixCommandProperties.Setter().withExecutionIsolationStrategy(HystrixCommandProperties.ExecutionIsolationStrategy.SEMAPHORE).withExecutionIsolationSemaphoreMaxConcurrentRequests(DynamicPropertyFactory.getInstance().getIntProperty("zuul.httpClient." + commandKey + ".semaphore.maxSemaphores", 100).get())));
        this.httpclient = httpclient;
        this.httpHost = httpHost;
        this.httpRequest = httpRequest;
    }

    protected HttpResponse run() throws Exception {
        return this.forward();
    }

    HttpResponse forward() throws IOException {
        return this.httpclient.execute(this.httpHost, this.httpRequest);
    }
}

