/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.dependency.ribbon;

import com.netflix.client.ClientException;
import com.netflix.client.ClientFactory;
import com.netflix.client.config.DefaultClientConfigImpl;
import com.netflix.client.config.IClientConfig;
import com.netflix.config.ConfigurationManager;
import com.netflix.config.DeploymentContext;
import com.netflix.config.DynamicBooleanProperty;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.config.DynamicStringProperty;
import com.netflix.zuul.ZuulApplicationInfo;
import org.apache.commons.configuration.AbstractConfiguration;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RibbonConfig {
    static String APPLICATION_NAME = null;
    static String APPLICATION_STACK = null;
    private static Logger LOG = LoggerFactory.getLogger(RibbonConfig.class);
    private static final DynamicBooleanProperty AUTODETECT_BACKEND_VIPS = DynamicPropertyFactory.getInstance().getBooleanProperty("zuul.autodetect-backend-vips", true);
    private static final DynamicStringProperty DEFAULT_CLIENT = DynamicPropertyFactory.getInstance().getStringProperty("zuul.niws.defaultClient", null);

    public static void setupAppInfo() {
        DeploymentContext config = ConfigurationManager.getDeploymentContext();
        String stack = config.getDeploymentStack();
        if (stack != null && stack.contains("_")) {
            RibbonConfig.setAppInfoFromZuulStack(stack);
        } else {
            String env = config.getDeploymentEnvironment();
            if (stack != null) {
                RibbonConfig.setApplicationName(stack);
            } else {
                if (DEFAULT_CLIENT.get() == null) {
                    throw new RuntimeException("Can't figure out default origin vips. Set stack as appName_stack of set zuul.niws.defaultClient param");
                }
                RibbonConfig.setApplicationName(DEFAULT_CLIENT.get());
            }
            RibbonConfig.setApplicationStack(env);
        }
    }

    public static String setupDefaultRibbonConfig() throws ClientException {
        String name = RibbonConfig.getApplicationName();
        String vip = RibbonConfig.getDefaultVipName();
        String vipAddr = RibbonConfig.getDefaultVipAddress(RibbonConfig.getApplicationStack());
        String namespace = DynamicPropertyFactory.getInstance().getStringProperty("zuul.ribbon.namespace", "ribbon").get();
        RibbonConfig.setIfNotDefined(vip, vipAddr);
        RibbonConfig.setIfNotDefined(RibbonConfig.getApplicationName() + "." + namespace + ".Port", "7001");
        RibbonConfig.setIfNotDefined(RibbonConfig.getApplicationName() + "." + namespace + ".AppName", name);
        RibbonConfig.setIfNotDefined(RibbonConfig.getApplicationName() + "." + namespace + ".ReadTimeout", "2000");
        RibbonConfig.setIfNotDefined(RibbonConfig.getApplicationName() + "." + namespace + ".ConnectTimeout", "2000");
        RibbonConfig.setIfNotDefined(RibbonConfig.getApplicationName() + "." + namespace + ".MaxAutoRetriesNextServer", "1");
        RibbonConfig.setIfNotDefined(RibbonConfig.getApplicationName() + "." + namespace + ".FollowRedirects", "false");
        RibbonConfig.setIfNotDefined(RibbonConfig.getApplicationName() + "." + namespace + ".ConnIdleEvictTimeMilliSeconds", "3600000");
        RibbonConfig.setIfNotDefined(RibbonConfig.getApplicationName() + "." + namespace + ".EnableZoneAffinity", "true");
        DefaultClientConfigImpl clientConfig = DefaultClientConfigImpl.getClientConfigWithDefaultValues((String)name, (String)namespace);
        ClientFactory.registerClientFromProperties((String)name, (IClientConfig)clientConfig);
        return name;
    }

    private static void setIfNotDefined(String key, String value) {
        AbstractConfiguration config = ConfigurationManager.getConfigInstance();
        if (config.getString(key) == null) {
            LOG.info("Setting default NIWS Property " + key + "=" + value);
            config.setProperty(key, (Object)value);
        }
    }

    public static boolean setAppInfoFromZuulStack(String stack) {
        String[] stackSplit = stack.split("_");
        if (stackSplit == null || stackSplit.length != 2) {
            return false;
        }
        RibbonConfig.setApplicationName(stackSplit[0]);
        RibbonConfig.setApplicationStack(stackSplit[1]);
        return true;
    }

    public static String getApplicationName() {
        return APPLICATION_NAME;
    }

    public static void setApplicationName(String app_name) {
        APPLICATION_NAME = app_name;
        if (ZuulApplicationInfo.applicationName == null) {
            ZuulApplicationInfo.applicationName = app_name;
        }
        LOG.info("Setting back end VIP application = " + app_name);
    }

    public static String getApplicationStack() {
        return APPLICATION_STACK;
    }

    public static void setApplicationStack(String stack) {
        APPLICATION_STACK = stack;
        if (ZuulApplicationInfo.getStack() == null) {
            ZuulApplicationInfo.stack = stack;
        }
        LOG.info("Setting back end VIP stack = " + stack);
    }

    public static final boolean isAutodetectingBackendVips() {
        return AUTODETECT_BACKEND_VIPS.get();
    }

    public static final String getDefaultVipName() {
        String client = RibbonConfig.getApplicationName();
        if (client == null) {
            client = DEFAULT_CLIENT.get();
        }
        String namespace = DynamicPropertyFactory.getInstance().getStringProperty("zuul.ribbon.namespace", "ribbon").get();
        String vipTemplate = "%s." + namespace + ".DeploymentContextBasedVipAddresses";
        return String.format(vipTemplate, client);
    }

    public static final String getDefaultVipAddress(String stack) {
        String vipAddressTemplate;
        String client = RibbonConfig.getApplicationName();
        if (client == null) {
            client = DEFAULT_CLIENT.get();
        }
        if ((vipAddressTemplate = DynamicPropertyFactory.getInstance().getStringProperty("zuul.ribbon.vipAddress.template", null).get()) == null) {
            throw new RuntimeException("need to configure zuul.ribbon.vipAddress.template . eg zuul.ribbon.vipAddress.template=%s-%s.netflix.net:8888 where %s(1) is client and %s(2) is stack");
        }
        return String.format(vipAddressTemplate, client, stack);
    }

    public static final class UnitTest {
        @Test
        public void defaultVipAddressForStandardStack() {
        }

        @Test
        public void defaultVipAddressForLatAmStack() {
        }
    }
}

