/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.dependency.ribbon.hystrix;

import com.netflix.client.ClientRequest;
import com.netflix.client.http.HttpRequest;
import com.netflix.client.http.HttpResponse;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.hystrix.HystrixCommand;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandProperties;
import com.netflix.niws.client.http.RestClient;
import com.netflix.zuul.context.Headers;
import com.netflix.zuul.context.HttpQueryParams;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;

public class RibbonCommand
extends HystrixCommand<HttpResponse> {
    RestClient restClient;
    HttpRequest.Verb verb;
    URI uri;
    Headers headers;
    HttpQueryParams params;
    InputStream requestEntity;

    public RibbonCommand(RestClient restClient, HttpRequest.Verb verb, String uri, Headers headers, HttpQueryParams params, InputStream requestEntity) throws URISyntaxException {
        this("default", restClient, verb, uri, headers, params, requestEntity);
    }

    public RibbonCommand(String commandKey, RestClient restClient, HttpRequest.Verb verb, String uri, Headers headers, HttpQueryParams params, InputStream requestEntity) throws URISyntaxException {
        super(HystrixCommand.Setter.withGroupKey((HystrixCommandGroupKey)HystrixCommandGroupKey.Factory.asKey((String)commandKey)).andCommandPropertiesDefaults(HystrixCommandProperties.Setter().withExecutionIsolationStrategy(HystrixCommandProperties.ExecutionIsolationStrategy.SEMAPHORE).withExecutionIsolationSemaphoreMaxConcurrentRequests(DynamicPropertyFactory.getInstance().getIntProperty("zuul.eureka." + commandKey + ".semaphore.maxSemaphores", 100).get())));
        this.restClient = restClient;
        this.verb = verb;
        this.uri = new URI(uri);
        this.headers = headers;
        this.params = params;
        this.requestEntity = requestEntity;
    }

    protected HttpResponse run() throws Exception {
        return this.forward();
    }

    HttpResponse forward() throws Exception {
        HttpRequest.Builder builder = HttpRequest.newBuilder().verb(this.verb).uri(this.uri).entity((Object)this.requestEntity);
        for (Map.Entry<String, String> entry : this.headers.entries()) {
            builder.header(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, String> entry : this.params.entries()) {
            builder.queryParams(entry.getKey(), entry.getValue());
        }
        HttpRequest httpClientRequest = builder.build();
        return (HttpResponse)this.restClient.executeWithLoadBalancer((ClientRequest)httpClientRequest);
    }
}

