/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.filters;

import com.netflix.config.DynamicBooleanProperty;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.zuul.context.ZuulMessage;
import com.netflix.zuul.filters.BaseSyncFilter;
import com.netflix.zuul.filters.FilterPriority;
import com.netflix.zuul.filters.ZuulFilter;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public abstract class BaseFilter<I extends ZuulMessage, O extends ZuulMessage>
implements ZuulFilter<I, O> {
    private final DynamicBooleanProperty filterDisabled = DynamicPropertyFactory.getInstance().getBooleanProperty(this.disablePropertyName(), false);

    @Override
    public String filterName() {
        return this.getClass().getName();
    }

    @Override
    public FilterPriority getPriority() {
        return FilterPriority.NORMAL;
    }

    public String disablePropertyName() {
        return "zuul." + this.getClass().getSimpleName() + "." + this.filterType() + ".disable";
    }

    @Override
    public boolean isDisabled() {
        return this.filterDisabled.get();
    }

    public String toString() {
        return String.valueOf(this.filterType()) + ":" + String.valueOf(this.filterName());
    }

    public static class TestUnit {
        @Mock
        private BaseFilter f1;
        @Mock
        private BaseFilter f2;
        @Mock
        private ZuulMessage req;

        @Before
        public void before() {
            MockitoAnnotations.initMocks((Object)this);
        }

        @Test
        public void testShouldFilter() {
            class TestZuulFilter
            extends BaseSyncFilter {
                TestZuulFilter() {
                }

                @Override
                public int filterOrder() {
                    return 0;
                }

                @Override
                public String filterType() {
                    return "pre";
                }

                @Override
                public boolean shouldFilter(ZuulMessage req) {
                    return false;
                }

                public ZuulMessage apply(ZuulMessage req) {
                    return null;
                }
            }
            TestZuulFilter tf1 = (TestZuulFilter)Mockito.spy((Object)new TestZuulFilter());
            TestZuulFilter tf2 = (TestZuulFilter)Mockito.spy((Object)new TestZuulFilter());
            Mockito.when((Object)tf1.shouldFilter(this.req)).thenReturn((Object)true);
            Mockito.when((Object)tf2.shouldFilter(this.req)).thenReturn((Object)false);
        }
    }
}

