/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.init;

import com.google.inject.AbstractModule;
import com.netflix.config.ConfigurationManager;
import com.netflix.zuul.FilterFileManager;
import com.netflix.zuul.FilterProcessor;
import com.netflix.zuul.FilterUsageNotifier;
import org.apache.commons.configuration.AbstractConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZuulFiltersModule
extends AbstractModule {
    private static final Logger LOG = LoggerFactory.getLogger(ZuulFiltersModule.class);

    protected void configure() {
        LOG.info("Starting Groovy Filter file manager");
        AbstractConfiguration config = ConfigurationManager.getConfigInstance();
        String[] filterLocations = config.getStringArray("zuul.filters.locations");
        if (filterLocations == null || filterLocations.length == 0) {
            filterLocations = "inbound,outbound,endpoint".split(",");
        }
        LOG.info("Using filter locations: ");
        for (String location : filterLocations) {
            LOG.info("  " + location);
        }
        String[] filterClassNames = config.getStringArray("zuul.filters.classes");
        if (filterClassNames == null) {
            filterClassNames = new String[]{};
        }
        LOG.info("Using filter classnames: ");
        for (String className : filterClassNames) {
            LOG.info("  " + className);
        }
        FilterFileManager.FilterFileManagerConfig filterConfig = new FilterFileManager.FilterFileManagerConfig(filterLocations, filterClassNames, 5);
        this.bind(FilterFileManager.FilterFileManagerConfig.class).toInstance((Object)filterConfig);
        this.bind(FilterUsageNotifier.class).to(FilterProcessor.BasicFilterUsageNotifier.class);
        LOG.info("Groovy Filter file manager started");
    }
}

