/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.rx;

import io.netty.util.ReferenceCountUtil;
import io.netty.util.ReferenceCounted;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import rx.Observable;
import rx.Observer;
import rx.Subscriber;
import rx.functions.Action0;
import rx.functions.Action1;
import rx.internal.operators.NotificationLite;
import rx.observers.SerializedObserver;
import rx.observers.Subscribers;
import rx.subjects.Subject;
import rx.subscriptions.Subscriptions;

public final class UnicastDisposableCachingSubject<T extends ReferenceCounted>
extends Subject<T, T> {
    private final State<T> state;

    private UnicastDisposableCachingSubject(State<T> state) {
        super(new OnSubscribeAction<T>(state));
        this.state = state;
    }

    public static <T extends ReferenceCounted> UnicastDisposableCachingSubject<T> create() {
        State state = new State();
        return new UnicastDisposableCachingSubject(state);
    }

    public boolean hasObservers() {
        return this.state.isState(State.STATES.SUBSCRIBED);
    }

    public void dispose(Action1<T> disposedElementsProcessor) {
        if (this.state.casState(State.STATES.UNSUBSCRIBED, State.STATES.DISPOSED)) {
            this._dispose(disposedElementsProcessor);
        } else if (this.state.casState(State.STATES.SUBSCRIBED, State.STATES.DISPOSED)) {
            ((State)this.state).observerRef.onCompleted();
            this._dispose(disposedElementsProcessor);
        }
    }

    private void _dispose(Action1<T> disposedElementsProcessor) {
        Subscriber actualSub = Subscribers.create(disposedElementsProcessor);
        ((State)this.state).buffer.sendAllNotifications(actualSub);
        this.state.setObserverRef((Observer<T>)actualSub);
        ((State)this.state).buffer.sendAllNotifications(((State)this.state).observerRef);
    }

    public void onCompleted() {
        ((State)this.state).observerRef.onCompleted();
    }

    public void onError(Throwable e) {
        ((State)this.state).observerRef.onError(e);
    }

    public void onNext(T t) {
        ((State)this.state).observerRef.onNext(t);
    }

    private static final class ByteBufAwareBuffer<T> {
        private final ConcurrentLinkedQueue<Object> actual = new ConcurrentLinkedQueue();
        private final NotificationLite<T> nl = NotificationLite.instance();

        private ByteBufAwareBuffer() {
        }

        private void add(Object toAdd) {
            ReferenceCountUtil.retain((Object)toAdd);
            this.actual.add(toAdd);
        }

        public void sendAllNotifications(Observer<? super T> observer) {
            Object notification;
            while ((notification = this.actual.poll()) != null) {
                try {
                    this.nl.accept(observer, notification);
                }
                finally {
                    ReferenceCountUtil.release((Object)notification);
                }
            }
        }
    }

    private static final class OnSubscribeAction<T>
    implements Observable.OnSubscribe<T> {
        private final State<T> state;

        public OnSubscribeAction(State<T> state) {
            this.state = state;
        }

        public void call(Subscriber<? super T> subscriber) {
            if (this.state.casState(State.STATES.UNSUBSCRIBED, State.STATES.SUBSCRIBED)) {
                ((State)this.state).buffer.sendAllNotifications(subscriber);
                subscriber.add(Subscriptions.create((Action0)new Action0(){

                    public void call() {
                        state.setObserverRef(Subscribers.empty());
                    }
                }));
                this.state.setObserverRef((Observer<? super T>)subscriber);
                ((State)this.state).buffer.sendAllNotifications(((State)this.state).observerRef);
            } else if (State.STATES.SUBSCRIBED.ordinal() == ((State)this.state).state) {
                subscriber.onError((Throwable)new IllegalStateException("Content can only have one subscription. Use Observable.publish() if you want to multicast."));
            } else if (State.STATES.DISPOSED.ordinal() == ((State)this.state).state) {
                subscriber.onError((Throwable)new IllegalStateException("Content stream is already disposed."));
            }
        }
    }

    private static final class State<T> {
        private volatile int state = STATES.UNSUBSCRIBED.ordinal();
        private volatile Observer<? super T> observerRef = new BufferedObserver();
        private final ByteBufAwareBuffer<T> buffer = new ByteBufAwareBuffer();
        private static final AtomicReferenceFieldUpdater<State, Observer> OBSERVER_UPDATER = AtomicReferenceFieldUpdater.newUpdater(State.class, Observer.class, "observerRef");
        private static final AtomicIntegerFieldUpdater<State> STATE_UPDATER = AtomicIntegerFieldUpdater.newUpdater(State.class, "state");

        private State() {
        }

        public boolean casState(STATES expected, STATES next) {
            return STATE_UPDATER.compareAndSet(this, expected.ordinal(), next.ordinal());
        }

        public void setObserverRef(Observer<? super T> o) {
            this.observerRef = new SerializedObserver(o);
        }

        public boolean isState(STATES other) {
            return this.state == other.ordinal();
        }

        private final class BufferedObserver
        extends Subscriber<T> {
            private final NotificationLite<Object> nl = NotificationLite.instance();

            private BufferedObserver() {
            }

            public void onCompleted() {
                State.this.buffer.add(this.nl.completed());
            }

            public void onError(Throwable e) {
                State.this.buffer.add(this.nl.error(e));
            }

            public void onNext(T t) {
                State.this.buffer.add(this.nl.next(t));
            }
        }

        private static enum STATES {
            UNSUBSCRIBED,
            SUBSCRIBED,
            DISPOSED;

        }
    }
}

