/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.scriptManager;

import com.netflix.zuul.ZuulApplicationInfo;
import com.netflix.zuul.filters.BaseFilter;
import com.netflix.zuul.scriptManager.FilterInfo;
import groovy.lang.GroovyClassLoader;
import org.codehaus.groovy.control.CompilationFailedException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.MockitoAnnotations;

public class FilterVerifier {
    private static final FilterVerifier INSTANCE = new FilterVerifier();

    public static FilterVerifier getInstance() {
        return INSTANCE;
    }

    public FilterInfo verifyFilter(String sFilterCode) throws CompilationFailedException, IllegalAccessException, InstantiationException {
        Class groovyClass = this.compileGroovy(sFilterCode);
        Object instance = this.instanciateClass(groovyClass);
        this.checkZuulFilterInstance(instance);
        BaseFilter filter = (BaseFilter)instance;
        String filter_id = FilterInfo.buildFilterID(ZuulApplicationInfo.getApplicationName(), filter.filterType(), groovyClass.getSimpleName());
        return new FilterInfo(filter_id, sFilterCode, filter.filterType(), groovyClass.getSimpleName(), filter.disablePropertyName(), "" + filter.filterOrder(), ZuulApplicationInfo.getApplicationName());
    }

    Object instanciateClass(Class groovyClass) throws InstantiationException, IllegalAccessException {
        return groovyClass.newInstance();
    }

    void checkZuulFilterInstance(Object zuulFilter) throws InstantiationException {
        if (!(zuulFilter instanceof BaseFilter)) {
            throw new InstantiationException("Code is not a ZuulFilter Class ");
        }
    }

    public Class compileGroovy(String sFilterCode) throws CompilationFailedException {
        GroovyClassLoader loader = new GroovyClassLoader();
        return loader.parseClass(sFilterCode);
    }

    public static class UnitTest {
        String sGoodGroovyScriptFilter = "import com.netflix.zuul.filters.*\nimport com.netflix.zuul.context.*\n\nclass filter extends BaseSyncFilter<HttpRequestMessage, HttpRequestMessage> {\n\n    String filterType() {\n        return 'in'\n    }\n\n    int filterOrder() {\n        return 1\n    }\n\n    boolean shouldFilter(HttpRequestMessage req) {\n        return true\n    }\n\n    HttpRequestMessage apply(HttpRequestMessage req) {\n        return null\n    }\n\n\n}";
        String sNotZuulFilterGroovy = "import com.netflix.zuul.filters.*\nimport com.netflix.zuul.context.*\n\nclass filter  {\n\n    String filterType() {\n        return 'pre'\n    }\n\n    int filterOrder() {\n        return 1\n    }\n\n    boolean shouldFilter(SessionContext ctx) {\n        return true\n    }\n\n    SessionContext apply(SessionContext ctx) {\n        return null\n    }\n\n\n}";
        String sCompileFailCode = "import com.netflix.zuul.filters.*\nimport com.netflix.zuul.context.*\n\nccclass filter extends BaseSyncFilter<HttpRequestMessage, HttpRequestMessage> {\n\n    String filterType() {\n        return 'in'\n    }\n\n    int filterOrder() {\n        return 1\n    }\n\n    boolean shouldFilter(HttpRequestMessage req) {\n        return true\n    }\n\n    HttpRequestMessage apply(HttpRequestMessage req) {\n        return null\n    }\n\n\n}";

        @Before
        public void before() {
            MockitoAnnotations.initMocks((Object)this);
        }

        @Test
        public void testCompile() {
            Class filterClass = INSTANCE.compileGroovy(this.sGoodGroovyScriptFilter);
            Assert.assertNotNull((Object)filterClass);
            filterClass = INSTANCE.compileGroovy(this.sNotZuulFilterGroovy);
            Assert.assertNotNull((Object)filterClass);
            try {
                filterClass = INSTANCE.compileGroovy(this.sCompileFailCode);
                Assert.assertFalse((boolean)true);
            }
            catch (Exception e) {
                Assert.assertTrue((boolean)true);
            }
        }

        @Test
        public void testZuulFilterInstance() {
            Object filter;
            Class filterClass = INSTANCE.compileGroovy(this.sGoodGroovyScriptFilter);
            Assert.assertNotNull((Object)filterClass);
            try {
                filter = INSTANCE.instanciateClass(filterClass);
                try {
                    INSTANCE.checkZuulFilterInstance(filter);
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                    Assert.assertFalse((boolean)true);
                }
            }
            catch (InstantiationException e) {
                e.printStackTrace();
                Assert.assertFalse((boolean)true);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                Assert.assertFalse((boolean)true);
            }
            filterClass = INSTANCE.compileGroovy(this.sNotZuulFilterGroovy);
            Assert.assertNotNull((Object)filterClass);
            try {
                filter = INSTANCE.instanciateClass(filterClass);
                try {
                    INSTANCE.checkZuulFilterInstance(filter);
                    Assert.assertFalse((boolean)true);
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                    Assert.assertTrue((boolean)true);
                }
            }
            catch (InstantiationException e) {
                e.printStackTrace();
                Assert.assertFalse((boolean)true);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                Assert.assertFalse((boolean)true);
            }
        }

        @Test
        public void testVerify() {
            FilterInfo filterInfo;
            try {
                filterInfo = INSTANCE.verifyFilter(this.sGoodGroovyScriptFilter);
                Assert.assertNotNull((Object)filterInfo);
                Assert.assertEquals((Object)filterInfo.getFilterID(), (Object)"null:filter:in");
                Assert.assertEquals((Object)filterInfo.getFilterType(), (Object)"in");
                Assert.assertEquals((Object)filterInfo.getFilterName(), (Object)"filter");
                Assert.assertFalse((boolean)filterInfo.isActive());
                Assert.assertFalse((boolean)filterInfo.isCanary());
            }
            catch (InstantiationException e) {
                e.printStackTrace();
                Assert.assertFalse((boolean)true);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                Assert.assertFalse((boolean)true);
            }
            try {
                filterInfo = INSTANCE.verifyFilter(this.sNotZuulFilterGroovy);
                Assert.assertFalse((boolean)true);
            }
            catch (InstantiationException e) {
                e.printStackTrace();
                Assert.assertTrue((boolean)true);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                Assert.assertFalse((boolean)true);
            }
            try {
                filterInfo = INSTANCE.verifyFilter(this.sCompileFailCode);
                Assert.assertFalse((boolean)true);
            }
            catch (CompilationFailedException e) {
                Assert.assertTrue((boolean)true);
            }
            catch (InstantiationException e) {
                e.printStackTrace();
                Assert.assertFalse((boolean)true);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                Assert.assertFalse((boolean)true);
            }
        }
    }
}

