/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.stats;

import com.netflix.servo.monitor.DynamicTimer;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.zuul.context.SessionContext;
import com.netflix.zuul.stats.RequestMetricsPublisher;

public class BasicRequestMetricsPublisher
implements RequestMetricsPublisher {
    @Override
    public void collectAndPublish(SessionContext context) {
        long totalRequestTime = context.getTimings().getRequest().getDuration();
        long requestProxyTime = context.getTimings().getRequestProxy().getDuration();
        int originReportedDuration = context.getOriginReportedDuration();
        long totalInternalTime = totalRequestTime - requestProxyTime;
        long totalTimeAddedToOrigin = -1L;
        if (originReportedDuration > -1) {
            totalTimeAddedToOrigin = totalRequestTime - (long)originReportedDuration;
        }
        String METRIC_TIMINGS_REQ_PREFIX = "zuul.timings.request.";
        this.recordRequestTiming("zuul.timings.request.total", totalRequestTime);
        this.recordRequestTiming("zuul.timings.request.proxy", requestProxyTime);
        this.recordRequestTiming("zuul.timings.request.internal", totalInternalTime);
        this.recordRequestTiming("zuul.timings.request.added", totalTimeAddedToOrigin);
    }

    private void recordRequestTiming(String name, long time) {
        if (time > -1L) {
            DynamicTimer.record((MonitorConfig)MonitorConfig.builder((String)name).build(), (long)time);
        }
    }
}

