/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.stats;

import com.netflix.zuul.context.Headers;
import com.netflix.zuul.context.HttpRequestMessage;
import com.netflix.zuul.stats.NamedCountingMonitor;
import com.netflix.zuul.stats.RouteStatusCodeMonitor;
import com.netflix.zuul.stats.monitoring.MonitorRegistry;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatsManager {
    private static final Logger LOG = LoggerFactory.getLogger(StatsManager.class);
    protected static final Pattern HEX_PATTERN = Pattern.compile("[0-9a-fA-F]+");
    private static final Pattern HOST_PATTERN = Pattern.compile("(?:(.+)\\.amazonaws\\.com)|((?:\\d{1,3}\\.?){4})|(ip-\\d+-\\d+-\\d+-\\d+)|(?:(.+)\\.nflxvideo\\.net)|(?:(.+)\\.llnwd\\.net)|(?:(.+)\\.nflximg\\.com)");
    private static final String HOST_HEADER = "host";
    private static final String X_FORWARDED_FOR_HEADER = "x-forwarded-for";
    private static final String X_FORWARDED_PROTO_HEADER = "x-forwarded-proto";
    private final ConcurrentMap<String, ConcurrentHashMap<Integer, RouteStatusCodeMonitor>> routeStatusMap = new ConcurrentHashMap<String, ConcurrentHashMap<Integer, RouteStatusCodeMonitor>>();
    private final ConcurrentMap<String, NamedCountingMonitor> namedStatusMap = new ConcurrentHashMap<String, NamedCountingMonitor>();
    private final ConcurrentMap<String, NamedCountingMonitor> hostCounterMap = new ConcurrentHashMap<String, NamedCountingMonitor>();
    private final ConcurrentMap<String, NamedCountingMonitor> protocolCounterMap = new ConcurrentHashMap<String, NamedCountingMonitor>();
    private final ConcurrentMap<String, NamedCountingMonitor> ipVersionCounterMap = new ConcurrentHashMap<String, NamedCountingMonitor>();
    protected static StatsManager INSTANCE = new StatsManager();

    public static StatsManager getManager() {
        return INSTANCE;
    }

    public RouteStatusCodeMonitor getRouteStatusCodeMonitor(String route, int statusCode) {
        Map map = (Map)this.routeStatusMap.get(route);
        if (map == null) {
            return null;
        }
        return (RouteStatusCodeMonitor)map.get(statusCode);
    }

    private NamedCountingMonitor getHostMonitor(String host) {
        return (NamedCountingMonitor)this.hostCounterMap.get(StatsManager.hostKey(host));
    }

    private NamedCountingMonitor getProtocolMonitor(String proto) {
        return (NamedCountingMonitor)this.protocolCounterMap.get(StatsManager.protocolKey(proto));
    }

    private static final String hostKey(String host) {
        block9: {
            try {
                Matcher m = HOST_PATTERN.matcher(host);
                if (!m.matches()) break block9;
                if (m.group(1) != null) {
                    host = host.replace(m.group(1), "EC2");
                    break block9;
                }
                if (m.group(2) != null) {
                    host = host.replace(m.group(2), "IP");
                    break block9;
                }
                if (m.group(3) != null) {
                    host = host.replace(m.group(3), "IP");
                    break block9;
                }
                if (m.group(4) != null) {
                    host = host.replace(m.group(4), "CDN");
                    break block9;
                }
                if (m.group(5) != null) {
                    host = host.replace(m.group(5), "CDN");
                    break block9;
                }
                if (m.group(6) == null) break block9;
                host = host.replace(m.group(6), "CDN");
            }
            catch (Exception e) {
                try {
                    LOG.error(e.getMessage(), (Throwable)e);
                }
                catch (Throwable throwable) {
                    return String.format("host_%s", host);
                }
                return String.format("host_%s", host);
            }
        }
        return String.format("host_%s", host);
    }

    private static final String protocolKey(String proto) {
        return String.format("protocol_%s", proto);
    }

    public void collectRequestStats(HttpRequestMessage req) {
        String protocol;
        String xForwardedFor = req.getHeaders().getFirst(X_FORWARDED_FOR_HEADER);
        String clientIp = xForwardedFor == null ? req.getClientIp() : StatsManager.extractClientIpFromXForwardedFor(xForwardedFor);
        boolean isIPv6 = clientIp != null ? StatsManager.isIPv6(clientIp) : false;
        String ipVersionKey = isIPv6 ? "ipv6" : "ipv4";
        this.incrementNamedCountingMonitor(ipVersionKey, this.ipVersionCounterMap);
        String host = req.getHeaders().getFirst(HOST_HEADER);
        if (host != null) {
            int colonIdx = isIPv6 ? host.lastIndexOf(":") : host.indexOf(":");
            if (colonIdx > -1) {
                host = host.substring(0, colonIdx);
            }
            this.incrementNamedCountingMonitor(StatsManager.hostKey(host), this.hostCounterMap);
        }
        if ((protocol = req.getHeaders().getFirst(X_FORWARDED_PROTO_HEADER)) == null) {
            protocol = req.getScheme();
        }
        this.incrementNamedCountingMonitor(StatsManager.protocolKey(protocol), this.protocolCounterMap);
    }

    private static final boolean isIPv6(String ip) {
        return ip.split(":").length == 8;
    }

    private static final String extractClientIpFromXForwardedFor(String xForwardedFor) {
        return xForwardedFor.split(",")[0];
    }

    protected void incrementNamedCountingMonitor(String name, ConcurrentMap<String, NamedCountingMonitor> map) {
        NamedCountingMonitor monitor = (NamedCountingMonitor)map.get(name);
        if (monitor == null) {
            monitor = new NamedCountingMonitor(name);
            NamedCountingMonitor conflict = map.putIfAbsent(name, monitor);
            if (conflict != null) {
                monitor = conflict;
            } else {
                MonitorRegistry.getInstance().registerObject(monitor);
            }
        }
        monitor.increment();
    }

    public void collectRouteStats(String route, int statusCode) {
        RouteStatusCodeMonitor sd;
        ConcurrentHashMap<Integer, RouteStatusCodeMonitor> statsMap;
        String preciseStatusString = String.format("status_%d", statusCode);
        NamedCountingMonitor preciseStatus = (NamedCountingMonitor)this.namedStatusMap.get(preciseStatusString);
        if (preciseStatus == null) {
            preciseStatus = new NamedCountingMonitor(preciseStatusString);
            NamedCountingMonitor found = this.namedStatusMap.putIfAbsent(preciseStatusString, preciseStatus);
            if (found != null) {
                preciseStatus = found;
            } else {
                MonitorRegistry.getInstance().registerObject(preciseStatus);
            }
        }
        preciseStatus.increment();
        String summaryStatusString = String.format("status_%dxx", statusCode / 100);
        NamedCountingMonitor summaryStatus = (NamedCountingMonitor)this.namedStatusMap.get(summaryStatusString);
        if (summaryStatus == null) {
            summaryStatus = new NamedCountingMonitor(summaryStatusString);
            NamedCountingMonitor found = this.namedStatusMap.putIfAbsent(summaryStatusString, summaryStatus);
            if (found != null) {
                summaryStatus = found;
            } else {
                MonitorRegistry.getInstance().registerObject(summaryStatus);
            }
        }
        summaryStatus.increment();
        if (route == null) {
            route = "ROUTE_NOT_FOUND";
        }
        if ((statsMap = (ConcurrentHashMap<Integer, RouteStatusCodeMonitor>)this.routeStatusMap.get(route = route.replace("/", "_"))) == null) {
            statsMap = new ConcurrentHashMap<Integer, RouteStatusCodeMonitor>();
            this.routeStatusMap.putIfAbsent(route, statsMap);
        }
        if ((sd = (RouteStatusCodeMonitor)statsMap.get(statusCode)) == null) {
            if (statusCode == 404 && statsMap.size() == 0) {
                return;
            }
            sd = new RouteStatusCodeMonitor(route, statusCode);
            RouteStatusCodeMonitor sd1 = statsMap.putIfAbsent(statusCode, sd);
            if (sd1 != null) {
                sd = sd1;
            } else {
                MonitorRegistry.getInstance().registerObject(sd);
            }
        }
        sd.update();
    }

    @RunWith(value=MockitoJUnitRunner.class)
    public static class UnitTest {
        @Test
        public void testCollectRouteStats() {
            String route = "test";
            int status = 500;
            StatsManager sm = StatsManager.getManager();
            Assert.assertNotNull((Object)sm);
            sm.collectRouteStats(route, status);
            ConcurrentHashMap routeStatusMap = (ConcurrentHashMap)sm.routeStatusMap.get("test");
            Assert.assertNotNull((Object)routeStatusMap);
            RouteStatusCodeMonitor routeStatusMonitor = (RouteStatusCodeMonitor)routeStatusMap.get(status);
            sm.collectRouteStats(route, status);
        }

        @Test
        public void testGetRouteStatusCodeMonitor() {
            StatsManager sm = StatsManager.getManager();
            Assert.assertNotNull((Object)sm);
            sm.collectRouteStats("test", 500);
            Assert.assertNotNull((Object)sm.getRouteStatusCodeMonitor("test", 500));
        }

        @Test
        public void testCollectRequestStats() {
            String host = "api.netflix.com";
            String proto = "https";
            HttpRequestMessage req = (HttpRequestMessage)Mockito.mock(HttpRequestMessage.class);
            Headers headers = new Headers();
            Mockito.when((Object)req.getHeaders()).thenReturn((Object)headers);
            headers.set(StatsManager.HOST_HEADER, "api.netflix.com");
            headers.set(StatsManager.X_FORWARDED_PROTO_HEADER, "https");
            Mockito.when((Object)req.getClientIp()).thenReturn((Object)"127.0.0.1");
            StatsManager sm = StatsManager.getManager();
            sm.collectRequestStats(req);
            NamedCountingMonitor hostMonitor = sm.getHostMonitor("api.netflix.com");
            Assert.assertNotNull((String)"hostMonitor should not be null", (Object)hostMonitor);
            NamedCountingMonitor protoMonitor = sm.getProtocolMonitor("https");
            Assert.assertNotNull((String)"protoMonitor should not be null", (Object)protoMonitor);
            Assert.assertEquals((long)1L, (long)hostMonitor.getCount());
            Assert.assertEquals((long)1L, (long)protoMonitor.getCount());
        }

        @Test
        public void createsNormalizedHostKey() {
            Assert.assertEquals((Object)"host_EC2.amazonaws.com", (Object)StatsManager.hostKey("ec2-174-129-179-89.compute-1.amazonaws.com"));
            Assert.assertEquals((Object)"host_IP", (Object)StatsManager.hostKey("12.345.6.789"));
            Assert.assertEquals((Object)"host_IP", (Object)StatsManager.hostKey("ip-10-86-83-168"));
            Assert.assertEquals((Object)"host_CDN.nflxvideo.net", (Object)StatsManager.hostKey("002.ie.llnw.nflxvideo.net"));
            Assert.assertEquals((Object)"host_CDN.llnwd.net", (Object)StatsManager.hostKey("netflix-635.vo.llnwd.net"));
            Assert.assertEquals((Object)"host_CDN.nflximg.com", (Object)StatsManager.hostKey("cdn-0.nflximg.com"));
        }

        @Test
        public void extractsClientIpFromXForwardedFor() {
            String ip1 = "hi";
            String ip2 = "hey";
            Assert.assertEquals((Object)"hi", (Object)StatsManager.extractClientIpFromXForwardedFor("hi"));
            Assert.assertEquals((Object)"hi", (Object)StatsManager.extractClientIpFromXForwardedFor(String.format("%s,%s", "hi", "hey")));
            Assert.assertEquals((Object)"hi", (Object)StatsManager.extractClientIpFromXForwardedFor(String.format("%s, %s", "hi", "hey")));
        }

        @Test
        public void isIPv6() {
            Assert.assertTrue((boolean)StatsManager.isIPv6("0:0:0:0:0:0:0:1"));
            Assert.assertTrue((boolean)StatsManager.isIPv6("2607:fb10:2:232:72f3:95ff:fe03:a6e7"));
            Assert.assertFalse((boolean)StatsManager.isIPv6("127.0.0.1"));
            Assert.assertFalse((boolean)StatsManager.isIPv6("10.2.233.134"));
        }
    }
}

