/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.util;

import com.netflix.zuul.context.Headers;
import com.netflix.zuul.context.HttpRequestMessage;
import org.junit.Assert;
import org.junit.Test;

public class HttpUtils {
    public static final String X_FORWARDED_FOR_HEADER = "x-forwarded-for";

    public static String getClientIP(HttpRequestMessage request) {
        String xForwardedFor = request.getHeaders().getFirst(X_FORWARDED_FOR_HEADER);
        String clientIP = xForwardedFor == null ? request.getClientIp() : HttpUtils.extractClientIpFromXForwardedFor(xForwardedFor);
        return clientIP;
    }

    public static String extractClientIpFromXForwardedFor(String xForwardedFor) {
        if (xForwardedFor == null) {
            return null;
        }
        String[] tokenized = (xForwardedFor = xForwardedFor.trim()).split(",");
        if (tokenized.length == 0) {
            return null;
        }
        return tokenized[0].trim();
    }

    public static boolean isGzipped(String contentEncoding) {
        return contentEncoding.contains("gzip");
    }

    public static boolean isGzipped(Headers headers) {
        String ce = headers.getFirst("Content-Encoding");
        return ce != null && HttpUtils.isGzipped(ce);
    }

    public static boolean acceptsGzip(Headers headers) {
        String ae = headers.getFirst("accept-encoding");
        return ae != null && HttpUtils.isGzipped(ae);
    }

    public static class UnitTest {
        @Test
        public void detectsGzip() {
            Assert.assertTrue((boolean)HttpUtils.isGzipped("gzip"));
        }

        @Test
        public void detectsNonGzip() {
            Assert.assertFalse((boolean)HttpUtils.isGzipped("identity"));
        }

        @Test
        public void detectsGzipAmongOtherEncodings() {
            Assert.assertTrue((boolean)HttpUtils.isGzipped("gzip, deflate"));
        }
    }
}

