/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.util;

import com.netflix.client.http.HttpResponse;
import com.netflix.zuul.context.HttpRequestMessage;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.runners.MockitoJUnitRunner;

public class ProxyUtils {
    public static boolean isValidRequestHeader(String headerName) {
        switch (headerName.toLowerCase()) {
            case "connection": 
            case "content-length": 
            case "transfer-encoding": {
                return false;
            }
        }
        return true;
    }

    public static boolean isValidResponseHeader(String headerName) {
        switch (headerName.toLowerCase()) {
            case "connection": 
            case "content-length": 
            case "server": 
            case "transfer-encoding": {
                return false;
            }
        }
        return true;
    }

    @RunWith(value=MockitoJUnitRunner.class)
    public static class TestUnit {
        @Mock
        HttpResponse proxyResp;
        @Mock
        HttpRequestMessage request;

        @Test
        public void testIsValidResponseHeader() {
            Assert.assertTrue((boolean)ProxyUtils.isValidResponseHeader("test"));
            Assert.assertFalse((boolean)ProxyUtils.isValidResponseHeader("content-length"));
            Assert.assertFalse((boolean)ProxyUtils.isValidResponseHeader("connection"));
        }
    }
}

