/*
 * Decompiled with CFR 0.152.
 */
package mantis.io.reactivex.netty.client;

import mantis.io.reactivex.netty.metrics.AbstractMetricsEvent;
import mantis.io.reactivex.netty.metrics.MetricsEvent;

public class ClientMetricsEvent<T extends Enum>
extends AbstractMetricsEvent<T> {
    public static final ClientMetricsEvent<EventType> CONNECT_START = ClientMetricsEvent.from(EventType.ConnectStart);
    public static final ClientMetricsEvent<EventType> CONNECT_SUCCESS = ClientMetricsEvent.from(EventType.ConnectSuccess);
    public static final ClientMetricsEvent<EventType> CONNECT_FAILED = ClientMetricsEvent.from(EventType.ConnectFailed);
    public static final ClientMetricsEvent<EventType> CONNECTION_CLOSE_START = ClientMetricsEvent.from(EventType.ConnectionCloseStart);
    public static final ClientMetricsEvent<EventType> CONNECTION_CLOSE_SUCCESS = ClientMetricsEvent.from(EventType.ConnectionCloseSuccess);
    public static final ClientMetricsEvent<EventType> CONNECTION_CLOSE_FAILED = ClientMetricsEvent.from(EventType.ConnectionCloseFailed);
    public static final ClientMetricsEvent<EventType> POOL_ACQUIRE_START = ClientMetricsEvent.from(EventType.PoolAcquireStart);
    public static final ClientMetricsEvent<EventType> POOL_ACQUIRE_SUCCESS = ClientMetricsEvent.from(EventType.PoolAcquireSuccess);
    public static final ClientMetricsEvent<EventType> POOL_ACQUIRE_FAILED = ClientMetricsEvent.from(EventType.PoolAcquireFailed);
    public static final ClientMetricsEvent<EventType> POOL_RELEASE_START = ClientMetricsEvent.from(EventType.PoolReleaseStart);
    public static final ClientMetricsEvent<EventType> POOL_RELEASE_SUCCESS = ClientMetricsEvent.from(EventType.PoolReleaseSuccess);
    public static final ClientMetricsEvent<EventType> POOL_RELEASE_FAILED = ClientMetricsEvent.from(EventType.PoolReleaseFailed);
    public static final ClientMetricsEvent<EventType> POOLED_CONNECTION_REUSE = ClientMetricsEvent.from(EventType.PooledConnectionReuse);
    public static final ClientMetricsEvent<EventType> POOLED_CONNECTION_EVICTION = ClientMetricsEvent.from(EventType.PooledConnectionEviction);
    public static final ClientMetricsEvent<EventType> WRITE_START = ClientMetricsEvent.from(EventType.WriteStart);
    public static final ClientMetricsEvent<EventType> WRITE_SUCCESS = ClientMetricsEvent.from(EventType.WriteSuccess);
    public static final ClientMetricsEvent<EventType> WRITE_FAILED = ClientMetricsEvent.from(EventType.WriteFailed);
    public static final ClientMetricsEvent<EventType> FLUSH_START = ClientMetricsEvent.from(EventType.FlushStart);
    public static final ClientMetricsEvent<EventType> FLUSH_SUCCESS = ClientMetricsEvent.from(EventType.FlushSuccess);
    public static final ClientMetricsEvent<EventType> FLUSH_FAILED = ClientMetricsEvent.from(EventType.FlushFailed);
    public static final ClientMetricsEvent<EventType> BYTES_READ = ClientMetricsEvent.from(EventType.BytesRead);

    protected ClientMetricsEvent(T name, boolean isTimed, boolean isError) {
        super(name, isTimed, isError);
    }

    private static ClientMetricsEvent<EventType> from(EventType type) {
        return new ClientMetricsEvent<EventType>(type, type.isTimed(), type.isError());
    }

    public static enum EventType implements MetricsEvent.MetricEventType
    {
        ConnectStart(false, false, Void.class),
        ConnectSuccess(true, false, Void.class),
        ConnectFailed(true, true, Void.class),
        ConnectionCloseStart(false, false, Void.class),
        ConnectionCloseSuccess(true, false, Void.class),
        ConnectionCloseFailed(true, true, Void.class),
        PoolAcquireStart(false, false, Void.class),
        PoolAcquireSuccess(true, false, Void.class),
        PoolAcquireFailed(true, true, Void.class),
        PooledConnectionReuse(true, false, Void.class),
        PooledConnectionEviction(false, false, Void.class),
        PoolReleaseStart(false, false, Void.class),
        PoolReleaseSuccess(true, false, Void.class),
        PoolReleaseFailed(true, true, Void.class),
        WriteStart(false, false, Long.class),
        WriteSuccess(true, false, Long.class),
        WriteFailed(true, true, Integer.class),
        FlushStart(false, false, Void.class),
        FlushSuccess(true, false, Void.class),
        FlushFailed(true, true, Void.class),
        BytesRead(false, false, Integer.class);

        private final boolean isTimed;
        private final boolean isError;
        private final Class<?> optionalDataType;

        private EventType(boolean isTimed, boolean isError, Class<?> optionalDataType) {
            this.isTimed = isTimed;
            this.isError = isError;
            this.optionalDataType = optionalDataType;
        }

        @Override
        public boolean isTimed() {
            return this.isTimed;
        }

        @Override
        public boolean isError() {
            return this.isError;
        }

        @Override
        public Class<?> getOptionalDataType() {
            return this.optionalDataType;
        }
    }
}

