/*
 * Decompiled with CFR 0.152.
 */
package mantis.io.reactivex.netty.protocol.http.client;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import java.util.concurrent.TimeUnit;
import mantis.io.reactivex.netty.client.ClientMetricsEvent;
import mantis.io.reactivex.netty.metrics.MetricEventsSubject;
import mantis.io.reactivex.netty.pipeline.PipelineConfigurator;
import mantis.io.reactivex.netty.protocol.http.client.ClientRequestResponseConverter;
import mantis.io.reactivex.netty.protocol.http.client.HttpClientRequest;
import mantis.io.reactivex.netty.protocol.http.client.HttpClientResponse;

class ClientRequiredConfigurator<I, O>
implements PipelineConfigurator<HttpClientResponse<O>, HttpClientRequest<I>> {
    private final MetricEventsSubject<ClientMetricsEvent<?>> eventsSubject;
    private final long responseSubscriptionTimeout;
    private final TimeUnit responseSubscriptionTimeoutUnit;

    public ClientRequiredConfigurator(MetricEventsSubject<ClientMetricsEvent<?>> eventsSubject) {
        this(eventsSubject, 0L, TimeUnit.MILLISECONDS);
    }

    public ClientRequiredConfigurator(MetricEventsSubject<ClientMetricsEvent<?>> eventsSubject, long responseSubscriptionTimeout, TimeUnit responseSubscriptionTimeoutUnit) {
        this.eventsSubject = eventsSubject;
        this.responseSubscriptionTimeout = responseSubscriptionTimeout;
        this.responseSubscriptionTimeoutUnit = responseSubscriptionTimeoutUnit;
    }

    @Override
    public void configureNewPipeline(ChannelPipeline pipeline) {
        ClientRequestResponseConverter converter = (ClientRequestResponseConverter)pipeline.get(ClientRequestResponseConverter.class);
        if (null == converter) {
            pipeline.addLast("request-response-converter", (ChannelHandler)new ClientRequestResponseConverter(this.eventsSubject, this.responseSubscriptionTimeout, this.responseSubscriptionTimeoutUnit));
        }
    }
}

