/*
 * Decompiled with CFR 0.152.
 */
package com.netopyr.wurmloch.crdt;

import com.netopyr.wurmloch.crdt.Crdt;
import com.netopyr.wurmloch.crdt.CrdtCommand;
import com.netopyr.wurmloch.crdt.CrdtSubscriber;
import io.reactivex.processors.PublishProcessor;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import javaslang.Function4;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.reactivestreams.Processor;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

public class GSet<T>
extends AbstractSet<T>
implements Crdt {
    private final String id;
    private final Set<T> elements = new HashSet<T>();
    private final Processor<CrdtCommand, CrdtCommand> commands = PublishProcessor.create();

    public GSet(String id, Publisher<? extends CrdtCommand> inCommands, Subscriber<? super CrdtCommand> outCommands) {
        this.id = Objects.requireNonNull(id, "Id must not be null");
        inCommands.subscribe((Subscriber)new CrdtSubscriber(this::processCommand));
        this.commands.subscribe(outCommands);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Function4<String, String, Publisher<? extends CrdtCommand>, Subscriber<? super CrdtCommand>, Crdt> getFactory() {
        return (Function4 & Serializable)(nodeId, id, inCommands, outCommands) -> new GSet((String)id, (Publisher<CrdtCommand>)((Publisher<? extends CrdtCommand>)inCommands), (Subscriber<CrdtCommand>)((Subscriber<? super CrdtCommand>)outCommands));
    }

    @Override
    public int size() {
        return this.elements.size();
    }

    @Override
    public Iterator<T> iterator() {
        return new GSetIterator();
    }

    @Override
    public boolean add(T element) {
        this.commands.onNext(new AddCommand<T>(this.id, element));
        return this.doAdd(element);
    }

    private synchronized boolean doAdd(T element) {
        return this.elements.add(element);
    }

    private void processCommand(CrdtCommand command) {
        Class<?> clazz = command.getClass();
        if (AddCommand.class.equals(clazz)) {
            this.doAdd(((AddCommand)command).getElement());
        }
    }

    static final class AddCommand<T>
    extends CrdtCommand {
        private final T element;

        AddCommand(String crdtId, T element) {
            super(crdtId);
            this.element = element;
        }

        T getElement() {
            return this.element;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AddCommand that = (AddCommand)o;
            return new EqualsBuilder().appendSuper(super.equals(o)).append(this.element, that.element).isEquals();
        }

        @Override
        public int hashCode() {
            return new HashCodeBuilder(17, 37).appendSuper(super.hashCode()).append(this.element).toHashCode();
        }

        @Override
        public String toString() {
            return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).appendSuper(super.toString()).append("crdtId", (Object)this.getCrdtId()).append("element", this.element).toString();
        }
    }

    private class GSetIterator
    implements Iterator<T> {
        final Iterator<T> it;

        private GSetIterator() {
            this.it = GSet.this.elements.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public T next() {
            return this.it.next();
        }
    }
}

