/*
 * Decompiled with CFR 0.152.
 */
package com.netopyr.wurmloch.crdt;

import com.netopyr.wurmloch.crdt.Crdt;
import com.netopyr.wurmloch.crdt.CrdtCommand;
import com.netopyr.wurmloch.crdt.CrdtSubscriber;
import io.reactivex.processors.PublishProcessor;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javaslang.Function4;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.reactivestreams.Processor;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

public class ORSet<T>
extends AbstractSet<T>
implements Crdt {
    private final String id;
    private final Set<Element<T>> elements = new HashSet<Element<T>>();
    private final Set<Element<T>> tombstone = new HashSet<Element<T>>();
    private final Processor<CrdtCommand, CrdtCommand> commands = PublishProcessor.create();

    public ORSet(String id, Publisher<? extends CrdtCommand> inCommands, Subscriber<? super CrdtCommand> outCommands) {
        this.id = Objects.requireNonNull(id, "Id must not be null");
        inCommands.subscribe((Subscriber)new CrdtSubscriber(this::processCommand));
        this.commands.subscribe(outCommands);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Function4<String, String, Publisher<? extends CrdtCommand>, Subscriber<? super CrdtCommand>, Crdt> getFactory() {
        return (Function4 & Serializable)(nodeId, id, inCommands, outCommands) -> new ORSet((String)id, (Publisher<CrdtCommand>)((Publisher<? extends CrdtCommand>)inCommands), (Subscriber<CrdtCommand>)((Subscriber<? super CrdtCommand>)outCommands));
    }

    @Override
    public int size() {
        return this.doElements().size();
    }

    @Override
    public Iterator<T> iterator() {
        return new ORSetIterator();
    }

    @Override
    public boolean add(T value) {
        boolean contained = this.doContains(value);
        this.prepareAdd(value);
        return !contained;
    }

    private static <U> Predicate<Element<U>> matches(U value) {
        return element -> Objects.equals(value, element.getValue());
    }

    private synchronized boolean doContains(T value) {
        return this.elements.parallelStream().anyMatch(ORSet.matches(value));
    }

    private synchronized Set<T> doElements() {
        return this.elements.parallelStream().map(Element::getValue).collect(Collectors.toSet());
    }

    private synchronized void prepareAdd(T value) {
        Element<T> element = new Element<T>(value, UUID.randomUUID());
        this.commands.onNext(new AddCommand<T>(this.getId(), element));
        this.doAdd(element);
    }

    private synchronized void doAdd(Element<T> element) {
        this.elements.add(element);
        this.elements.removeAll(this.tombstone);
    }

    private synchronized void prepareRemove(T value) {
        Set removes = this.elements.parallelStream().filter(ORSet.matches(value)).collect(Collectors.toSet());
        this.commands.onNext(new RemoveCommand(this.getId(), removes));
        this.doRemove(removes);
    }

    private synchronized void doRemove(Collection<Element<T>> removes) {
        this.elements.removeAll(removes);
        this.tombstone.addAll(removes);
    }

    private void processCommand(CrdtCommand command) {
        Class<?> clazz = command.getClass();
        if (AddCommand.class.equals(clazz)) {
            this.doAdd(((AddCommand)command).getElement());
        } else if (RemoveCommand.class.equals(clazz)) {
            this.doRemove(((RemoveCommand)command).getElements());
        }
    }

    static final class RemoveCommand<T>
    extends CrdtCommand {
        private final Set<Element<T>> elements;

        RemoveCommand(String crdt, Set<Element<T>> elements) {
            super(crdt);
            this.elements = elements;
        }

        Set<Element<T>> getElements() {
            return this.elements;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RemoveCommand that = (RemoveCommand)o;
            return new EqualsBuilder().appendSuper(super.equals(o)).append(this.elements, that.elements).isEquals();
        }

        @Override
        public int hashCode() {
            return new HashCodeBuilder(17, 37).appendSuper(super.hashCode()).append(this.elements).toHashCode();
        }

        @Override
        public String toString() {
            return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).appendSuper(super.toString()).append("crdtId", (Object)this.getCrdtId()).append("elements", this.elements).toString();
        }
    }

    static final class AddCommand<T>
    extends CrdtCommand {
        private final Element<T> element;

        AddCommand(String crdtId, Element<T> element) {
            super(crdtId);
            this.element = element;
        }

        Element<T> getElement() {
            return this.element;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AddCommand that = (AddCommand)o;
            return new EqualsBuilder().appendSuper(super.equals(o)).append(this.element, that.element).isEquals();
        }

        @Override
        public int hashCode() {
            return new HashCodeBuilder(17, 37).appendSuper(super.hashCode()).append(this.element).toHashCode();
        }

        @Override
        public String toString() {
            return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).appendSuper(super.toString()).append("crdtId", (Object)this.getCrdtId()).append("element", this.element).toString();
        }
    }

    static final class Element<T> {
        private final T value;
        private final UUID uuid;

        Element(T value, UUID uuid) {
            this.value = value;
            this.uuid = uuid;
        }

        T getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Element element = (Element)o;
            return new EqualsBuilder().append(this.value, element.value).append((Object)this.uuid, (Object)element.uuid).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder(17, 37).append(this.value).append((Object)this.uuid).toHashCode();
        }

        public String toString() {
            return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("value", this.value).append("uuid", (Object)this.uuid).toString();
        }
    }

    private class ORSetIterator
    implements Iterator<T> {
        final Iterator<T> it;
        T lastElement;

        private ORSetIterator() {
            this.it = ORSet.this.doElements().iterator();
            this.lastElement = null;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public T next() {
            this.lastElement = this.it.next();
            return this.lastElement;
        }

        @Override
        public void remove() {
            this.it.remove();
            ORSet.this.prepareRemove(this.lastElement);
        }
    }
}

