/*
 * Decompiled with CFR 0.152.
 */
package com.netopyr.wurmloch.crdt;

import com.netopyr.wurmloch.crdt.Crdt;
import com.netopyr.wurmloch.crdt.CrdtCommand;
import com.netopyr.wurmloch.crdt.CrdtSubscriber;
import io.reactivex.processors.PublishProcessor;
import java.util.Objects;
import javaslang.Function4;
import javaslang.collection.HashMap;
import javaslang.collection.Map;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.reactivestreams.Processor;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

public class PNCounter
implements Crdt {
    private final String nodeId;
    private final String id;
    private final Processor<CrdtCommand, CrdtCommand> commands = PublishProcessor.create();
    private Map<String, Long> pEntries = HashMap.empty();
    private Map<String, Long> nEntries = HashMap.empty();

    public PNCounter(String nodeId, String id, Publisher<? extends CrdtCommand> inCommands, Subscriber<? super CrdtCommand> outCommands) {
        this.nodeId = Objects.requireNonNull(nodeId, "NodeId must not be null");
        this.id = Objects.requireNonNull(id, "Id must not be null");
        inCommands = Objects.requireNonNull(inCommands, "InCommands must not be null");
        outCommands = Objects.requireNonNull(outCommands, "OutCommands must not be null");
        inCommands.subscribe((Subscriber)new CrdtSubscriber(this::processCommand));
        this.commands.subscribe(outCommands);
    }

    @Override
    public Function4<String, String, Publisher<? extends CrdtCommand>, Subscriber<? super CrdtCommand>, Crdt> getFactory() {
        return PNCounter::new;
    }

    @Override
    public String getId() {
        return this.id;
    }

    private void processCommand(CrdtCommand command) {
        if (UpdateCommand.class.equals(command.getClass())) {
            UpdateCommand updateCommand = (UpdateCommand)command;
            this.pEntries = this.pEntries.merge(updateCommand.pEntries, Math::max);
            this.nEntries = this.nEntries.merge(updateCommand.nEntries, Math::max);
        }
    }

    public long get() {
        return this.pEntries.values().sum().longValue() - this.nEntries.values().sum().longValue();
    }

    public void increment() {
        this.increment(1L);
    }

    public void increment(long value) {
        if (value < 1L) {
            throw new IllegalArgumentException("Value needs to be a positive number.");
        }
        this.pEntries = this.pEntries.put((Object)this.nodeId, (Object)((Long)this.pEntries.get((Object)this.nodeId).getOrElse((Object)0L) + value));
        this.commands.onNext((Object)new UpdateCommand(this.id, this.pEntries, this.nEntries));
    }

    public void decrement() {
        this.decrement(1L);
    }

    public void decrement(long value) {
        if (value < 1L) {
            throw new IllegalArgumentException("Value needs to be a positive number.");
        }
        this.nEntries = this.nEntries.put((Object)this.nodeId, (Object)((Long)this.nEntries.get((Object)this.nodeId).getOrElse((Object)0L) + value));
        this.commands.onNext((Object)new UpdateCommand(this.id, this.pEntries, this.nEntries));
    }

    static final class UpdateCommand
    extends CrdtCommand {
        private final Map<String, Long> pEntries;
        private final Map<String, Long> nEntries;

        private UpdateCommand(String crdtId, Map<String, Long> pEntries, Map<String, Long> nEntries) {
            super(crdtId);
            this.pEntries = Objects.requireNonNull(pEntries, "PEntries must not be null");
            this.nEntries = Objects.requireNonNull(nEntries, "NEntries must not be null");
        }

        Map<String, Long> getPEntries() {
            return this.pEntries;
        }

        Map<String, Long> getNEntries() {
            return this.nEntries;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UpdateCommand that = (UpdateCommand)o;
            return new EqualsBuilder().appendSuper(super.equals(o)).append(this.pEntries, that.pEntries).append(this.nEntries, that.nEntries).isEquals();
        }

        @Override
        public int hashCode() {
            return new HashCodeBuilder(17, 37).appendSuper(super.hashCode()).append(this.pEntries).append(this.nEntries).toHashCode();
        }

        @Override
        public String toString() {
            return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).appendSuper(super.toString()).append("pEntries", this.pEntries).append("nEntries", this.nEntries).toString();
        }
    }
}

