/*
 * Decompiled with CFR 0.152.
 */
package com.netopyr.wurmloch.examples;

import com.netopyr.wurmloch.crdt.RGA;
import com.netopyr.wurmloch.store.LocalCrdtStore;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;

public class RGAExample {
    public static void main(String[] args) {
        LocalCrdtStore crdtStore1 = new LocalCrdtStore();
        LocalCrdtStore crdtStore2 = new LocalCrdtStore();
        crdtStore1.connect(crdtStore2);
        RGA replica1 = crdtStore1.createRGA("ID_1");
        RGA replica2 = (RGA)crdtStore2.findRGA("ID_1").get();
        replica1.add("apple");
        replica2.add("banana");
        MatcherAssert.assertThat((Object)replica1, (Matcher)Matchers.contains((Object[])new String[]{"apple", "banana"}));
        MatcherAssert.assertThat((Object)replica2, (Matcher)Matchers.contains((Object[])new String[]{"apple", "banana"}));
        crdtStore1.disconnect(crdtStore2);
        replica1.remove("banana");
        replica2.add(1, "strawberry");
        MatcherAssert.assertThat((Object)replica1, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"apple"}));
        MatcherAssert.assertThat((Object)replica2, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"apple", "strawberry", "banana"}));
        crdtStore1.connect(crdtStore2);
        MatcherAssert.assertThat((Object)replica1, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"apple", "strawberry"}));
        MatcherAssert.assertThat((Object)replica2, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"apple", "strawberry"}));
        crdtStore1.disconnect(crdtStore2);
        replica1.remove(0);
        replica1.add("pear");
        replica2.remove(0);
        replica2.add("orange");
        MatcherAssert.assertThat((Object)replica1, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"pear", "strawberry"}));
        MatcherAssert.assertThat((Object)replica2, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"orange", "strawberry"}));
        crdtStore1.connect(crdtStore2);
        MatcherAssert.assertThat((Object)replica1, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"orange", "pear", "strawberry"}));
        MatcherAssert.assertThat((Object)replica2, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"orange", "pear", "strawberry"}));
    }
}

