/*
 * Decompiled with CFR 0.152.
 */
package com.netopyr.wurmloch.store;

import com.netopyr.wurmloch.crdt.Crdt;
import com.netopyr.wurmloch.crdt.CrdtCommand;
import com.netopyr.wurmloch.crdt.GCounter;
import com.netopyr.wurmloch.crdt.GSet;
import com.netopyr.wurmloch.crdt.LWWRegister;
import com.netopyr.wurmloch.crdt.MVRegister;
import com.netopyr.wurmloch.crdt.ORSet;
import com.netopyr.wurmloch.crdt.PNCounter;
import com.netopyr.wurmloch.crdt.RGA;
import com.netopyr.wurmloch.store.CrdtStore;
import io.reactivex.processors.PublishProcessor;
import io.reactivex.processors.ReplayProcessor;
import io.reactivex.subscribers.DisposableSubscriber;
import java.util.Objects;
import java.util.UUID;
import javaslang.Function4;
import javaslang.collection.HashMap;
import javaslang.collection.HashSet;
import javaslang.collection.Map;
import javaslang.collection.Set;
import javaslang.control.Option;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

class AbstractCrdtStore
implements CrdtStore {
    private Set<CrdtCommand> commands = HashSet.empty();
    private final String nodeId;
    private final PublishProcessor<CrdtCommand> inCommandsEntry = PublishProcessor.create();
    private final PublishProcessor<CrdtCommand> inCommandsExit = PublishProcessor.create();
    private final PublishProcessor<CrdtCommand> outCommandsEntry = PublishProcessor.create();
    private final ReplayProcessor<CrdtCommand> outCommandsExit = ReplayProcessor.create();
    private Map<String, Crdt> crdts = HashMap.empty();

    AbstractCrdtStore() {
        this(UUID.randomUUID().toString());
    }

    AbstractCrdtStore(String nodeId) {
        this.nodeId = nodeId;
        this.inCommandsEntry.filter(command -> !this.commands.contains(command)).doOnNext(command -> {
            this.commands = this.commands.add(command);
        }).subscribe(this.inCommandsExit);
        this.outCommandsEntry.doOnNext(command -> {
            this.commands = this.commands.add(command);
        }).subscribe(this.outCommandsExit);
        this.inCommandsExit.subscribe(this.outCommandsEntry);
    }

    @Override
    public Option<? extends Crdt> findCrdt(String crdtId) {
        return this.crdts.get((Object)crdtId);
    }

    @Override
    public <T extends Crdt> T createCrdt(Function4<String, String, Publisher<? extends CrdtCommand>, Subscriber<? super CrdtCommand>, T> factory, String id) {
        Objects.requireNonNull(factory, "factory must not be null");
        Objects.requireNonNull(id, "id must not be null");
        Crdt result = (Crdt)factory.apply((Object)this.nodeId, (Object)id, (Object)this.inCommandsExit.filter(command -> Objects.equals(id, command.getCrdtId())), this.outCommandsEntry);
        this.register(result);
        return (T)result;
    }

    @Override
    public <T> LWWRegister<T> createLWWRegister(String id) {
        Objects.requireNonNull(id, "id must not be null");
        LWWRegister result = new LWWRegister(this.nodeId, id, (Publisher<CrdtCommand>)((Publisher<? extends CrdtCommand>)this.inCommandsExit.filter(command -> Objects.equals(id, command.getCrdtId()))), (Subscriber<CrdtCommand>)this.outCommandsEntry);
        this.register(result);
        return result;
    }

    @Override
    public <T> MVRegister<T> createMVRegister(String id) {
        Objects.requireNonNull(id, "id must not be null");
        MVRegister result = new MVRegister(this.nodeId, id, (Publisher<CrdtCommand>)((Publisher<? extends CrdtCommand>)this.inCommandsExit.filter(command -> Objects.equals(id, command.getCrdtId()))), (Subscriber<CrdtCommand>)this.outCommandsEntry);
        this.register(result);
        return result;
    }

    @Override
    public GCounter createGCounter(String id) {
        Objects.requireNonNull(id, "id must not be null");
        GCounter result = new GCounter(this.nodeId, id, (Publisher<? extends CrdtCommand>)this.inCommandsExit.filter(command -> Objects.equals(id, command.getCrdtId())), (Subscriber<? super CrdtCommand>)this.outCommandsEntry);
        this.register(result);
        return result;
    }

    @Override
    public PNCounter createPNCounter(String id) {
        Objects.requireNonNull(id, "id must not be null");
        PNCounter result = new PNCounter(this.nodeId, id, (Publisher<? extends CrdtCommand>)this.inCommandsExit.filter(command -> Objects.equals(id, command.getCrdtId())), (Subscriber<? super CrdtCommand>)this.outCommandsEntry);
        this.register(result);
        return result;
    }

    public <T> GSet<T> createGSet(String id) {
        Objects.requireNonNull(id, "id must not be null");
        GSet result = new GSet(id, (Publisher<CrdtCommand>)((Publisher<? extends CrdtCommand>)this.inCommandsExit.filter(command -> Objects.equals(id, command.getCrdtId()))), (Subscriber<CrdtCommand>)this.outCommandsEntry);
        this.register(result);
        return result;
    }

    public <T> ORSet<T> createORSet(String id) {
        Objects.requireNonNull(id, "id must not be null");
        ORSet result = new ORSet(id, (Publisher<CrdtCommand>)((Publisher<? extends CrdtCommand>)this.inCommandsExit.filter(command -> Objects.equals(id, command.getCrdtId()))), (Subscriber<CrdtCommand>)this.outCommandsEntry);
        this.register(result);
        return result;
    }

    public <T> RGA<T> createRGA(String id) {
        Objects.requireNonNull(id, "id must not be null");
        RGA result = new RGA(this.nodeId, id, (Publisher<CrdtCommand>)((Publisher<? extends CrdtCommand>)this.inCommandsExit.filter(command -> Objects.equals(id, command.getCrdtId()))), (Subscriber<CrdtCommand>)this.outCommandsEntry);
        this.register(result);
        return result;
    }

    private void register(Crdt crdt) {
        this.crdts = this.crdts.put((Object)crdt.getId(), (Object)crdt);
        AddCrdtCommand command = new AddCrdtCommand(crdt);
        this.outCommandsEntry.onNext((Object)command);
    }

    public void subscribe(Subscriber<? super CrdtCommand> subscriber) {
        this.outCommandsExit.subscribe(subscriber);
    }

    static final class AddCrdtCommand
    extends CrdtCommand {
        private final Class<? extends Crdt> crdtClass;
        private final Function4<String, String, Publisher<? extends CrdtCommand>, Subscriber<? super CrdtCommand>, Crdt> factory;

        AddCrdtCommand(Crdt crdt) {
            super(crdt.getId());
            this.crdtClass = crdt.getClass();
            this.factory = crdt.getFactory();
        }

        Function4<String, String, Publisher<? extends CrdtCommand>, Subscriber<? super CrdtCommand>, Crdt> getFactory() {
            return this.factory;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AddCrdtCommand that = (AddCrdtCommand)o;
            return new EqualsBuilder().appendSuper(super.equals(o)).append(this.crdtClass, that.crdtClass).isEquals();
        }

        @Override
        public int hashCode() {
            return new HashCodeBuilder(17, 37).appendSuper(super.hashCode()).append(this.crdtClass).toHashCode();
        }

        @Override
        public String toString() {
            return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).appendSuper(super.toString()).append("crdtClass", this.crdtClass).toString();
        }
    }

    protected class ReplicaSubscriber
    extends DisposableSubscriber<CrdtCommand> {
        protected ReplicaSubscriber() {
        }

        public void onNext(CrdtCommand command) {
            String crdtId;
            if (AddCrdtCommand.class.equals(command.getClass()) && AbstractCrdtStore.this.findCrdt(crdtId = command.getCrdtId()).isEmpty()) {
                Crdt crdt = (Crdt)((AddCrdtCommand)command).getFactory().apply((Object)AbstractCrdtStore.this.nodeId, (Object)crdtId, (Object)AbstractCrdtStore.this.inCommandsExit.filter(c -> Objects.equals(crdtId, c.getCrdtId())), (Object)AbstractCrdtStore.this.outCommandsEntry);
                AbstractCrdtStore.this.crdts = AbstractCrdtStore.this.crdts.put((Object)crdt.getId(), (Object)crdt);
            }
            AbstractCrdtStore.this.inCommandsEntry.onNext((Object)command);
        }

        public void onError(Throwable throwable) {
            this.cancel();
        }

        public void onComplete() {
            this.cancel();
        }
    }
}

