/*
 * Decompiled with CFR 0.152.
 */
package com.netopyr.wurmloch.store;

import com.netopyr.wurmloch.crdt.Crdt;
import com.netopyr.wurmloch.crdt.CrdtCommand;
import com.netopyr.wurmloch.crdt.GCounter;
import com.netopyr.wurmloch.crdt.GSet;
import com.netopyr.wurmloch.crdt.LWWRegister;
import com.netopyr.wurmloch.crdt.MVRegister;
import com.netopyr.wurmloch.crdt.ORSet;
import com.netopyr.wurmloch.crdt.PNCounter;
import com.netopyr.wurmloch.crdt.RGA;
import java.util.UUID;
import javaslang.Function4;
import javaslang.control.Option;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

public interface CrdtStore
extends Publisher<CrdtCommand> {
    public Option<? extends Crdt> findCrdt(String var1);

    default public <T extends Crdt> T createCrdt(Function4<String, String, Publisher<? extends CrdtCommand>, Subscriber<? super CrdtCommand>, T> factory) {
        return this.createCrdt(factory, UUID.randomUUID().toString());
    }

    public <T extends Crdt> T createCrdt(Function4<String, String, Publisher<? extends CrdtCommand>, Subscriber<? super CrdtCommand>, T> var1, String var2);

    default public <T> LWWRegister<T> createLWWRegister() {
        return this.createLWWRegister(UUID.randomUUID().toString());
    }

    public <T> LWWRegister<T> createLWWRegister(String var1);

    default public <T> Option<LWWRegister<T>> findLWWRegister(String crtdId) {
        Option<? extends Crdt> option = this.findCrdt(crtdId);
        return option.flatMap(crtd -> crtd instanceof LWWRegister ? Option.of((Object)((LWWRegister)crtd)) : Option.none());
    }

    default public <T> MVRegister<T> createMVRegister() {
        return this.createMVRegister(UUID.randomUUID().toString());
    }

    public <T> MVRegister<T> createMVRegister(String var1);

    default public <T> Option<MVRegister<T>> findMVRegister(String crtdId) {
        Option<? extends Crdt> option = this.findCrdt(crtdId);
        return option.flatMap(crtd -> crtd instanceof MVRegister ? Option.of((Object)((MVRegister)crtd)) : Option.none());
    }

    default public GCounter createGCounter() {
        return this.createGCounter(UUID.randomUUID().toString());
    }

    public GCounter createGCounter(String var1);

    default public Option<GCounter> findGCounter(String crtdId) {
        Option<? extends Crdt> option = this.findCrdt(crtdId);
        return option.flatMap(crtd -> crtd instanceof GCounter ? Option.of((Object)((GCounter)crtd)) : Option.none());
    }

    default public PNCounter createPNCounter() {
        return this.createPNCounter(UUID.randomUUID().toString());
    }

    public PNCounter createPNCounter(String var1);

    default public Option<PNCounter> findPNCounter(String crtdId) {
        Option<? extends Crdt> option = this.findCrdt(crtdId);
        return option.flatMap(crtd -> crtd instanceof PNCounter ? Option.of((Object)((PNCounter)crtd)) : Option.none());
    }

    default public <E> GSet<E> createGSet() {
        return this.createGSet(UUID.randomUUID().toString());
    }

    public <E> GSet<E> createGSet(String var1);

    default public <E> Option<GSet<E>> findGSet(String crtdId) {
        Option<? extends Crdt> option = this.findCrdt(crtdId);
        return option.flatMap(crtd -> crtd instanceof GSet ? Option.of((Object)((GSet)crtd)) : Option.none());
    }

    default public <E> ORSet<E> createORSet() {
        return this.createORSet(UUID.randomUUID().toString());
    }

    public <E> ORSet<E> createORSet(String var1);

    default public <E> Option<ORSet<E>> findORSet(String crtdId) {
        Option<? extends Crdt> option = this.findCrdt(crtdId);
        return option.flatMap(crtd -> crtd instanceof ORSet ? Option.of((Object)((ORSet)crtd)) : Option.none());
    }

    default public <E> RGA<E> createRGA() {
        return this.createRGA(UUID.randomUUID().toString());
    }

    public <E> RGA<E> createRGA(String var1);

    default public <E> Option<RGA<E>> findRGA(String crtdId) {
        Option<? extends Crdt> option = this.findCrdt(crtdId);
        return option.flatMap(crtd -> crtd instanceof RGA ? Option.of((Object)((RGA)crtd)) : Option.none());
    }
}

