/*
 * Decompiled with CFR 0.152.
 */
package com.netopyr.wurmloch.vectorclock;

import javaslang.collection.HashMap;
import javaslang.collection.Map;
import javaslang.collection.Set;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public final class StrictVectorClock
implements Comparable<StrictVectorClock> {
    private final String key;
    private final Map<String, Long> entries;

    public StrictVectorClock(String key, Map<String, Long> entries) {
        this.key = key;
        this.entries = entries;
    }

    public StrictVectorClock(String key) {
        this(key, (Map<String, Long>)HashMap.empty());
    }

    public StrictVectorClock increment() {
        long counter = (Long)this.entries.get((Object)this.key).map(value -> value + 1L).getOrElse((Object)1L);
        return new StrictVectorClock(this.key, (Map<String, Long>)this.entries.put((Object)this.key, (Object)counter));
    }

    @Override
    public int compareTo(StrictVectorClock other) {
        Set<Long> diffs = this.calculateDiffs(other);
        boolean isGreater = diffs.find(diff -> diff > 0L).isDefined();
        boolean isLess = diffs.find(diff -> diff < 0L).isDefined();
        return isGreater && isLess ? this.key.compareTo(other.key) : (isLess ? -1 : (isGreater ? 1 : this.key.compareTo(other.key)));
    }

    public StrictVectorClock merge(StrictVectorClock other) {
        return new StrictVectorClock(this.key, (Map<String, Long>)this.entries.merge(other.entries, Math::max));
    }

    private Set<Long> calculateDiffs(StrictVectorClock other) {
        Set allKeys = this.entries.keySet().addAll((Iterable)other.entries.keySet());
        return allKeys.map(key -> (Long)this.entries.get(key).getOrElse((Object)0L) - (Long)other.entries.get(key).getOrElse((Object)0L));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StrictVectorClock that = (StrictVectorClock)o;
        return this.calculateDiffs(that).forAll(diff -> diff == 0L);
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.entries).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("key", (Object)this.key).append("entries", this.entries).toString();
    }
}

