/*
 * Decompiled with CFR 0.152.
 */
package com.netopyr.wurmloch.vectorclock;

import javaslang.collection.HashMap;
import javaslang.collection.Map;
import javaslang.collection.Set;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public final class VectorClock
implements Comparable<VectorClock> {
    private final Map<String, Long> entries;

    public VectorClock(Map<String, Long> entries) {
        this.entries = entries;
    }

    public VectorClock() {
        this((Map<String, Long>)HashMap.empty());
    }

    public VectorClock increment(String key) {
        long counter = (Long)this.entries.get((Object)key).map(value -> value + 1L).getOrElse((Object)1L);
        return new VectorClock((Map<String, Long>)this.entries.put((Object)key, (Object)counter));
    }

    @Override
    public int compareTo(VectorClock other) {
        Set<Long> diffs = this.calculateDiffs(other);
        boolean isGreater = diffs.find(diff -> diff > 0L).isDefined();
        boolean isLess = diffs.find(diff -> diff < 0L).isDefined();
        return isGreater && isLess ? 0 : (isLess ? -1 : (isGreater ? 1 : 0));
    }

    public VectorClock merge(VectorClock other) {
        return new VectorClock((Map<String, Long>)this.entries.merge(other.entries, Math::max));
    }

    private Set<Long> calculateDiffs(VectorClock other) {
        Set allKeys = this.entries.keySet().addAll((Iterable)other.entries.keySet());
        return allKeys.map(key -> (Long)this.entries.get(key).getOrElse((Object)0L) - (Long)other.entries.get(key).getOrElse((Object)0L));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VectorClock that = (VectorClock)o;
        return this.calculateDiffs(that).forAll(diff -> diff == 0L);
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.entries).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("entries", this.entries).toString();
    }
}

