/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.Obfuscation;

import com.newrelic.agent.compile.Log;
import com.newrelic.agent.compile.RewriterAgent;
import com.newrelic.agent.compile.visitor.NewRelicClassVisitor;
import com.newrelic.com.google.common.io.BaseEncoding;
import com.newrelic.org.apache.commons.io.FileUtils;
import com.newrelic.org.apache.commons.io.filefilter.FileFilterUtils;
import com.newrelic.org.apache.commons.io.filefilter.IOFileFilter;
import com.newrelic.org.apache.commons.io.filefilter.TrueFileFilter;
import com.newrelic.org.apache.commons.io.input.ReversedLinesFileReader;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;

public class Proguard {
    public static final String NR_PROPERTIES = "newrelic.properties";
    public static final String MAPPING_FILENAME = "mapping.txt";
    private static final String PROP_NR_APP_TOKEN = "com.newrelic.application_token";
    private static final String PROP_UPLOADING_ENABLED = "com.newrelic.enable_proguard_upload";
    private static final String PROP_MAPPING_API_HOST = "com.newrelic.mapping_upload_host";
    private static final String DEFAULT_MAPPING_API_HOST = "mobile-symbol-upload.newrelic.com";
    private static final String MAPPING_API_PATH = "/symbol";
    private static final String LICENSE_KEY_HEADER = "X-APP-LICENSE-KEY";
    private static final String NR_MAP_PREFIX = "# NR_BUILD_ID -> ";
    private final Log log;
    private final String buildId;
    private String projectRoot;
    private String licenseKey = null;
    private boolean uploadingEnabled = true;
    private String mappingApiHost = null;
    private static Map<String, String> agentOptions = Collections.emptyMap();
    private static String newLn = System.getProperty("line.separator");

    public Proguard(Log log) {
        this(log, RewriterAgent.getAgentOptions(), NewRelicClassVisitor.getBuildId());
    }

    public Proguard(Log log, Map<String, String> agentOptions, String buildId) {
        this.log = log;
        Proguard.agentOptions = agentOptions;
        this.buildId = buildId;
    }

    public void findAndSendMapFile() {
        if (this.getProjectRoot() != null) {
            if (!this.fetchConfiguration()) {
                return;
            }
            File projectRoot = new File(this.getProjectRoot());
            Collection<Object> files = new ArrayList();
            if (agentOptions.containsKey(MAPPING_FILENAME)) {
                File mappingFile = new File(agentOptions.get(MAPPING_FILENAME));
                if (mappingFile.exists()) {
                    files.add(mappingFile);
                } else {
                    this.log.warning("Mapping file [" + mappingFile.getAbsolutePath() + "] doesn't exist");
                }
            } else {
                IOFileFilter fileFilter = FileFilterUtils.nameFileFilter(MAPPING_FILENAME);
                files = FileUtils.listFiles(projectRoot, fileFilter, TrueFileFilter.INSTANCE);
            }
            if (files.isEmpty()) {
                this.log.error("While evidence of ProGuard/Dexguard was detected, New Relic failed to find your mapping.txt file.");
                this.log.error("To de-obfuscate your builds, you'll need to upload your mapping.txt manually.");
                return;
            }
            for (File file : files) {
                StringBuilder mappingString = new StringBuilder();
                try {
                    String lastLine = "";
                    try (ReversedLinesFileReader revReader = new ReversedLinesFileReader(file);){
                        lastLine = revReader.readLine();
                        revReader.close();
                    }
                    if (lastLine.startsWith(NR_MAP_PREFIX)) continue;
                    this.log.info("Tagging map [" + file.getAbsolutePath() + "] with buildID [" + this.buildId + "]");
                    var8_10 = null;
                    try (FileWriter fileWriter = new FileWriter(file, true);){
                        fileWriter.write(NR_MAP_PREFIX + this.buildId + newLn);
                        fileWriter.close();
                    }
                    catch (Throwable throwable) {
                        var8_10 = throwable;
                        throw throwable;
                    }
                    mappingString.append(FileUtils.readFileToString(file));
                    if (this.uploadingEnabled) {
                        if (mappingString.length() > 0) {
                            this.sendMapping(mappingString.toString());
                            continue;
                        }
                        this.log.error("Tried to send a zero-length map file!");
                        continue;
                    }
                    this.log.warning("Map uploads have been disabled");
                }
                catch (FileNotFoundException e) {
                    this.log.error("Unable to open your mapping.txt file: " + e.getLocalizedMessage());
                    this.log.error("To de-obfuscate your builds, you'll need to upload your mapping.txt manually.");
                }
                catch (IOException e) {
                    this.log.error("Unable to open your mapping.txt file: " + e.getLocalizedMessage());
                    this.log.error("To de-obfuscate your builds, you'll need to upload your mapping.txt manually.");
                }
            }
        }
    }

    private String getProjectRoot() {
        if (this.projectRoot == null) {
            String encodedProjectRoot = agentOptions.get("projectRoot");
            if (encodedProjectRoot == null) {
                this.log.info("Unable to determine project root, falling back to CWD.");
                this.projectRoot = System.getProperty("user.dir");
            } else {
                this.projectRoot = new String(BaseEncoding.base64().decode(encodedProjectRoot));
            }
        }
        return this.projectRoot;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean fetchConfiguration() {
        try (BufferedReader propsReader = new BufferedReader(new FileReader(this.getProjectRoot() + File.separator + NR_PROPERTIES));){
            Properties newRelicProps = new Properties();
            newRelicProps.load(propsReader);
            this.licenseKey = newRelicProps.getProperty(PROP_NR_APP_TOKEN);
            this.uploadingEnabled = newRelicProps.getProperty(PROP_UPLOADING_ENABLED, "true").equals("true");
            this.mappingApiHost = newRelicProps.getProperty(PROP_MAPPING_API_HOST);
            if (this.licenseKey == null) {
                this.log.error("Unable to find a value for com.newrelic.application_token in your newrelic.properties");
                this.log.error("To de-obfuscate your builds, you'll need to upload your mapping.txt manually.");
                boolean bl = false;
                return bl;
            }
            ((Reader)propsReader).close();
            return true;
        }
        catch (FileNotFoundException e) {
            this.log.error("Unable to find your newrelic.properties in the project root (" + this.getProjectRoot() + "): " + e.getLocalizedMessage());
            this.log.error("To de-obfuscate your builds, you'll need to upload your mapping.txt manually.");
            return false;
        }
        catch (IOException e) {
            this.log.error("Unable to read your newrelic.properties in the project root (" + this.getProjectRoot() + "): " + e.getLocalizedMessage());
            this.log.error("To de-obfuscate your builds, you'll need to upload your mapping.txt manually.");
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMapping(String mapping) {
        block45: {
            StringBuilder requestBody = new StringBuilder();
            requestBody.append("proguard=" + URLEncoder.encode(mapping));
            requestBody.append("&buildId=" + this.buildId);
            HttpURLConnection connection = null;
            try {
                InputStream inputStream;
                String host = DEFAULT_MAPPING_API_HOST;
                if (this.mappingApiHost != null) {
                    host = this.mappingApiHost;
                }
                URL url = new URL("https://" + host + MAPPING_API_PATH);
                connection = (HttpURLConnection)url.openConnection();
                connection.setUseCaches(false);
                connection.setDoOutput(true);
                connection.setRequestMethod("POST");
                connection.setRequestProperty(LICENSE_KEY_HEADER, this.licenseKey);
                connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                connection.setRequestProperty("Content-Length", Integer.toString(requestBody.length()));
                try (DataOutputStream request = new DataOutputStream(connection.getOutputStream());){
                    request.writeBytes(requestBody.toString());
                    request.close();
                }
                int responseCode = connection.getResponseCode();
                if (responseCode == 400) {
                    inputStream = connection.getErrorStream();
                    Throwable throwable = null;
                    try {
                        String response = Proguard.convertStreamToString(inputStream);
                        this.log.error("Unable to send your ProGuard/Dexguard mapping.txt to New Relic as the params are incorrect: " + response);
                        this.log.error("To de-obfuscate your builds, you'll need to upload your mapping.txt manually.");
                        break block45;
                    }
                    catch (Throwable response) {
                        throwable = response;
                        throw response;
                    }
                    finally {
                        if (inputStream != null) {
                            if (throwable != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (Throwable response) {
                                    throwable.addSuppressed(response);
                                }
                            } else {
                                inputStream.close();
                            }
                        }
                    }
                }
                if (responseCode > 400) {
                    inputStream = connection.getErrorStream();
                    Throwable throwable = null;
                    try {
                        String response = Proguard.convertStreamToString(inputStream);
                        this.log.error("Unable to send your ProGuard/DexGuard mapping.txt to New Relic - received status " + responseCode + ": " + response);
                        this.log.error("To de-obfuscate your builds, you'll need to upload your mapping.txt manually.");
                        break block45;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (inputStream != null) {
                            if (throwable != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                inputStream.close();
                            }
                        }
                    }
                }
                this.log.info("Successfully sent mapping.txt to New Relic.");
            }
            catch (IOException e) {
                this.log.error("Encountered an error while uploading your ProGuard/Dexguard mapping to New Relic", e);
                this.log.error("To de-obfuscate your builds, you'll need to upload your mapping.txt manually.");
            }
            finally {
                connection.disconnect();
            }
        }
    }

    private static String convertStreamToString(InputStream is) {
        StringBuilder stringBuilder = new StringBuilder();
        if (is != null) {
            try (InputStreamReader inputStreamReader = new InputStreamReader(is);
                 BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
                String line = null;
                try {
                    while ((line = bufferedReader.readLine()) != null) {
                        stringBuilder.append(line + newLn);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return stringBuilder.toString();
    }
}

