/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.compile;

import com.newrelic.agent.compile.ClassData;
import com.newrelic.agent.compile.InvocationDispatcher;
import com.newrelic.agent.compile.Log;
import com.newrelic.agent.compile.RewriterAgent;
import com.newrelic.agent.compile.SystemErrLog;
import com.newrelic.agent.util.Streams;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.regex.Pattern;

public final class ClassTransformer {
    private final Log log;
    private final List<File> classes;
    private File inputFile;
    private File outputFile;
    private InvocationDispatcher invocationDispatcher;
    private ClassData classData;
    private boolean noopTransform = false;
    private WriteMode writeMode = WriteMode.modified;

    public ClassTransformer() {
        String props = System.getProperty("NewRelic.AgentArgs");
        Map<String, String> agentOptions = RewriterAgent.parseAgentArgs(props);
        this.log = new SystemErrLog(agentOptions);
        this.classes = new ArrayList<File>();
        this.inputFile = new File(".");
        this.outputFile = new File(".");
        this.classData = null;
        this.noopTransform = false;
        this.writeMode = WriteMode.modified;
        try {
            this.invocationDispatcher = new InvocationDispatcher(this.log);
        }
        catch (Exception e) {
            this.log.error("[ClassTransformer] " + e);
        }
    }

    public ClassTransformer(File classPath, File outputDir) {
        this();
        this.classes.add(classPath);
        this.inputFile = classPath;
        this.outputFile = outputDir;
        if (classPath.isDirectory()) {
            this.inputFile = classPath;
        }
    }

    public ClassTransformer(JarFile jarFile, File outputJar) {
        this();
        File jar = new File(jarFile.getName());
        this.inputFile = jar.getParentFile();
        this.outputFile = outputJar;
    }

    protected void doTransform() {
        long tStart = System.currentTimeMillis();
        for (File classFile : this.classes) {
            this.inputFile = FileUtils.isClass(classFile) ? classFile.getParentFile() : classFile;
            this.log.debug("[ClassTransformer] Transforming classpath[" + classFile.getAbsolutePath() + "]");
            this.log.debug("[ClassTransformer] InputFile[" + this.inputFile.getAbsolutePath() + "]");
            this.log.debug("[ClassTransformer] OutputFile[" + this.outputFile.getAbsolutePath() + "]");
            this.transformClass(classFile);
        }
        this.log.info(MessageFormat.format("[ClassTransformer] doTransform finished in {0} sec.", Float.valueOf((float)(System.currentTimeMillis() - tStart) / 1000.0f)));
    }

    public byte[] transformClassBytes(String destClassPath, byte[] bytes) {
        if (this.noopTransform) {
            return bytes;
        }
        if (FileUtils.isClass(destClassPath)) {
            try {
                if (bytes != null) {
                    this.log.debug("[ClassTransformer] transformClassBytes: [" + destClassPath + "]");
                    this.classData = this.invocationDispatcher.visitClassBytes(bytes);
                    if (this.classData != null && this.classData.getMainClassBytes() != null && this.classData.isModified()) {
                        return this.classData.getMainClassBytes();
                    }
                }
            }
            catch (Exception e) {
                this.log.error("[ClassTransformer] " + e);
            }
        }
        return bytes;
    }

    private ByteArrayInputStream processClassBytes(File file, InputStream classFileInputStream) throws IOException {
        ByteArrayInputStream processedClassBytesStream;
        byte[] classBytes = Streams.slurpBytes(classFileInputStream);
        byte[] transformedClassBytes = this.transformClassBytes(file.getPath(), classBytes);
        if (transformedClassBytes == null) {
            processedClassBytesStream = new ByteArrayInputStream(classBytes);
        } else {
            if (classBytes.length != transformedClassBytes.length && this.classData != null && this.classData.isModified()) {
                this.log.info("[ClassTransformer] Rewrote class[" + file.getPath() + "] bytes[" + classBytes.length + "] rewritten[" + transformedClassBytes.length + "]");
            }
            processedClassBytesStream = new ByteArrayInputStream(transformedClassBytes);
        }
        return processedClassBytesStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean transformClass(File file) {
        boolean didProcessClass;
        block10: {
            didProcessClass = false;
            try {
                if (FileUtils.isArchive(file)) {
                    didProcessClass = this.transformArchive(file, true);
                    break block10;
                }
                if (file.isDirectory()) {
                    didProcessClass = this.transformDirectory(file);
                    break block10;
                }
                if (FileUtils.isClass(file)) {
                    String classpath = file.getAbsolutePath();
                    if (classpath.startsWith(this.inputFile.getAbsolutePath())) {
                        classpath = classpath.substring(this.inputFile.getAbsolutePath().length() + 1);
                    }
                    FileInputStream classBytesInputStream = null;
                    ByteArrayInputStream processedClassBytesStream = null;
                    try {
                        classBytesInputStream = new FileInputStream(file);
                        processedClassBytesStream = this.processClassBytes(new File(classpath), classBytesInputStream);
                        File transformedClass = new File(this.outputFile, classpath);
                        didProcessClass = this.writeModifiedClassFile((InputStream)processedClassBytesStream, transformedClass);
                        this.closeQuietly(classBytesInputStream);
                        this.closeQuietly(processedClassBytesStream);
                        break block10;
                    }
                    catch (Exception e) {
                        try {
                            this.log.error("[ClassTransformer] transformClass: " + e);
                            didProcessClass = false;
                            this.closeQuietly(classBytesInputStream);
                            this.closeQuietly(processedClassBytesStream);
                            break block10;
                        }
                        catch (Throwable throwable) {
                            this.closeQuietly(classBytesInputStream);
                            this.closeQuietly(processedClassBytesStream);
                            throw throwable;
                        }
                    }
                }
                this.log.debug("[ClassTransformer] Class ignored: " + file.getName());
            }
            catch (Exception e) {
                this.log.error("[ClassTransformer] transformClass: " + e);
            }
        }
        return didProcessClass;
    }

    public boolean transformDirectory(File directory) {
        boolean didProcessDirectory = false;
        if (directory.isDirectory()) {
            for (File f : directory.listFiles()) {
                didProcessDirectory |= this.transformClass(f);
            }
        }
        return didProcessDirectory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean transformArchive(File archiveFile, boolean explodeJar) throws IOException {
        boolean didProcessArchive = false;
        if (this.isSupportJar(archiveFile)) {
            this.log.debug("[ClassTransformer] Skipping support jar [" + archiveFile.getPath() + "]");
            return false;
        }
        this.log.debug("[ClassTransformer] Transforming archive[" + archiveFile.getCanonicalPath() + "]");
        FileInputStream archiveFileInputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        JarInputStream jarInputStream = null;
        JarOutputStream jarOutputStream = null;
        JarFile jarFile = null;
        try {
            JarEntry manifest = new JarEntry("META-INF/MANIFEST.MF");
            jarFile = new JarFile(archiveFile);
            byteArrayOutputStream = new ByteArrayOutputStream();
            archiveFileInputStream = new FileInputStream(archiveFile);
            jarInputStream = new JarInputStream(archiveFileInputStream);
            jarOutputStream = new JarOutputStream(byteArrayOutputStream);
            jarOutputStream.putNextEntry(manifest);
            Manifest realManifest = jarFile.getManifest();
            if (realManifest != null) {
                realManifest.getMainAttributes().put(new Attributes.Name("Transformed-By"), "New Relic Android Agent");
                realManifest.write(jarOutputStream);
            }
            jarOutputStream.flush();
            jarOutputStream.closeEntry();
            JarEntry entry = jarInputStream.getNextJarEntry();
            while (entry != null) {
                String jarEntryPath = entry.getName();
                if (!entry.isDirectory() && FileUtils.isClass(jarEntryPath)) {
                    JarEntry jarEntry = new JarEntry(jarEntryPath);
                    File archiveClass = new File(this.outputFile, jarEntryPath);
                    InputStream jarFileInputStream = null;
                    jarEntry.setTime(entry.getTime());
                    jarOutputStream.putNextEntry(jarEntry);
                    ByteArrayInputStream processedClassBytesStream = null;
                    try {
                        jarFileInputStream = jarFile.getInputStream(entry);
                        processedClassBytesStream = this.processClassBytes(archiveClass, jarFileInputStream);
                        if (explodeJar) {
                            this.writeModifiedClassFile((InputStream)processedClassBytesStream, archiveClass);
                        } else {
                            this.writeModifiedClassFile((InputStream)processedClassBytesStream, jarOutputStream);
                            didProcessArchive = true;
                        }
                        this.closeQuietly(jarFileInputStream);
                        this.closeQuietly(processedClassBytesStream);
                    }
                    catch (Exception e) {
                        try {
                            this.log.error("[ClassTransformer] transformArchive: " + e);
                            didProcessArchive = false;
                            this.closeQuietly(jarFileInputStream);
                            this.closeQuietly(processedClassBytesStream);
                        }
                        catch (Throwable throwable) {
                            this.closeQuietly(jarFileInputStream);
                            this.closeQuietly(processedClassBytesStream);
                            throw throwable;
                        }
                    }
                    jarOutputStream.flush();
                    jarOutputStream.closeEntry();
                }
                entry = jarInputStream.getNextJarEntry();
            }
            if (didProcessArchive) {
                File rewrittenJar = new File(this.outputFile.getAbsolutePath());
                if (archiveFile.getAbsolutePath() != rewrittenJar.getAbsolutePath()) {
                    this.log.debug("[ClassTransformer] Rewriting archive to [" + rewrittenJar.getAbsolutePath() + "]");
                    this.closeQuietly(jarOutputStream);
                    try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());){
                        this.writeModifiedClassFile((InputStream)byteArrayInputStream, rewrittenJar);
                    }
                    catch (Exception e) {
                        this.log.error("ClassTransformer] transformArchive: " + e);
                    }
                } else {
                    this.log.error("[ClassTransformer] Refusing to overwrite archive [" + rewrittenJar.getAbsolutePath() + "]");
                }
            }
            this.closeQuietly(jarFile);
            this.closeQuietly(archiveFileInputStream);
            this.closeQuietly(byteArrayOutputStream);
            this.closeQuietly(jarInputStream);
            this.closeQuietly(jarOutputStream);
        }
        catch (Exception e) {
            try {
                this.log.error("[ClassTransformer] transformArchive: " + e);
                this.closeQuietly(jarFile);
                this.closeQuietly(archiveFileInputStream);
                this.closeQuietly(byteArrayOutputStream);
                this.closeQuietly(jarInputStream);
                this.closeQuietly(jarOutputStream);
            }
            catch (Throwable throwable) {
                this.closeQuietly(jarFile);
                this.closeQuietly(archiveFileInputStream);
                this.closeQuietly(byteArrayOutputStream);
                this.closeQuietly(jarInputStream);
                this.closeQuietly(jarOutputStream);
                throw throwable;
            }
        }
        return didProcessArchive;
    }

    private boolean isSupportJar(File archiveFile) {
        boolean matches = false;
        try {
            String canonicalPath = archiveFile.getCanonicalPath().toLowerCase();
            matches |= Pattern.matches("^.*\\/jre\\/lib\\/rt\\.jar$", canonicalPath);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return matches;
    }

    public ClassTransformer asNoopTransform(boolean noopTransform) {
        this.noopTransform = noopTransform;
        return this;
    }

    public ClassTransformer addClasspath(File classpath) {
        this.classes.add(classpath);
        return this;
    }

    public ClassTransformer withWriteMode(WriteMode writeMode) {
        this.writeMode = writeMode;
        return this;
    }

    protected boolean writeModifiedClassFile(InputStream inStream, OutputStream outStrm) throws IOException {
        if ((this.writeMode == WriteMode.always || this.writeMode == WriteMode.modified && this.classData != null && this.classData.isModified()) && inStream != null) {
            return 0 < Streams.copy(inStream, outStrm);
        }
        return false;
    }

    protected boolean writeModifiedClassFile(InputStream inStream, File className) throws IOException {
        boolean writeResult = false;
        if (this.writeMode == WriteMode.always || this.writeMode == WriteMode.modified && this.classData != null && this.classData.isModified()) {
            if (inStream != null && className != null) {
                className.getParentFile().mkdirs();
                try (FileOutputStream modifiedClassBytesStream = new FileOutputStream(className);){
                    writeResult = this.writeModifiedClassFile(inStream, modifiedClassBytesStream);
                    this.closeQuietly(modifiedClassBytesStream);
                }
                catch (IOException e) {
                    this.log.error("writeModifiedClassFile: " + e);
                }
            } else {
                this.log.error("writeModifiedClassFile: input stream or class name is missing!");
            }
        }
        return writeResult;
    }

    private void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                this.log.warning("[ClassTransformer] closeQuietly: " + e);
            }
        }
    }

    private static final class FileUtils {
        private FileUtils() {
        }

        public static boolean isArchive(String fileName) {
            String lowerPath = fileName.toLowerCase();
            return lowerPath.endsWith(".zip") || lowerPath.endsWith(".jar") || lowerPath.endsWith(".aar");
        }

        public static boolean isArchive(File f) {
            return FileUtils.isArchive(f.getAbsolutePath());
        }

        public static boolean isClass(String fileName) {
            String lowerPath = fileName.toLowerCase();
            return lowerPath.endsWith(".class");
        }

        public static boolean isClass(File f) {
            return FileUtils.isClass(f.getAbsolutePath());
        }
    }

    public static enum WriteMode {
        modified,
        always,
        never;

    }
}

