/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.compile;

import com.newrelic.agent.compile.Log;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.Map;

final class FileLogImpl
extends Log {
    private final PrintWriter writer;

    public FileLogImpl(Map<String, String> agentOptions, String logFileName) {
        super(agentOptions);
        try {
            this.writer = new PrintWriter(new FileOutputStream(logFileName));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void log(String level, String message) {
        FileLogImpl fileLogImpl = this;
        synchronized (fileLogImpl) {
            this.writer.write("[newrelic." + level.toLowerCase() + "] " + message + "\n");
            this.writer.flush();
        }
    }

    @Override
    public void warning(String message, Throwable cause) {
        if (this.logLevel >= Log.LogLevel.WARN.getValue()) {
            this.log("warn", message);
            cause.printStackTrace(this.writer);
            this.writer.flush();
        }
    }

    @Override
    public void error(String message, Throwable cause) {
        if (this.logLevel >= Log.LogLevel.ERROR.getValue()) {
            this.log("error", message);
            cause.printStackTrace(this.writer);
            this.writer.flush();
        }
    }
}

