/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.compile;

import com.newrelic.agent.compile.ClassData;
import com.newrelic.agent.compile.ClassRemapperConfig;
import com.newrelic.agent.compile.HaltBuildException;
import com.newrelic.agent.compile.InstrumentationContext;
import com.newrelic.agent.compile.Log;
import com.newrelic.agent.compile.RewriterAgent;
import com.newrelic.agent.compile.SkipException;
import com.newrelic.agent.compile.visitor.ActivityClassVisitor;
import com.newrelic.agent.compile.visitor.AnnotatingClassVisitor;
import com.newrelic.agent.compile.visitor.AsyncTaskClassVisitor;
import com.newrelic.agent.compile.visitor.ContextInitializationClassVisitor;
import com.newrelic.agent.compile.visitor.NewRelicClassVisitor;
import com.newrelic.agent.compile.visitor.PrefilterClassVisitor;
import com.newrelic.agent.compile.visitor.TraceAnnotationClassVisitor;
import com.newrelic.agent.compile.visitor.WrapMethodClassVisitor;
import com.newrelic.org.objectweb.asm.ClassReader;
import com.newrelic.org.objectweb.asm.ClassVisitor;
import com.newrelic.org.objectweb.asm.ClassWriter;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class InvocationDispatcher
implements InvocationHandler {
    public static final Class INVOCATION_DISPATCHER_CLASS = Logger.class;
    public static final String INVOCATION_DISPATCHER_FIELD_NAME = "treeLock";
    public static final Set<String> DX_COMMAND_NAMES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("dx", "dx.bat")));
    public static final Set<String> JAVA_NAMES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("java", "java.exe")));
    private static final Set<String> AGENT_JAR_NAMES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("newrelic.android.fat.jar", "newrelic.android.jar", "obfuscated.jar")));
    public static final HashSet<String> EXCLUDED_PACKAGES = new HashSet<String>(){
        {
            this.add("com/newrelic/agent/android");
            this.add("com/newrelic/mobile");
            this.add("com/google/gson");
            this.add("com/google/flatbuffers");
            this.add("com/google/firebase/perf/network");
        }
    };
    private final Log log;
    private final ClassRemapperConfig config;
    private final InstrumentationContext context;
    private final Map<String, InvocationHandler> invocationHandlers;
    private boolean writeDisabledMessage = true;
    private final String agentJarPath;
    private boolean disableInstrumentation = false;

    public InvocationDispatcher(final Log log) throws IOException, ClassNotFoundException, URISyntaxException {
        this.log = log;
        this.config = new ClassRemapperConfig(log);
        this.context = new InstrumentationContext(this.config, log);
        this.agentJarPath = RewriterAgent.getAgentJarPath();
        this.invocationHandlers = Collections.unmodifiableMap(new HashMap<String, InvocationHandler>(){
            {
                String proxyInvocationKey = RewriterAgent.getProxyInvocationKey("com/android/dx/command/dexer/Main", "processClass");
                this.put(proxyInvocationKey, new InvocationHandler(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                        String filename = (String)args[0];
                        byte[] bytes = (byte[])args[1];
                        log.debug("dexer/main/processClass arg[0](filename)[" + filename + "] arg[1](bytes)[" + bytes.length + "]");
                        if (InvocationDispatcher.this.isInstrumentationDisabled()) {
                            if (InvocationDispatcher.this.writeDisabledMessage) {
                                InvocationDispatcher.this.writeDisabledMessage = false;
                                log.info("Instrumentation disabled, no agent present");
                            }
                            return bytes;
                        }
                        InvocationDispatcher.this.writeDisabledMessage = true;
                        InstrumentationContext instrumentationContext = InvocationDispatcher.this.context;
                        synchronized (instrumentationContext) {
                            ClassData classData = InvocationDispatcher.this.visitClassBytes(bytes);
                            if (classData != null && classData.getMainClassBytes() != null && classData.isModified()) {
                                log.debug("dexer/main/processClass transformed bytes[" + bytes.length + "]");
                                return classData.getMainClassBytes();
                            }
                        }
                        return bytes;
                    }
                });
                proxyInvocationKey = RewriterAgent.getProxyInvocationKey("com/android/ant/DexExecTask", "preDexLibraries");
                this.put(proxyInvocationKey, new InvocationHandler(){

                    @Override
                    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                        List files = (List)args[0];
                        for (File file : files) {
                            if (!AGENT_JAR_NAMES.contains(file.getName().toLowerCase())) continue;
                            log.info("Detected the New Relic Android agent in an Ant build (" + file.getPath() + ")");
                            return file;
                        }
                        log.debug("Ant preDexLibraries: " + files);
                        log.info("No New Relic agent detected in Ant build");
                        return null;
                    }
                });
                this.put("SET_INSTRUMENTATION_DISABLED_FLAG", new InvocationHandler(){

                    @Override
                    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                        InvocationDispatcher.this.disableInstrumentation = args != null && args[0] == null;
                        log.debug("DisableInstrumentation: " + InvocationDispatcher.this.disableInstrumentation + " (" + args + ")");
                        return null;
                    }
                });
                this.put("PRINT_TO_INFO_LOG", new InvocationHandler(){

                    @Override
                    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                        log.info(args[0].toString());
                        return null;
                    }
                });
                proxyInvocationKey = RewriterAgent.getProxyInvocationKey("java/lang/ProcessBuilder", "start");
                this.put(proxyInvocationKey, new InvocationHandler(){

                    @Override
                    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                        List list = (List)args[0];
                        String command = (String)list.get(0);
                        File commandFile = new File(command);
                        if (InvocationDispatcher.this.isInstrumentationDisabled()) {
                            log.info("Instrumentation disabled, no agent present.  Command: " + commandFile.getName());
                            log.debug("Execute: " + list.toString());
                            return null;
                        }
                        String javaagentString = null;
                        if (DX_COMMAND_NAMES.contains(commandFile.getName().toLowerCase())) {
                            javaagentString = "-Jjavaagent:" + InvocationDispatcher.this.agentJarPath;
                        } else if (JAVA_NAMES.contains(commandFile.getName().toLowerCase())) {
                            javaagentString = "-javaagent:" + InvocationDispatcher.this.agentJarPath;
                        }
                        if (javaagentString != null) {
                            String agentArgs = RewriterAgent.getAgentArgs();
                            if (agentArgs != null) {
                                javaagentString = javaagentString + "=" + agentArgs;
                            }
                            list.add(1, this.quoteProperty(javaagentString));
                        }
                        log.debug("processBuilder/start Execute[" + list.toString() + "]");
                        return null;
                    }

                    private String quoteProperty(String string) {
                        if (System.getProperty("os.name").toLowerCase().contains("win")) {
                            return "\"" + string + "\"";
                        }
                        return string;
                    }
                });
                proxyInvocationKey = RewriterAgent.getProxyInvocationKey("com/newrelic/agent/compile/ClassTransformer", "transformClassBytes");
                this.put(proxyInvocationKey, new InvocationHandler(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                        String filename = (String)args[0];
                        byte[] bytes = (byte[])args[1];
                        if (InvocationDispatcher.this.isInstrumentationDisabled()) {
                            if (InvocationDispatcher.this.writeDisabledMessage) {
                                InvocationDispatcher.this.writeDisabledMessage = false;
                                log.info("Instrumentation disabled, no agent present");
                            }
                            return bytes;
                        }
                        InvocationDispatcher.this.writeDisabledMessage = true;
                        InstrumentationContext instrumentationContext = InvocationDispatcher.this.context;
                        synchronized (instrumentationContext) {
                            log.debug("ClassTransformer/transformClassBytes arg[0](filename)[" + filename + "] arg[1](bytes)[" + bytes.length + "]");
                            ClassData classData = InvocationDispatcher.this.visitClassBytes(bytes);
                            if (InvocationDispatcher.this.context.isClassModified() && classData != null && classData.getMainClassBytes() != null) {
                                if (bytes.length != classData.getMainClassBytes().length) {
                                    log.debug("ClassTransformer/transformClassBytes transformed bytes[" + classData.getMainClassBytes().length + "]");
                                }
                                return classData.getMainClassBytes();
                            }
                        }
                        return null;
                    }
                });
            }
        });
    }

    private boolean isInstrumentationDisabled() {
        return this.disableInstrumentation || System.getProperty("newrelic.instrumentation.disabled") != null;
    }

    private boolean isExcludedPackage(String packageName) {
        String lowercasePackageName = packageName.toLowerCase();
        for (String name : EXCLUDED_PACKAGES) {
            if (!lowercasePackageName.contains(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        InvocationHandler handler = this.invocationHandlers.get(proxy);
        if (handler == null) {
            this.log.error("Unknown invocation type: " + proxy + ".  Arguments: " + Arrays.asList(args));
            return null;
        }
        try {
            return handler.invoke(proxy, method, args);
        }
        catch (Throwable t) {
            this.log.error("Error:" + t.getMessage(), t);
            return null;
        }
    }

    public ClassData visitClassBytes(byte[] bytes) {
        return this.visitClassBytesWithOptions(bytes, 2);
    }

    private ClassData visitClassBytesWithOptions(byte[] bytes, int classWriterFlags) {
        String className = "an unknown class";
        try {
            ClassReader cr = new ClassReader(bytes);
            ClassWriter cw = new ClassWriter(cr, classWriterFlags);
            this.context.reset();
            cr.accept(new PrefilterClassVisitor(this.context, this.log), 7);
            className = this.context.getClassName();
            if (!this.context.hasTag("Lcom/newrelic/agent/android/instrumentation/Instrumented;")) {
                ClassVisitor cv = cw;
                this.log.debug("[InvocationDispatcher] class [" + className + "]");
                if (className.startsWith("com/newrelic/agent/android")) {
                    cv = new NewRelicClassVisitor(cv, this.context, this.log);
                } else if (className.startsWith("android/")) {
                    cv = new ActivityClassVisitor(cv, this.context, this.log);
                } else {
                    if (this.isExcludedPackage(className)) {
                        this.log.debug("[InvocationDispatcher] Excluding class [" + className + "]");
                        return null;
                    }
                    cv = new AnnotatingClassVisitor(cv, this.context, this.log);
                    cv = new ActivityClassVisitor(cv, this.context, this.log);
                    cv = new AsyncTaskClassVisitor(cv, this.context, this.log);
                    cv = new TraceAnnotationClassVisitor(cv, this.context, this.log);
                    cv = new WrapMethodClassVisitor(cv, this.context, this.log);
                }
                cv = new ContextInitializationClassVisitor(cv, this.context);
                try {
                    cr.accept(cv, 12);
                }
                catch (Exception e) {
                    if (classWriterFlags != 1) {
                        this.log.debug("[InvocationDispatcher] [" + className + "] " + e.getLocalizedMessage());
                        this.log.debug("[InvocationDispatcher] Retry with ClassWriter.COMPUTE_MAXS");
                        return this.visitClassBytesWithOptions(bytes, 1);
                    }
                    this.log.warning("[InvocationDispatcher] [" + className + "] instrumentation failed: " + e.getLocalizedMessage());
                    return new ClassData(bytes, false);
                }
                if (this.context.isClassModified() && bytes.length != cw.toByteArray().length) {
                    this.log.debug("[InvocationDispatcher] class[" + className + "] bytes[" + bytes.length + "] transformed[" + cw.toByteArray().length + "]");
                }
            } else {
                this.log.warning(MessageFormat.format("[{0}] class is already instrumented! skipping ...", this.context.getFriendlyClassName()));
            }
            return this.context.newClassData(cw.toByteArray());
        }
        catch (SkipException e) {
            this.log.debug("[InvocationDispatcher] " + e.getLocalizedMessage());
            return new ClassData(bytes, false);
        }
        catch (HaltBuildException e) {
            this.log.debug("[InvocationDispatcher] " + e.getLocalizedMessage());
            throw new RuntimeException(e);
        }
        catch (Throwable t) {
            this.log.error("Unfortunately, an error has occurred while processing " + className + ". Please copy your build logs and the jar containing this class and visit http://support.newrelic.com, thanks!\n" + t.getMessage(), t);
            return new ClassData(bytes, false);
        }
    }
}

