/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.compile;

import java.util.HashMap;
import java.util.Map;

public abstract class Log {
    public static Log LOGGER = new Log((Map)new HashMap()){};
    protected final int logLevel;

    public Log(Map<String, String> agentOptions) {
        String logLevelOpt = agentOptions.get("loglevel");
        this.logLevel = logLevelOpt != null ? LogLevel.valueOf(logLevelOpt).getValue() : LogLevel.WARN.getValue();
        LOGGER = this;
    }

    public void info(String message) {
        if (this.logLevel >= LogLevel.INFO.getValue()) {
            this.log("info", message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void debug(String message) {
        if (this.logLevel >= LogLevel.DEBUG.getValue()) {
            Log log = this;
            synchronized (log) {
                this.log("debug", message);
            }
        }
    }

    public void warning(String message) {
        if (this.logLevel >= LogLevel.WARN.getValue()) {
            this.log("warn", message);
        }
    }

    public void error(String message) {
        if (this.logLevel >= LogLevel.ERROR.getValue()) {
            this.log("error", message);
        }
    }

    protected void log(String level, String message) {
    }

    public void warning(String message, Throwable cause) {
    }

    public void error(String message, Throwable cause) {
    }

    public static enum LogLevel {
        DEBUG(5),
        VERBOSE(4),
        INFO(3),
        WARN(2),
        ERROR(1);

        private final int value;

        private LogLevel(int newValue) {
            this.value = newValue;
        }

        public int getValue() {
            return this.value;
        }
    }
}

