/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.compile;

import com.newrelic.agent.android.instrumentation.ReplaceCallSite;
import com.newrelic.agent.android.instrumentation.TraceConstructor;
import com.newrelic.agent.android.instrumentation.WrapReturn;
import com.newrelic.agent.util.Annotations;
import com.newrelic.agent.util.MethodAnnotation;
import com.newrelic.org.objectweb.asm.Type;
import com.newrelic.org.reflections.util.ClasspathHelper;
import java.io.FileOutputStream;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class MapFileGenerator {
    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("Usage:   MapFileGenerator class_dir");
            System.exit(1);
        }
        try {
            Class.forName("com.newrelic.agent.android.Agent");
        }
        catch (Exception ex) {
            System.err.println("Unable to load agent classes");
            System.exit(1);
        }
        Map<String, String> remapperProperties = MapFileGenerator.getRemapperProperties();
        if (remapperProperties.size() == 0) {
            System.err.println("No class mappings were found");
            System.exit(1);
        }
        for (Map.Entry<String, String> entry : remapperProperties.entrySet()) {
            System.out.println(entry.getKey() + " = " + entry.getValue());
        }
        Properties props = new Properties();
        props.putAll(remapperProperties);
        try {
            System.out.println("Storing mapping data to " + args[0]);
            FileOutputStream out = new FileOutputStream(args[0]);
            props.store(out, "");
            out.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }

    static Map<String, String> getRemapperProperties() {
        HashMap<String, String> classMap = new HashMap<String, String>();
        Set<URL> urls = ClasspathHelper.forPackage("com.newrelic.agent", new ClassLoader[0]);
        System.out.println("Classpath URLS: " + urls);
        Collection<MethodAnnotation> wrapReturnAnnotations = Annotations.getMethodAnnotations(WrapReturn.class, "com/newrelic/agent", urls);
        for (MethodAnnotation methodAnnotation : wrapReturnAnnotations) {
            String originalClassName = (String)methodAnnotation.getAttributes().get("className");
            String originalMethodName = (String)methodAnnotation.getAttributes().get("methodName");
            String originalMethodDesc = (String)methodAnnotation.getAttributes().get("methodDesc");
            String newClassName = methodAnnotation.getClassName();
            String newMethodName = methodAnnotation.getMethodName();
            classMap.put("WRAP_METHOD:" + originalClassName.replace('.', '/') + '.' + originalMethodName + originalMethodDesc, newClassName + '.' + newMethodName + methodAnnotation.getMethodDesc());
        }
        Collection<MethodAnnotation> callSiteAnnotations = Annotations.getMethodAnnotations(ReplaceCallSite.class, "com/newrelic/agent", urls);
        for (MethodAnnotation annotation : callSiteAnnotations) {
            Boolean isStatic = (Boolean)annotation.getAttributes().get("isStatic");
            String scope = (String)annotation.getAttributes().get("scope");
            if (isStatic == null) {
                isStatic = new Boolean(false);
            }
            String originalMethodName = annotation.getMethodName();
            String originalMethodDesc = annotation.getMethodDesc();
            if (!isStatic.booleanValue()) {
                Type[] argTypes = Type.getArgumentTypes(originalMethodDesc);
                Type[] newArgTypes = new Type[argTypes.length - 1];
                for (int i = 0; i < newArgTypes.length; ++i) {
                    newArgTypes[i] = argTypes[i + 1];
                }
                Type returnType = Type.getReturnType(originalMethodDesc);
                originalMethodDesc = Type.getMethodDescriptor(returnType, newArgTypes);
            }
            String newClassName = annotation.getClassName();
            String newMethodName = annotation.getMethodName();
            if (scope == null) {
                classMap.put("REPLACE_CALL_SITE:" + originalMethodName + originalMethodDesc, newClassName + '.' + newMethodName + annotation.getMethodDesc());
                continue;
            }
            classMap.put("REPLACE_CALL_SITE:" + scope.replace('.', '/') + "." + originalMethodName + originalMethodDesc, newClassName + '.' + newMethodName + annotation.getMethodDesc());
        }
        Collection<MethodAnnotation> collection = Annotations.getMethodAnnotations(TraceConstructor.class, "com/newrelic/agent", urls);
        for (MethodAnnotation annotation : collection) {
            int typeStart = annotation.getMethodDesc().indexOf(")L");
            int typeEnd = annotation.getMethodDesc().lastIndexOf(";");
            System.out.print("Start: " + typeStart + " end: " + typeEnd + " for " + annotation.getMethodDesc());
            String originalClassName = annotation.getMethodDesc().substring(typeStart + 2, typeEnd);
            String originalMethodDesc = annotation.getMethodDesc().substring(0, typeStart + 1) + "V";
            String newClassName = annotation.getClassName();
            String newMethodName = annotation.getMethodName();
            classMap.put("REPLACE_CALL_SITE:" + originalClassName.replace('.', '/') + "." + "<init>" + originalMethodDesc, newClassName + '.' + newMethodName + annotation.getMethodDesc());
        }
        return classMap;
    }
}

