/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.compile.visitor;

import com.newrelic.agent.compile.InstrumentationContext;
import com.newrelic.agent.compile.Log;
import com.newrelic.agent.compile.visitor.EventHookClassVisitor;
import com.newrelic.agent.compile.visitor.TraceClassDecorator;
import com.newrelic.agent.compile.visitor.TraceMethodVisitor;
import com.newrelic.com.google.common.collect.ImmutableMap;
import com.newrelic.com.google.common.collect.ImmutableSet;
import com.newrelic.org.objectweb.asm.ClassVisitor;
import com.newrelic.org.objectweb.asm.MethodVisitor;
import com.newrelic.org.objectweb.asm.Type;
import com.newrelic.org.objectweb.asm.commons.GeneratorAdapter;
import com.newrelic.org.objectweb.asm.commons.Method;

public class ActivityClassVisitor
extends EventHookClassVisitor {
    static final String ANDROID_PACKAGE = "android/";
    static final ImmutableSet<String> ACTIVITY_CLASS_NAMES = ImmutableSet.of();
    static final ImmutableSet<String> BASE_CLASS_NAMES = ImmutableSet.of("^(android\\/.*\\/)(.*Activity)", "^(android\\/app\\/)(ActivityGroup)", "^(android\\/.*\\/)(.*Activity)([DGH].*)", "^(android\\/.*\\/)(.*Fragment)", "^(android\\/support\\/v%d\\/.*\\/)(.*FragmentCompat)");
    static final ImmutableSet<String> IGNORED_SDK_PACKAGES = ImmutableSet.of("android/app/", "android/preference/", "android/support/v", "android/support/constraint");
    static final Type applicationStateMonitorType = Type.getObjectType("com/newrelic/agent/android/background/ApplicationStateMonitor");
    public static final ImmutableMap<String, String> traceMethodMap = ImmutableMap.of("onCreate", "(Landroid/os/Bundle;)V", "onCreateView", "(Landroid/view/LayoutInflater;Landroid/view/ViewGroup;Landroid/os/Bundle;)Landroid/view/View;");
    public static final ImmutableSet<String> startTracingOn = ImmutableSet.of("onCreate");
    private int access = 0;

    public ActivityClassVisitor(ClassVisitor cv, InstrumentationContext context, Log log) {
        super(cv, context, log, BASE_CLASS_NAMES, ImmutableMap.of(new Method("onStart", "()V"), new Method("activityStarted", "()V"), new Method("onStop", "()V"), new Method("activityStopped", "()V")));
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.access = access;
        this.instrument = this.shouldInstrumentClass(name, superName);
        if (this.instrument) {
            interfaces = TraceClassDecorator.addInterface(interfaces);
            this.log.info("[ActivityClassVisitor] Added Trace interface to class[" + this.context.getClassName() + "] superName[" + superName + "]");
        }
        super.visit(version, access, name, signature, superName, interfaces);
    }

    @Override
    protected void injectCodeIntoMethod(GeneratorAdapter generatorAdapter, Method method, Method monitorMethod) {
        generatorAdapter.invokeStatic(applicationStateMonitorType, new Method("getInstance", applicationStateMonitorType, new Type[0]));
        generatorAdapter.invokeVirtual(applicationStateMonitorType, monitorMethod);
    }

    @Override
    public MethodVisitor visitMethod(int access, String methodName, String desc, String signature, String[] exceptions) {
        if (this.context.isSkippedMethod(methodName, desc)) {
            this.log.debug("[ActivityClassVisitor] @SkipTrace applied to method [" + methodName + ", " + desc + "]");
        } else if (this.instrument && traceMethodMap.containsKey(methodName) && traceMethodMap.get(methodName).equals(desc)) {
            this.log.info("[ActivityClassVisitor] Tracing method [" + methodName + "]");
            MethodVisitor methodVisitor = super.visitMethod(access, methodName, desc, signature, exceptions);
            TraceMethodVisitor traceMethodVisitor = new TraceMethodVisitor(methodVisitor, access, methodName, desc, this.context);
            if (startTracingOn.contains(methodName)) {
                this.log.debug("[ActivityClassVisitor] Start new trace for [" + methodName + "]");
                traceMethodVisitor.setStartTracing();
            }
            return traceMethodVisitor;
        }
        return super.visitMethod(access, methodName, desc, signature, exceptions);
    }

    @Override
    public void visitEnd() {
        if (this.instrument) {
            TraceClassDecorator decorator = new TraceClassDecorator(this);
            decorator.addTraceField();
            this.log.debug("[ActivityClassVisitor] Added Trace object to " + this.context.getClassName());
            if ((this.access & 0x400) != 0) {
                this.log.info("[ActivityClassVisitor] Abstract base class: adding TraceFieldInterface impl to [" + this.context.getClassName() + "]");
                decorator.addTraceInterface(Type.getObjectType(this.context.getClassName()));
            }
        }
        this.access = 0;
        super.visitEnd();
    }

    private boolean isSupportClass(String className) {
        for (String sdk : IGNORED_SDK_PACKAGES) {
            if (!className.startsWith(sdk)) continue;
            return true;
        }
        return false;
    }
}

