/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.compile.visitor;

import com.newrelic.agent.compile.InstrumentationContext;
import com.newrelic.agent.compile.Log;
import com.newrelic.org.objectweb.asm.ClassVisitor;
import com.newrelic.org.objectweb.asm.MethodVisitor;
import com.newrelic.org.objectweb.asm.commons.GeneratorAdapter;
import com.newrelic.org.objectweb.asm.commons.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class EventHookClassVisitor
extends ClassVisitor {
    protected final Map<String, Pattern> baseClassPatterns;
    private final Map<Method, MethodVisitorFactory> methodVisitors;
    protected String superName;
    protected boolean instrument = false;
    protected final InstrumentationContext context;
    protected final Log log;

    public EventHookClassVisitor(ClassVisitor cv, InstrumentationContext context, Log log, Set<String> baseClasses, Map<Method, Method> methodMappings) {
        super(327680, cv);
        this.context = context;
        this.log = log;
        this.methodVisitors = new HashMap<Method, MethodVisitorFactory>();
        for (Map.Entry<Method, Method> entry : methodMappings.entrySet()) {
            this.methodVisitors.put(entry.getKey(), new MethodVisitorFactory(entry.getValue()));
        }
        this.baseClassPatterns = new HashMap<String, Pattern>();
        for (String pattern : baseClasses) {
            this.baseClassPatterns.put(pattern, Pattern.compile(pattern));
        }
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        this.superName = superName;
        if (!this.context.isSkippedMethod(name, signature)) {
            this.instrument = this.shouldInstrumentClass(this.context.getClassName(), superName);
        }
    }

    protected boolean shouldInstrumentClass(String className, String superName) {
        if (!className.startsWith("android/")) {
            for (Pattern baseClassPattern : this.baseClassPatterns.values()) {
                Matcher matcher = baseClassPattern.matcher(superName);
                if (!matcher.matches()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if (!this.instrument) {
            return mv;
        }
        Method method = new Method(name, desc);
        MethodVisitorFactory v = this.methodVisitors.get(method);
        if (v != null) {
            this.methodVisitors.remove(method);
            return v.createMethodVisitor(access, method, mv, false);
        }
        return mv;
    }

    @Override
    public void visitEnd() {
        if (!this.instrument) {
            return;
        }
        this.context.markModified();
        for (Map.Entry<Method, MethodVisitorFactory> entry : this.methodVisitors.entrySet()) {
            MethodVisitor mv = super.visitMethod(4, entry.getKey().getName(), entry.getKey().getDescriptor(), null, null);
            mv = entry.getValue().createMethodVisitor(4, entry.getKey(), mv, true);
            mv.visitCode();
            mv.visitInsn(177);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
        }
        super.visitEnd();
    }

    protected abstract void injectCodeIntoMethod(GeneratorAdapter var1, Method var2, Method var3);

    protected class MethodVisitorFactory {
        final Method monitorMethod;

        public MethodVisitorFactory(Method monitorMethod) {
            this.monitorMethod = monitorMethod;
        }

        public MethodVisitor createMethodVisitor(int access, final Method method, MethodVisitor mv, final boolean callSuper) {
            return new GeneratorAdapter(327680, mv, access, method.getName(), method.getDescriptor()){

                @Override
                public void visitCode() {
                    super.visitCode();
                    if (callSuper) {
                        this.loadThis();
                        for (int i = 0; i < method.getArgumentTypes().length; ++i) {
                            this.loadArg(i);
                        }
                        this.visitMethodInsn(183, EventHookClassVisitor.this.superName, method.getName(), method.getDescriptor(), false);
                    }
                    EventHookClassVisitor.this.injectCodeIntoMethod(this, method, MethodVisitorFactory.this.monitorMethod);
                }
            };
        }
    }
}

