/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.compile.visitor;

import com.newrelic.agent.util.AnnotationImpl;
import com.newrelic.agent.util.MethodAnnotation;
import com.newrelic.org.objectweb.asm.AnnotationVisitor;
import com.newrelic.org.objectweb.asm.ClassReader;
import com.newrelic.org.objectweb.asm.ClassVisitor;
import com.newrelic.org.objectweb.asm.MethodVisitor;
import java.util.ArrayList;
import java.util.Collection;

public class MethodAnnotationVisitor {
    public static Collection<MethodAnnotation> getAnnotations(ClassReader cr, String annotationDescription) {
        MethodAnnotationClassVisitor visitor = new MethodAnnotationClassVisitor(annotationDescription);
        cr.accept(visitor, 0);
        return visitor.getAnnotations();
    }

    private static class MethodAnnotationClassVisitor
    extends ClassVisitor {
        String className;
        private final String annotationDescription;
        private final Collection<MethodAnnotation> annotations = new ArrayList<MethodAnnotation>();

        public MethodAnnotationClassVisitor(String annotationDescription) {
            super(327680);
            this.annotationDescription = annotationDescription;
        }

        public Collection<MethodAnnotation> getAnnotations() {
            return this.annotations;
        }

        @Override
        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.className = name;
        }

        @Override
        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            return new MethodAnnotationVisitorImpl(name, desc);
        }

        private class MethodAnnotationVisitorImpl
        extends MethodVisitor {
            private final String methodName;
            private final String methodDesc;

            public MethodAnnotationVisitorImpl(String name, String desc) {
                super(327680);
                this.methodName = name;
                this.methodDesc = desc;
            }

            @Override
            public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                if (MethodAnnotationClassVisitor.this.annotationDescription.equals(desc)) {
                    MethodAnnotationImpl annotation = new MethodAnnotationImpl(desc);
                    MethodAnnotationClassVisitor.this.annotations.add(annotation);
                    return annotation;
                }
                return null;
            }

            private class MethodAnnotationImpl
            extends AnnotationImpl
            implements MethodAnnotation {
                public MethodAnnotationImpl(String desc) {
                    super(desc);
                }

                @Override
                public String getMethodName() {
                    return MethodAnnotationVisitorImpl.this.methodName;
                }

                @Override
                public String getMethodDesc() {
                    return MethodAnnotationVisitorImpl.this.methodDesc;
                }

                @Override
                public String getClassName() {
                    return MethodAnnotationClassVisitor.this.className;
                }
            }
        }
    }
}

