/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.compile.visitor;

import com.newrelic.agent.compile.InstrumentationContext;
import com.newrelic.agent.compile.Log;
import com.newrelic.agent.compile.visitor.Annotations;
import com.newrelic.agent.compile.visitor.TraceAnnotationVisitor;
import com.newrelic.org.objectweb.asm.AnnotationVisitor;
import com.newrelic.org.objectweb.asm.Attribute;
import com.newrelic.org.objectweb.asm.ClassVisitor;
import com.newrelic.org.objectweb.asm.FieldVisitor;
import com.newrelic.org.objectweb.asm.Label;
import com.newrelic.org.objectweb.asm.MethodVisitor;
import java.text.MessageFormat;

public class PrefilterClassVisitor
extends ClassVisitor {
    private static final String TRACE_ANNOTATION_CLASSPATH = "Lcom/newrelic/agent/android/instrumentation/Trace;";
    private static final String SKIP_TRACE_ANNOTATION_CLASSPATH = "Lcom/newrelic/agent/android/instrumentation/SkipTrace;";
    private final InstrumentationContext context;
    private final Log log;

    public PrefilterClassVisitor(InstrumentationContext context, Log log) {
        super(327680);
        this.context = context;
        this.log = log;
    }

    @Override
    public void visit(int version, int access, String name, String sig, String superName, String[] interfaces) {
        this.context.setClassName(name);
        this.context.setSuperClassName(superName);
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        if (Annotations.isNewRelicAnnotation(desc)) {
            this.log.info(MessageFormat.format("[{0}] class has New Relic tag: {1}", this.context.getClassName(), desc));
            this.context.addTag(desc);
        }
        return null;
    }

    @Override
    public void visitAttribute(Attribute arg0) {
    }

    @Override
    public void visitEnd() {
    }

    @Override
    public FieldVisitor visitField(int access, String name, String desc, String sig, Object value) {
        return null;
    }

    @Override
    public void visitInnerClass(String arg0, String arg1, String arg2, int arg3) {
    }

    @Override
    public MethodVisitor visitMethod(int access, final String name, final String desc, String signature, String[] exceptions) {
        MethodVisitor methodVisitor = new MethodVisitor(327680){

            @Override
            public AnnotationVisitor visitAnnotationDefault() {
                return null;
            }

            @Override
            public AnnotationVisitor visitAnnotation(String annotationDesc, boolean visible) {
                if (annotationDesc.equals(PrefilterClassVisitor.TRACE_ANNOTATION_CLASSPATH)) {
                    PrefilterClassVisitor.this.context.addTracedMethod(name, desc);
                    return new TraceAnnotationVisitor(name, PrefilterClassVisitor.this.context);
                }
                if (annotationDesc.equals(PrefilterClassVisitor.SKIP_TRACE_ANNOTATION_CLASSPATH)) {
                    PrefilterClassVisitor.this.context.addSkippedMethod(name, desc);
                    return null;
                }
                return null;
            }

            @Override
            public AnnotationVisitor visitParameterAnnotation(int i, String s, boolean b) {
                return null;
            }

            @Override
            public void visitAttribute(Attribute attribute) {
            }

            @Override
            public void visitCode() {
            }

            @Override
            public void visitFrame(int i, int i2, Object[] objects, int i3, Object[] objects2) {
            }

            @Override
            public void visitInsn(int i) {
            }

            @Override
            public void visitIntInsn(int i, int i2) {
            }

            @Override
            public void visitVarInsn(int i, int i2) {
            }

            @Override
            public void visitTypeInsn(int i, String s) {
            }

            @Override
            public void visitFieldInsn(int i, String s, String s2, String s3) {
            }

            @Override
            public void visitMethodInsn(int i, String s, String s2, String s3, boolean b) {
            }

            @Override
            public void visitJumpInsn(int i, Label label) {
            }

            @Override
            public void visitLabel(Label label) {
            }

            @Override
            public void visitLdcInsn(Object o) {
            }

            @Override
            public void visitIincInsn(int i, int i2) {
            }

            @Override
            public void visitTableSwitchInsn(int i, int i2, Label label, Label[] labels) {
            }

            @Override
            public void visitLookupSwitchInsn(Label label, int[] ints, Label[] labels) {
            }

            @Override
            public void visitMultiANewArrayInsn(String s, int i) {
            }

            @Override
            public void visitTryCatchBlock(Label label, Label label2, Label label3, String s) {
            }

            @Override
            public void visitLocalVariable(String s, String s2, String s3, Label label, Label label2, int i) {
            }

            @Override
            public void visitLineNumber(int i, Label label) {
            }

            @Override
            public void visitMaxs(int i, int i2) {
            }

            @Override
            public void visitEnd() {
            }
        };
        return methodVisitor;
    }

    @Override
    public void visitOuterClass(String arg0, String arg1, String arg2) {
    }

    @Override
    public void visitSource(String arg0, String arg1) {
    }
}

