/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.util;

import com.newrelic.org.objectweb.asm.AnnotationVisitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class AnnotationImpl
extends AnnotationVisitor {
    private final String name;
    private Map<String, Object> attributes;

    public AnnotationImpl(String name) {
        super(327680);
        this.name = name;
    }

    @Override
    public void visitEnum(String name, String desc, String value) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>();
        }
        this.attributes.put(name, value);
    }

    @Override
    public void visitEnd() {
    }

    @Override
    public AnnotationVisitor visitArray(String name) {
        return new ArrayVisitor(name);
    }

    @Override
    public AnnotationVisitor visitAnnotation(String name, String desc) {
        return null;
    }

    @Override
    public void visit(String name, Object value) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>();
        }
        this.attributes.put(name, value);
    }

    public String getName() {
        return this.name;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes == null ? Collections.emptyMap() : this.attributes;
    }

    private final class ArrayVisitor
    extends AnnotationVisitor {
        private final String name;
        private final ArrayList<Object> values;

        public ArrayVisitor(String name) {
            super(327680);
            this.values = new ArrayList();
            this.name = name;
        }

        @Override
        public void visit(String name, Object value) {
            this.values.add(value);
        }

        @Override
        public AnnotationVisitor visitAnnotation(String arg0, String arg1) {
            return null;
        }

        @Override
        public AnnotationVisitor visitArray(String name) {
            return null;
        }

        @Override
        public void visitEnd() {
            AnnotationImpl.this.visit(this.name, this.values.toArray(new String[0]));
        }

        @Override
        public void visitEnum(String arg0, String arg1, String arg2) {
        }
    }
}

