/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.util;

import com.newrelic.agent.android.Agent;
import com.newrelic.agent.compile.visitor.ClassAnnotationVisitor;
import com.newrelic.agent.compile.visitor.MethodAnnotationVisitor;
import com.newrelic.agent.util.ClassAnnotation;
import com.newrelic.agent.util.MethodAnnotation;
import com.newrelic.agent.util.Streams;
import com.newrelic.org.objectweb.asm.ClassReader;
import com.newrelic.org.objectweb.asm.Type;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;

public class Annotations {
    private Annotations() {
    }

    public static Collection<ClassAnnotation> getClassAnnotations(Class annotationClass, String packageSearchPath, Set<URL> classpathURLs) {
        String annotationDescription = 'L' + annotationClass.getName().replace('.', '/') + ';';
        System.out.println("getClassAnnotations: annotationClass[" + annotationClass.getSimpleName() + "] packageSearchPath[" + packageSearchPath + "]  classpathURLs[" + classpathURLs + "])");
        Map<String, URL> fileNames = Annotations.getMatchingFiles(packageSearchPath, classpathURLs);
        ArrayList<ClassAnnotation> list = new ArrayList<ClassAnnotation>();
        for (Map.Entry<String, URL> entry : fileNames.entrySet()) {
            String fileName = entry.getKey();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                Streams.copy(Annotations.class.getResourceAsStream('/' + fileName), (OutputStream)out, true);
                ClassReader cr = new ClassReader(out.toByteArray());
                Collection<ClassAnnotation> annotations = ClassAnnotationVisitor.getAnnotations(cr, annotationDescription);
                list.addAll(annotations);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return list;
    }

    public static Collection<MethodAnnotation> getMethodAnnotations(Class annotationClass, String packageSearchPath, Set<URL> classpathURLs) {
        String annotationDescription = Type.getType(annotationClass).getDescriptor();
        System.out.println("getClassAnnotations: annotationClass[" + annotationClass.getSimpleName() + "] packageSearchPath[" + packageSearchPath + "]  classpathURLs[" + classpathURLs + "])");
        Map<String, URL> fileNames = Annotations.getMatchingFiles(packageSearchPath, classpathURLs);
        ArrayList<MethodAnnotation> list = new ArrayList<MethodAnnotation>();
        for (Map.Entry<String, URL> entry : fileNames.entrySet()) {
            String fileName = entry.getKey();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                Streams.copy(Annotations.class.getResourceAsStream('/' + fileName), (OutputStream)out, true);
                ClassReader cr = new ClassReader(out.toByteArray());
                Collection<MethodAnnotation> annotations = MethodAnnotationVisitor.getAnnotations(cr, annotationDescription);
                list.addAll(annotations);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return list;
    }

    private static Map<String, URL> getMatchingFiles(String packageSearchPath, Set<URL> classpathURLs) {
        if (!packageSearchPath.endsWith("/")) {
            packageSearchPath = packageSearchPath + "/";
        }
        Pattern pattern = Pattern.compile("(.*).class");
        Map<String, URL> fileNames = Annotations.getMatchingFileNames(pattern, classpathURLs);
        for (String file : fileNames.keySet().toArray(new String[0])) {
            if (file.startsWith(packageSearchPath)) continue;
            fileNames.remove(file);
        }
        return fileNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Map<String, URL> getMatchingFileNames(Pattern pattern, Collection<URL> urls) {
        HashMap<String, URL> names = new HashMap<String, URL>();
        for (URL url : urls) {
            File file;
            url = Annotations.fixUrl(url);
            try {
                file = new File(URLDecoder.decode(url.getFile(), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                System.exit(1);
                return names;
            }
            if (file.isDirectory()) {
                List<File> files = PatternFileMatcher.getMatchingFiles(file, pattern);
                for (File f : files) {
                    String path = f.getAbsolutePath();
                    path = path.substring(file.getAbsolutePath().length() + 1);
                    names.put(path, url);
                }
                continue;
            }
            if (!file.isFile()) continue;
            JarFile jarFile = null;
            try {
                jarFile = new JarFile(file);
                Enumeration<JarEntry> entries = jarFile.entries();
                while (entries.hasMoreElements()) {
                    JarEntry jarEntry = entries.nextElement();
                    if (!pattern.matcher(jarEntry.getName()).matches()) continue;
                    names.put(jarEntry.getName(), url);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                System.exit(1);
            }
            finally {
                if (jarFile == null) continue;
                try {
                    jarFile.close();
                }
                catch (IOException iOException) {}
            }
        }
        return names;
    }

    private static URL fixUrl(URL url) {
        String protocol = url.getProtocol();
        if ("jar".equals(protocol)) {
            try {
                String urlString = url.toString().substring(4);
                int index = urlString.indexOf("!/");
                if (index > 0) {
                    urlString = urlString.substring(0, index);
                }
                url = new URL(urlString);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return url;
    }

    static URL[] getClasspathURLs() {
        ClassLoader classLoader = Agent.class.getClassLoader();
        if (classLoader instanceof URLClassLoader) {
            return ((URLClassLoader)classLoader).getURLs();
        }
        return new URL[0];
    }

    static class PatternFileMatcher {
        private final FileFilter filter;
        private final List<File> files = new ArrayList<File>();

        public static List<File> getMatchingFiles(File directory, Pattern pattern) {
            PatternFileMatcher matcher = new PatternFileMatcher(pattern);
            directory.listFiles(matcher.filter);
            return matcher.files;
        }

        private PatternFileMatcher(final Pattern pattern) {
            this.filter = new FileFilter(){

                @Override
                public boolean accept(File f) {
                    boolean match;
                    if (f.isDirectory()) {
                        f.listFiles(this);
                    }
                    if (match = pattern.matcher(f.getAbsolutePath()).matches()) {
                        PatternFileMatcher.this.files.add(f);
                    }
                    return match;
                }
            };
        }
    }
}

