/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.javassist;

import com.newrelic.javassist.CannotCompileException;
import com.newrelic.javassist.CtClass;
import com.newrelic.javassist.CtField;
import com.newrelic.javassist.CtMethod;
import com.newrelic.javassist.Modifier;
import com.newrelic.javassist.NotFoundException;
import com.newrelic.javassist.bytecode.BadBytecode;
import com.newrelic.javassist.bytecode.CodeAttribute;
import com.newrelic.javassist.bytecode.CodeIterator;
import com.newrelic.javassist.bytecode.ConstPool;
import com.newrelic.javassist.bytecode.MethodInfo;
import com.newrelic.javassist.convert.TransformAccessArrayField;
import com.newrelic.javassist.convert.TransformAfter;
import com.newrelic.javassist.convert.TransformBefore;
import com.newrelic.javassist.convert.TransformCall;
import com.newrelic.javassist.convert.TransformFieldAccess;
import com.newrelic.javassist.convert.TransformNew;
import com.newrelic.javassist.convert.TransformNewClass;
import com.newrelic.javassist.convert.TransformReadField;
import com.newrelic.javassist.convert.TransformWriteField;
import com.newrelic.javassist.convert.Transformer;

public class CodeConverter {
    protected Transformer transformers = null;

    public void replaceNew(CtClass newClass, CtClass calledClass, String calledMethod) {
        this.transformers = new TransformNew(this.transformers, newClass.getName(), calledClass.getName(), calledMethod);
    }

    public void replaceNew(CtClass oldClass, CtClass newClass) {
        this.transformers = new TransformNewClass(this.transformers, oldClass.getName(), newClass.getName());
    }

    public void redirectFieldAccess(CtField field, CtClass newClass, String newFieldname) {
        this.transformers = new TransformFieldAccess(this.transformers, field, newClass.getName(), newFieldname);
    }

    public void replaceFieldRead(CtField field, CtClass calledClass, String calledMethod) {
        this.transformers = new TransformReadField(this.transformers, field, calledClass.getName(), calledMethod);
    }

    public void replaceFieldWrite(CtField field, CtClass calledClass, String calledMethod) {
        this.transformers = new TransformWriteField(this.transformers, field, calledClass.getName(), calledMethod);
    }

    public void replaceArrayAccess(CtClass calledClass, ArrayAccessReplacementMethodNames names) throws NotFoundException {
        this.transformers = new TransformAccessArrayField(this.transformers, calledClass.getName(), names);
    }

    public void redirectMethodCall(CtMethod origMethod, CtMethod substMethod) throws CannotCompileException {
        String d2;
        String d1 = origMethod.getMethodInfo2().getDescriptor();
        if (!d1.equals(d2 = substMethod.getMethodInfo2().getDescriptor())) {
            throw new CannotCompileException("signature mismatch: " + substMethod.getLongName());
        }
        int mod1 = origMethod.getModifiers();
        int mod2 = substMethod.getModifiers();
        if (Modifier.isStatic(mod1) != Modifier.isStatic(mod2) || Modifier.isPrivate(mod1) && !Modifier.isPrivate(mod2) || origMethod.getDeclaringClass().isInterface() != substMethod.getDeclaringClass().isInterface()) {
            throw new CannotCompileException("invoke-type mismatch " + substMethod.getLongName());
        }
        this.transformers = new TransformCall(this.transformers, origMethod, substMethod);
    }

    public void redirectMethodCall(String oldMethodName, CtMethod newMethod) throws CannotCompileException {
        this.transformers = new TransformCall(this.transformers, oldMethodName, newMethod);
    }

    public void insertBeforeMethod(CtMethod origMethod, CtMethod beforeMethod) throws CannotCompileException {
        try {
            this.transformers = new TransformBefore(this.transformers, origMethod, beforeMethod);
        }
        catch (NotFoundException e) {
            throw new CannotCompileException(e);
        }
    }

    public void insertAfterMethod(CtMethod origMethod, CtMethod afterMethod) throws CannotCompileException {
        try {
            this.transformers = new TransformAfter(this.transformers, origMethod, afterMethod);
        }
        catch (NotFoundException e) {
            throw new CannotCompileException(e);
        }
    }

    protected void doit(CtClass clazz, MethodInfo minfo, ConstPool cp) throws CannotCompileException {
        Transformer t;
        CodeAttribute codeAttr = minfo.getCodeAttribute();
        if (codeAttr == null || this.transformers == null) {
            return;
        }
        for (t = this.transformers; t != null; t = t.getNext()) {
            t.initialize(cp, clazz, minfo);
        }
        CodeIterator iterator = codeAttr.iterator();
        while (iterator.hasNext()) {
            try {
                int pos = iterator.next();
                for (t = this.transformers; t != null; t = t.getNext()) {
                    pos = t.transform(clazz, pos, iterator, cp);
                }
            }
            catch (BadBytecode e) {
                throw new CannotCompileException(e);
            }
        }
        int locals = 0;
        int stack = 0;
        for (t = this.transformers; t != null; t = t.getNext()) {
            int s = t.extraLocals();
            if (s > locals) {
                locals = s;
            }
            if ((s = t.extraStack()) <= stack) continue;
            stack = s;
        }
        for (t = this.transformers; t != null; t = t.getNext()) {
            t.clean();
        }
        if (locals > 0) {
            codeAttr.setMaxLocals(codeAttr.getMaxLocals() + locals);
        }
        if (stack > 0) {
            codeAttr.setMaxStack(codeAttr.getMaxStack() + stack);
        }
    }

    public static class DefaultArrayAccessReplacementMethodNames
    implements ArrayAccessReplacementMethodNames {
        public String byteOrBooleanRead() {
            return "arrayReadByteOrBoolean";
        }

        public String byteOrBooleanWrite() {
            return "arrayWriteByteOrBoolean";
        }

        public String charRead() {
            return "arrayReadChar";
        }

        public String charWrite() {
            return "arrayWriteChar";
        }

        public String doubleRead() {
            return "arrayReadDouble";
        }

        public String doubleWrite() {
            return "arrayWriteDouble";
        }

        public String floatRead() {
            return "arrayReadFloat";
        }

        public String floatWrite() {
            return "arrayWriteFloat";
        }

        public String intRead() {
            return "arrayReadInt";
        }

        public String intWrite() {
            return "arrayWriteInt";
        }

        public String longRead() {
            return "arrayReadLong";
        }

        public String longWrite() {
            return "arrayWriteLong";
        }

        public String objectRead() {
            return "arrayReadObject";
        }

        public String objectWrite() {
            return "arrayWriteObject";
        }

        public String shortRead() {
            return "arrayReadShort";
        }

        public String shortWrite() {
            return "arrayWriteShort";
        }
    }

    public static interface ArrayAccessReplacementMethodNames {
        public String byteOrBooleanRead();

        public String byteOrBooleanWrite();

        public String charRead();

        public String charWrite();

        public String doubleRead();

        public String doubleWrite();

        public String floatRead();

        public String floatWrite();

        public String intRead();

        public String intWrite();

        public String longRead();

        public String longWrite();

        public String objectRead();

        public String objectWrite();

        public String shortRead();

        public String shortWrite();
    }
}

