/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.org.reflections;

import com.newrelic.com.google.common.base.Predicate;
import com.newrelic.com.google.common.collect.Lists;
import com.newrelic.com.google.common.collect.Sets;
import com.newrelic.org.reflections.Configuration;
import com.newrelic.org.reflections.ReflectionUtils;
import com.newrelic.org.reflections.ReflectionsException;
import com.newrelic.org.reflections.Store;
import com.newrelic.org.reflections.scanners.Scanner;
import com.newrelic.org.reflections.serializers.Serializer;
import com.newrelic.org.reflections.serializers.XmlSerializer;
import com.newrelic.org.reflections.util.ClasspathHelper;
import com.newrelic.org.reflections.util.ConfigurationBuilder;
import com.newrelic.org.reflections.util.FilterBuilder;
import com.newrelic.org.reflections.util.Utils;
import com.newrelic.org.reflections.vfs.Vfs;
import com.newrelic.org.slf4j.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Reflections
extends ReflectionUtils {
    @Nullable
    public static Logger log = Utils.findLogger(Reflections.class);
    protected final transient Configuration configuration;
    private Store store;

    public Reflections(Configuration configuration) {
        this.configuration = configuration;
        this.store = new Store(configuration.getExecutorService() != null);
        if (configuration.getScanners() != null && !configuration.getScanners().isEmpty()) {
            for (Scanner scanner : configuration.getScanners()) {
                scanner.setConfiguration(configuration);
                scanner.setStore(this.store.getOrCreate(scanner.getClass().getSimpleName()));
            }
            this.scan();
        }
    }

    public Reflections(String prefix, Scanner ... scanners) {
        this(new Object[]{prefix, scanners});
    }

    public Reflections(Object ... params) {
        this(ConfigurationBuilder.build(params));
    }

    protected Reflections() {
        this.configuration = new ConfigurationBuilder();
        this.store = new Store(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void scan() {
        block19: {
            block20: {
                if (this.configuration.getUrls() == null || this.configuration.getUrls().isEmpty()) {
                    if (Reflections.log != null) {
                        Reflections.log.error("given scan urls are empty. set urls in the configuration");
                    }
                    return;
                }
                if (Reflections.log != null && Reflections.log.isDebugEnabled()) {
                    urls = new StringBuilder();
                    for (URL url : this.configuration.getUrls()) {
                        urls.append("\t").append(url.toExternalForm()).append("\n");
                    }
                    Reflections.log.debug("going to scan these urls:\n" + urls);
                }
                time = System.currentTimeMillis();
                scannedUrls = 0;
                executorService = this.configuration.getExecutorService();
                if (executorService != null) break block20;
                i$ = this.configuration.getUrls().iterator();
                ** GOTO lbl23
            }
            futures = Lists.newArrayList();
            try {
                block21: {
                    i$ = this.configuration.getUrls().iterator();
                    break block21;
lbl23:
                    // 4 sources

                    while (i$.hasNext()) {
                        url = i$.next();
                        try {
                            for (Vfs.File file : Vfs.fromURL(url).getFiles()) {
                                this.scan(file);
                            }
                            ++scannedUrls;
                        }
                        catch (ReflectionsException var9_11) {
                            if (Reflections.log == null) continue;
                            Reflections.log.error("could not create Vfs.Dir from url. ignoring the exception and continuing", var9_11);
                        }
                    }
                    break block19;
                }
                while (i$.hasNext()) {
                    var9_12 = i$.next();
                    try {
                        for (final Vfs.File file : Vfs.fromURL(var9_12).getFiles()) {
                            futures.add(executorService.submit(new Runnable(){

                                public void run() {
                                    Reflections.this.scan(file);
                                }
                            }));
                        }
                        ++scannedUrls;
                    }
                    catch (ReflectionsException e) {
                        if (Reflections.log == null) continue;
                        Reflections.log.error("could not create Vfs.Dir from url. ignoring the exception and continuing", e);
                    }
                }
                for (Future var9_14 : futures) {
                    try {
                        var9_14.get();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            finally {
                executorService.shutdown();
            }
        }
        time = System.currentTimeMillis() - time;
        keys = this.store.getKeysCount();
        values = this.store.getValuesCount();
        if (Reflections.log != null) {
            Reflections.log.info(String.format("Reflections took %d ms to scan %d urls, producing %d keys and %d values %s", new Object[]{time, scannedUrls, keys, values, executorService != null && executorService instanceof ThreadPoolExecutor != false ? String.format("[using %d cores]", new Object[]{((ThreadPoolExecutor)executorService).getMaximumPoolSize()}) : ""}));
        }
    }

    private void scan(Vfs.File file) {
        String input = file.getRelativePath().replace('/', '.');
        if (this.configuration.acceptsInput(input)) {
            for (Scanner scanner : this.configuration.getScanners()) {
                try {
                    if (!scanner.acceptsInput(input)) continue;
                    scanner.scan(file);
                }
                catch (Exception e) {
                    log.warn("could not scan file " + file.toString() + " with scanner " + scanner.getClass().getSimpleName(), e);
                }
            }
        }
    }

    public static Reflections collect() {
        return Reflections.collect("META-INF/reflections", new FilterBuilder().include(".*-reflections.xml"), new Serializer[0]);
    }

    public static Reflections collect(String packagePrefix, Predicate<String> resourceNameFilter, Serializer ... optionalSerializer) {
        XmlSerializer serializer = optionalSerializer != null && optionalSerializer.length == 1 ? optionalSerializer[0] : new XmlSerializer();
        Reflections reflections = new Reflections();
        for (Vfs.File file : Vfs.findFiles(ClasspathHelper.forPackage(packagePrefix, new ClassLoader[0]), packagePrefix, resourceNameFilter)) {
            InputStream inputStream = null;
            try {
                inputStream = file.openInputStream();
                reflections.merge(serializer.read(inputStream));
                if (log == null) continue;
                log.info("Reflections collected metadata from " + file + " using serializer " + serializer.getClass().getName());
            }
            catch (IOException e) {
                throw new ReflectionsException("could not merge " + file, e);
            }
            finally {
                Utils.close(inputStream);
            }
        }
        return reflections;
    }

    public Reflections collect(InputStream inputStream) {
        try {
            this.merge(this.configuration.getSerializer().read(inputStream));
            if (log != null) {
                log.info("Reflections collected metadata from input stream using serializer " + this.configuration.getSerializer().getClass().getName());
            }
        }
        catch (Exception ex) {
            throw new ReflectionsException("could not merge input stream", ex);
        }
        return this;
    }

    public Reflections collect(File file) {
        Reflections reflections;
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            reflections = this.collect(inputStream);
        }
        catch (FileNotFoundException e) {
            try {
                throw new ReflectionsException("could not obtain input stream from file " + file, e);
            }
            catch (Throwable throwable) {
                Utils.close(inputStream);
                throw throwable;
            }
        }
        Utils.close(inputStream);
        return reflections;
    }

    public Reflections merge(Reflections reflections) {
        this.store.merge(reflections.store);
        return this;
    }

    @Nullable
    public <T extends Scanner> T get(Class<T> scannerClass) {
        for (Scanner scanner : this.configuration.getScanners()) {
            if (!scanner.getClass().equals(scannerClass)) continue;
            return (T)scanner;
        }
        return null;
    }

    public <T> Set<Class<? extends T>> getSubTypesOf(Class<T> type) {
        Set<String> subTypes = this.store.getSubTypesOf(type.getName());
        return this.toClasses(subTypes);
    }

    public Set<Class<?>> getTypesAnnotatedWith(Class<? extends Annotation> annotation) {
        Set<String> typesAnnotatedWith = this.store.getTypesAnnotatedWith(annotation.getName());
        return this.toClasses(typesAnnotatedWith);
    }

    public Set<Class<?>> getTypesAnnotatedWith(Class<? extends Annotation> annotation, boolean honorInherited) {
        Set<String> typesAnnotatedWith = this.store.getTypesAnnotatedWith(annotation.getName(), honorInherited);
        return this.toClasses(typesAnnotatedWith);
    }

    public Set<Class<?>> getTypesAnnotatedWith(Annotation annotation) {
        return this.getTypesAnnotatedWith(annotation, true);
    }

    public Set<Class<?>> getTypesAnnotatedWith(Annotation annotation, boolean honorInherited) {
        Set<String> types = this.store.getTypesAnnotatedWithDirectly(annotation.annotationType().getName());
        Set<Class<?>> annotated = Reflections.getAll(this.toClasses(types), Reflections.withAnnotation(annotation));
        Set<String> inherited = this.store.getInheritedSubTypes(Reflections.names(annotated), annotation.annotationType().getName(), honorInherited);
        return this.toClasses(inherited);
    }

    public Set<Method> getMethodsAnnotatedWith(Class<? extends Annotation> annotation) {
        Set<String> annotatedWith = this.store.getMethodsAnnotatedWith(annotation.getName());
        HashSet<Method> result = Sets.newHashSet();
        for (String annotated : annotatedWith) {
            result.add(Utils.getMethodFromDescriptor(annotated, this.configuration.getClassLoaders()));
        }
        return result;
    }

    public Set<Method> getMethodsAnnotatedWith(Annotation annotation) {
        return Reflections.getAll(this.getMethodsAnnotatedWith(annotation.annotationType()), Reflections.withAnnotation(annotation));
    }

    public Set<Field> getFieldsAnnotatedWith(Class<? extends Annotation> annotation) {
        HashSet<Field> result = Sets.newHashSet();
        Set<String> annotatedWith = this.store.getFieldsAnnotatedWith(annotation.getName());
        for (String annotated : annotatedWith) {
            result.add(Utils.getFieldFromString(annotated, this.configuration.getClassLoaders()));
        }
        return result;
    }

    public Set<Field> getFieldsAnnotatedWith(Annotation annotation) {
        return Reflections.getAll(this.getFieldsAnnotatedWith(annotation.annotationType()), Reflections.withAnnotation(annotation));
    }

    public Set<String> getResources(Predicate<String> namePredicate) {
        return this.store.getResources(namePredicate);
    }

    public Set<String> getResources(final Pattern pattern) {
        return this.getResources(new Predicate<String>(){

            @Override
            public boolean apply(String input) {
                return pattern.matcher(input).matches();
            }
        });
    }

    private <T> Set<Class<? extends T>> toClasses(Set<String> names) {
        return Sets.newHashSet(ReflectionUtils.forNames(names, this.configuration.getClassLoaders()));
    }

    public Store getStore() {
        return this.store;
    }

    public File save(String filename) {
        return this.save(filename, this.configuration.getSerializer());
    }

    public File save(String filename, Serializer serializer) {
        File file = serializer.save(this, filename);
        if (log != null) {
            log.info("Reflections successfully saved in " + file.getAbsolutePath() + " using " + serializer.getClass().getSimpleName());
        }
        return file;
    }
}

