/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.org.reflections.scanners;

import com.newrelic.org.reflections.scanners.AbstractScanner;
import java.util.List;

public class MethodParametersAnnotationsScanner
extends AbstractScanner {
    public void scan(Object cls) {
        String className = this.getMetadataAdapter().getClassName(cls);
        List methods = this.getMetadataAdapter().getMethods(cls);
        for (Object method : methods) {
            List<String> parameters = this.getMetadataAdapter().getParameterNames(method);
            for (int parameterIndex = 0; parameterIndex < parameters.size(); ++parameterIndex) {
                List<String> parameterAnnotations = this.getMetadataAdapter().getParameterAnnotationNames(method, parameterIndex);
                for (String parameterAnnotation : parameterAnnotations) {
                    if (!this.acceptResult(parameterAnnotation)) continue;
                    this.getStore().put(parameterAnnotation, String.format("%s.%s:%s %s", className, method, parameters.get(parameterIndex), parameterAnnotation));
                }
            }
        }
    }
}

