/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.org.reflections.scanners;

import com.newrelic.org.reflections.scanners.AbstractScanner;
import com.newrelic.org.reflections.scanners.TypesScanner;

public class TypeElementsScanner
extends AbstractScanner {
    private boolean includeFields = true;
    private boolean includeMethods = true;
    private boolean publicOnly = true;

    public void scan(Object cls) {
        if (TypesScanner.isJavaCodeSerializer(this.getMetadataAdapter().getInterfacesNames(cls))) {
            return;
        }
        String className = this.getMetadataAdapter().getClassName(cls);
        if (this.includeFields) {
            for (Object field : this.getMetadataAdapter().getFields(cls)) {
                String fieldName = this.getMetadataAdapter().getFieldName(field);
                this.getStore().put(className, fieldName);
            }
        }
        if (this.includeMethods) {
            for (Object method : this.getMetadataAdapter().getMethods(cls)) {
                if (this.publicOnly && !this.getMetadataAdapter().isPublic(method)) continue;
                this.getStore().put(className, this.getMetadataAdapter().getMethodKey(cls, method));
            }
        }
    }

    public TypeElementsScanner includeFields() {
        return this.includeFields(true);
    }

    public TypeElementsScanner includeFields(boolean include) {
        this.includeFields = include;
        return this;
    }

    public TypeElementsScanner includeMethods() {
        return this.includeMethods(true);
    }

    public TypeElementsScanner includeMethods(boolean include) {
        this.includeMethods = include;
        return this;
    }

    public TypeElementsScanner publicOnly(boolean only) {
        this.publicOnly = only;
        return this;
    }

    public TypeElementsScanner publicOnly() {
        return this.publicOnly(true);
    }
}

