/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo2.webcontainer;

import java.util.HashSet;
import java.util.Set;
import nextapp.echo2.app.ApplicationInstance;
import nextapp.echo2.app.Command;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Window;
import nextapp.echo2.app.update.PropertyUpdate;
import nextapp.echo2.app.update.ServerComponentUpdate;
import nextapp.echo2.app.update.ServerUpdateManager;
import nextapp.echo2.app.update.UpdateManager;
import nextapp.echo2.webcontainer.ActionProcessor;
import nextapp.echo2.webcontainer.CommandSynchronizePeer;
import nextapp.echo2.webcontainer.ComponentSynchronizePeer;
import nextapp.echo2.webcontainer.ContainerInstance;
import nextapp.echo2.webcontainer.FocusSupport;
import nextapp.echo2.webcontainer.LazyRenderContainer;
import nextapp.echo2.webcontainer.PropertyUpdateProcessor;
import nextapp.echo2.webcontainer.RenderContext;
import nextapp.echo2.webcontainer.RenderContextImpl;
import nextapp.echo2.webcontainer.RootSynchronizePeer;
import nextapp.echo2.webcontainer.SynchronizePeerFactory;
import nextapp.echo2.webcontainer.syncpeer.WindowPeer;
import nextapp.echo2.webrender.Connection;
import nextapp.echo2.webrender.ServerMessage;
import nextapp.echo2.webrender.Service;
import nextapp.echo2.webrender.UserInstance;
import nextapp.echo2.webrender.WebRenderServlet;
import nextapp.echo2.webrender.servermessage.WindowUpdate;
import nextapp.echo2.webrender.service.JavaScriptService;
import nextapp.echo2.webrender.service.SynchronizeService;
import nextapp.echo2.webrender.util.DomUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ContainerSynchronizeService
extends SynchronizeService {
    public static final Service WEB_CONTAINER_SERVICE = JavaScriptService.forResource((String)"Echo.WebContainer", (String)"/nextapp/echo2/webcontainer/resource/js/WebContainer.js");
    public static final ContainerSynchronizeService INSTANCE;
    private SynchronizeService.ClientMessagePartProcessor propertyUpdateProcessor = new SynchronizeService.ClientMessagePartProcessor(){

        public String getName() {
            return "EchoPropertyUpdate";
        }

        public void process(UserInstance userInstance, Element messagePartElement) {
            ContainerInstance ci = (ContainerInstance)userInstance;
            Element[] propertyElements = DomUtil.getChildElementsByTagName((Element)messagePartElement, (String)"property");
            for (int i = 0; i < propertyElements.length; ++i) {
                String componentId = propertyElements[i].getAttribute("component-id");
                Component component = ci.getComponentByElementId(componentId);
                if (component == null) continue;
                ComponentSynchronizePeer syncPeer = SynchronizePeerFactory.getPeerForComponent(component.getClass());
                if (!(syncPeer instanceof PropertyUpdateProcessor)) {
                    throw new IllegalStateException("Target peer is not an PropertyUpdateProcessor.");
                }
                ((PropertyUpdateProcessor)((Object)syncPeer)).processPropertyUpdate(ci, component, propertyElements[i]);
            }
        }
    };
    private SynchronizeService.ClientMessagePartProcessor actionProcessor = new SynchronizeService.ClientMessagePartProcessor(){

        public String getName() {
            return "EchoAction";
        }

        public void process(UserInstance userInstance, Element messagePartElement) {
            ContainerInstance ci = (ContainerInstance)userInstance;
            Element actionElement = DomUtil.getChildElementByTagName((Element)messagePartElement, (String)"action");
            String componentId = actionElement.getAttribute("component-id");
            Component component = ci.getComponentByElementId(componentId);
            if (component == null) {
                return;
            }
            ComponentSynchronizePeer syncPeer = SynchronizePeerFactory.getPeerForComponent(component.getClass());
            if (!(syncPeer instanceof ActionProcessor)) {
                throw new IllegalStateException("Target peer is not an ActionProcessor.");
            }
            ((ActionProcessor)((Object)syncPeer)).processAction(ci, component, actionElement);
        }
    };

    private static boolean isAncestor(Set potentialAncestors, Component component) {
        for (component = component.getParent(); component != null; component = component.getParent()) {
            if (!potentialAncestors.contains(component)) continue;
            return true;
        }
        return false;
    }

    private ContainerSynchronizeService() {
        this.registerClientMessagePartProcessor(this.propertyUpdateProcessor);
        this.registerClientMessagePartProcessor(this.actionProcessor);
    }

    private void disposeComponents(RenderContext rc, ServerComponentUpdate componentUpdate, Component[] disposedComponents) {
        ContainerInstance ci = rc.getContainerInstance();
        for (int i = 0; i < disposedComponents.length; ++i) {
            ComponentSynchronizePeer disposedSyncPeer = SynchronizePeerFactory.getPeerForComponent(disposedComponents[i].getClass());
            disposedSyncPeer.renderDispose(rc, componentUpdate, disposedComponents[i]);
            ci.removeRenderState(disposedComponents[i]);
        }
    }

    private void disposeReplacedDescendants(RenderContext rc, ServerComponentUpdate update, Component parent) {
        Component[] replacedComponents = parent.getVisibleComponents();
        boolean isRoot = parent == update.getParent();
        for (int i = 0; i < replacedComponents.length; ++i) {
            if (isRoot && update.hasAddedChild(replacedComponents[i])) continue;
            this.disposeReplacedDescendants(rc, update, replacedComponents[i]);
            ComponentSynchronizePeer syncPeer = SynchronizePeerFactory.getPeerForComponent(replacedComponents[i].getClass());
            syncPeer.renderDispose(rc, update, replacedComponents[i]);
        }
    }

    private boolean isRendered(ContainerInstance ci, Component component) {
        boolean rendered;
        Component parent = component.getParent();
        if (parent == null) {
            return true;
        }
        ComponentSynchronizePeer syncPeer = SynchronizePeerFactory.getPeerForComponent(parent.getClass());
        if (syncPeer instanceof LazyRenderContainer && !(rendered = ((LazyRenderContainer)((Object)syncPeer)).isRendered(ci, parent, component))) {
            return false;
        }
        return this.isRendered(ci, parent);
    }

    private void processClientFocusedComponent(RenderContext rc, Document clientMessageDocument) {
        if (clientMessageDocument.getDocumentElement().hasAttribute("focus")) {
            String focusedComponentId = clientMessageDocument.getDocumentElement().getAttribute("focus");
            Component component = null;
            if (focusedComponentId.length() > 2) {
                component = rc.getContainerInstance().getComponentByElementId(focusedComponentId);
            }
            ApplicationInstance applicationInstance = rc.getContainerInstance().getApplicationInstance();
            applicationInstance.getUpdateManager().getClientUpdateManager().setApplicationProperty("focusedComponent", (Object)component);
        }
    }

    private void processInvalidTransaction(RenderContext rc) {
        WindowUpdate.renderReload((ServerMessage)rc.getServerMessage());
    }

    private void processQueuedCommands(RenderContext rc) {
        ServerUpdateManager serverUpdateManager = rc.getContainerInstance().getUpdateManager().getServerUpdateManager();
        Command[] commands = serverUpdateManager.getCommands();
        for (int i = 0; i < commands.length; ++i) {
            CommandSynchronizePeer peer = SynchronizePeerFactory.getPeerForCommand(commands[i].getClass());
            peer.render(rc, commands[i]);
        }
    }

    private void processServerUpdates(RenderContext rc) {
        ContainerInstance ci = rc.getContainerInstance();
        UpdateManager updateManager = ci.getUpdateManager();
        ServerUpdateManager serverUpdateManager = updateManager.getServerUpdateManager();
        ServerComponentUpdate[] componentUpdates = updateManager.getServerUpdateManager().getComponentUpdates();
        if (serverUpdateManager.isFullRefreshRequired()) {
            Window window = rc.getContainerInstance().getApplicationInstance().getDefaultWindow();
            ServerComponentUpdate fullRefreshUpdate = componentUpdates[0];
            Component[] removedDescendants = fullRefreshUpdate.getRemovedDescendants();
            this.disposeComponents(rc, fullRefreshUpdate, removedDescendants);
            RootSynchronizePeer rootSyncPeer = (RootSynchronizePeer)SynchronizePeerFactory.getPeerForComponent(window.getClass());
            rootSyncPeer.renderRefresh(rc, fullRefreshUpdate, (Component)window);
            this.setRootLayoutDirection(rc);
        } else {
            for (int i = 0; i < componentUpdates.length; ++i) {
                if (this.isRendered(ci, componentUpdates[i].getParent())) continue;
                componentUpdates[i] = null;
            }
            HashSet<Component> fullyReplacedHierarchies = new HashSet<Component>();
            for (int i = 0; i < componentUpdates.length; ++i) {
                String targetId;
                if (componentUpdates[i] == null) continue;
                Component[] removedChildren = componentUpdates[i].getRemovedChildren();
                this.disposeComponents(rc, componentUpdates[i], removedChildren);
                Component[] removedDescendants = componentUpdates[i].getRemovedDescendants();
                this.disposeComponents(rc, componentUpdates[i], removedDescendants);
                Component parentComponent = componentUpdates[i].getParent();
                if (ContainerSynchronizeService.isAncestor(fullyReplacedHierarchies, parentComponent)) continue;
                ComponentSynchronizePeer syncPeer = SynchronizePeerFactory.getPeerForComponent(parentComponent.getClass());
                if (parentComponent.getParent() == null) {
                    targetId = null;
                } else {
                    ComponentSynchronizePeer parentSyncPeer = SynchronizePeerFactory.getPeerForComponent(parentComponent.getParent().getClass());
                    targetId = parentSyncPeer.getContainerId(parentComponent);
                }
                boolean fullReplacement = syncPeer.renderUpdate(rc, componentUpdates[i], targetId);
                if (!fullReplacement) continue;
                this.disposeReplacedDescendants(rc, componentUpdates[i], parentComponent);
                fullyReplacedHierarchies.add(parentComponent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ServerMessage renderInit(Connection conn, Document clientMessageDocument) {
        ServerMessage serverMessage = new ServerMessage();
        RenderContextImpl rc = new RenderContextImpl(conn, serverMessage);
        ContainerInstance containerInstance = rc.getContainerInstance();
        try {
            serverMessage.addLibrary(WEB_CONTAINER_SERVICE.getId());
            this.processClientMessage(conn, clientMessageDocument);
            if (!containerInstance.isInitialized()) {
                containerInstance.init(conn);
            }
            ApplicationInstance applicationInstance = rc.getContainerInstance().getApplicationInstance();
            ApplicationInstance.setActive((ApplicationInstance)applicationInstance);
            Window window = applicationInstance.getDefaultWindow();
            ServerComponentUpdate componentUpdate = new ServerComponentUpdate((Component)window);
            ComponentSynchronizePeer syncPeer = SynchronizePeerFactory.getPeerForComponent(window.getClass());
            ((WindowPeer)syncPeer).renderRefresh(rc, componentUpdate, (Component)window);
            this.setAsynchronousMonitorInterval(rc);
            this.setFocus(rc, true);
            this.setModalContextRootId(rc);
            this.setRootLayoutDirection(rc);
            this.processQueuedCommands(rc);
            applicationInstance.getUpdateManager().purge();
            ServerMessage serverMessage2 = serverMessage;
            return serverMessage2;
        }
        finally {
            ApplicationInstance.setActive(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ServerMessage renderUpdate(Connection conn, Document clientMessageDocument) {
        ServerMessage serverMessage = new ServerMessage();
        RenderContextImpl rc = new RenderContextImpl(conn, serverMessage);
        ContainerInstance ci = rc.getContainerInstance();
        ApplicationInstance applicationInstance = ci.getApplicationInstance();
        try {
            if (!this.validateTransactionId(ci, clientMessageDocument)) {
                this.processInvalidTransaction(rc);
                ServerMessage serverMessage2 = serverMessage;
                return serverMessage2;
            }
            ApplicationInstance.setActive((ApplicationInstance)applicationInstance);
            UpdateManager updateManager = applicationInstance.getUpdateManager();
            this.processClientFocusedComponent(rc, clientMessageDocument);
            this.processClientMessage(conn, clientMessageDocument);
            updateManager.processClientUpdates();
            this.processServerUpdates(rc);
            this.setAsynchronousMonitorInterval(rc);
            this.setFocus(rc, false);
            this.setModalContextRootId(rc);
            this.processQueuedCommands(rc);
            updateManager.purge();
            ServerMessage serverMessage3 = serverMessage;
            return serverMessage3;
        }
        finally {
            ApplicationInstance.setActive(null);
        }
    }

    private void setAsynchronousMonitorInterval(RenderContext rc) {
        boolean hasTaskQueues = rc.getContainerInstance().getApplicationInstance().hasTaskQueues();
        if (hasTaskQueues) {
            int interval = rc.getContainerInstance().getCallbackInterval();
            rc.getServerMessage().setAsynchronousMonitorInterval(interval);
        } else {
            rc.getServerMessage().setAsynchronousMonitorInterval(-1);
        }
    }

    private void setFocus(RenderContext rc, boolean initial) {
        ComponentSynchronizePeer componentSyncPeer;
        ApplicationInstance applicationInstance = rc.getContainerInstance().getApplicationInstance();
        Component focusedComponent = null;
        if (initial) {
            focusedComponent = applicationInstance.getFocusedComponent();
        } else {
            ServerUpdateManager serverUpdateManager = applicationInstance.getUpdateManager().getServerUpdateManager();
            PropertyUpdate focusUpdate = serverUpdateManager.getApplicationPropertyUpdate("focusedComponent");
            if (focusUpdate != null) {
                focusedComponent = (Component)focusUpdate.getNewValue();
            }
        }
        if (focusedComponent != null && (componentSyncPeer = SynchronizePeerFactory.getPeerForComponent(focusedComponent.getClass())) instanceof FocusSupport) {
            ((FocusSupport)((Object)componentSyncPeer)).renderSetFocus(rc, focusedComponent);
        }
    }

    private void setModalContextRootId(RenderContext rc) {
        ApplicationInstance applicationInstance = rc.getContainerInstance().getApplicationInstance();
        Component modalContextRoot = applicationInstance.getModalContextRoot();
        if (modalContextRoot == null) {
            rc.getServerMessage().setModalContextRootId(null);
        } else {
            rc.getServerMessage().setModalContextRootId(ContainerInstance.getElementId(modalContextRoot));
        }
    }

    private void setRootLayoutDirection(RenderContext rc) {
        ApplicationInstance applicationInstance = rc.getContainerInstance().getApplicationInstance();
        rc.getServerMessage().setRootLayoutDirection(applicationInstance.getLayoutDirection().isLeftToRight() ? 0 : 1);
    }

    private boolean validateTransactionId(ContainerInstance containerInstance, Document clientMessageDocument) {
        try {
            long clientTransactionId = Long.parseLong(clientMessageDocument.getDocumentElement().getAttribute("trans-id"));
            return containerInstance.getCurrentTransactionId() == clientTransactionId;
        }
        catch (NumberFormatException ex) {
            return true;
        }
    }

    static {
        WebRenderServlet.getServiceRegistry().add(WEB_CONTAINER_SERVICE);
        INSTANCE = new ContainerSynchronizeService();
    }
}

