/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo2.webcontainer.image;

import java.io.IOException;
import nextapp.echo2.app.AwtImageReference;
import nextapp.echo2.app.ImageReference;
import nextapp.echo2.webcontainer.image.AbstractImageService;
import nextapp.echo2.webcontainer.image.PngEncoder;
import nextapp.echo2.webrender.Connection;
import nextapp.echo2.webrender.ContentType;
import nextapp.echo2.webrender.Service;
import nextapp.echo2.webrender.WebRenderServlet;

public class AwtImageService
extends AbstractImageService {
    private static final String SERVICE_ID = "Echo.AwtImage";
    public static final AwtImageService INSTANCE = new AwtImageService();

    public String getId() {
        return SERVICE_ID;
    }

    public int getVersion() {
        return 0;
    }

    public void renderImage(Connection conn, ImageReference imageReference) throws IOException {
        try {
            if (!(imageReference instanceof AwtImageReference)) {
                throw new IOException("Image is not an AwtImageReference.");
            }
            PngEncoder encoder = new PngEncoder(((AwtImageReference)imageReference).getImage(), true, null, 3);
            conn.setContentType(ContentType.IMAGE_PNG);
            encoder.encode(conn.getOutputStream());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static {
        WebRenderServlet.getServiceRegistry().add((Service)INSTANCE);
    }
}

