/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo2.webcontainer.syncpeer;

import nextapp.echo2.app.Alignment;
import nextapp.echo2.app.Border;
import nextapp.echo2.app.CheckBox;
import nextapp.echo2.app.Color;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.FillImage;
import nextapp.echo2.app.Font;
import nextapp.echo2.app.ImageReference;
import nextapp.echo2.app.Insets;
import nextapp.echo2.app.RadioButton;
import nextapp.echo2.app.RenderIdSupport;
import nextapp.echo2.app.ResourceImageReference;
import nextapp.echo2.app.button.AbstractButton;
import nextapp.echo2.app.button.ButtonGroup;
import nextapp.echo2.app.button.ToggleButton;
import nextapp.echo2.app.update.ServerComponentUpdate;
import nextapp.echo2.webcontainer.ActionProcessor;
import nextapp.echo2.webcontainer.ComponentSynchronizePeer;
import nextapp.echo2.webcontainer.ContainerInstance;
import nextapp.echo2.webcontainer.DomUpdateSupport;
import nextapp.echo2.webcontainer.PropertyUpdateProcessor;
import nextapp.echo2.webcontainer.RenderContext;
import nextapp.echo2.webcontainer.image.ImageRenderSupport;
import nextapp.echo2.webcontainer.image.ImageTools;
import nextapp.echo2.webcontainer.propertyrender.AlignmentRender;
import nextapp.echo2.webcontainer.propertyrender.BorderRender;
import nextapp.echo2.webcontainer.propertyrender.ColorRender;
import nextapp.echo2.webcontainer.propertyrender.ExtentRender;
import nextapp.echo2.webcontainer.propertyrender.FillImageRender;
import nextapp.echo2.webcontainer.propertyrender.FontRender;
import nextapp.echo2.webcontainer.propertyrender.ImageReferenceRender;
import nextapp.echo2.webcontainer.propertyrender.InsetsRender;
import nextapp.echo2.webcontainer.propertyrender.LayoutDirectionRender;
import nextapp.echo2.webcontainer.syncpeer.TriCellTable;
import nextapp.echo2.webcontainer.syncpeer.TriCellTableConfigurator;
import nextapp.echo2.webrender.ServerMessage;
import nextapp.echo2.webrender.Service;
import nextapp.echo2.webrender.WebRenderServlet;
import nextapp.echo2.webrender.output.CssStyle;
import nextapp.echo2.webrender.servermessage.DomUpdate;
import nextapp.echo2.webrender.service.JavaScriptService;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class ButtonPeer
implements ActionProcessor,
DomUpdateSupport,
ImageRenderSupport,
PropertyUpdateProcessor,
ComponentSynchronizePeer {
    private static final Alignment DEFAULT_TEXT_POSITION = new Alignment(2, 0);
    private static final Alignment DEFAULT_STATE_POSITION = new Alignment(1, 0);
    private static final Extent DEFAULT_ICON_TEXT_MARGIN = new Extent(5);
    private static final ImageReference DEFAULT_CHECKBOX_ICON = new ResourceImageReference("/nextapp/echo2/webcontainer/resource/image/CheckBoxOff.gif");
    private static final ImageReference DEFAULT_SELECTED_CHECKBOX_ICON = new ResourceImageReference("/nextapp/echo2/webcontainer/resource/image/CheckBoxOn.gif");
    private static final ImageReference DEFAULT_RADIOBUTTON_ICON = new ResourceImageReference("/nextapp/echo2/webcontainer/resource/image/RadioButtonOff.gif");
    private static final ImageReference DEFAULT_SELECTED_RADIOBUTTON_ICON = new ResourceImageReference("/nextapp/echo2/webcontainer/resource/image/RadioButtonOn.gif");
    private static final String[] BUTTON_INIT_KEYS = new String[]{"default-style", "rollover-style", "pressed-style"};
    private static final String IMAGE_ID_BACKGROUND = "background";
    private static final String IMAGE_ID_ICON = "icon";
    private static final String IMAGE_ID_ROLLOVER_BACKGROUND = "rolloverBackground";
    private static final String IMAGE_ID_ROLLOVER_ICON = "rolloverIcon";
    private static final String IMAGE_ID_ROLLOVER_STATE_ICON = "rolloverStateIcon";
    private static final String IMAGE_ID_ROLLOVER_SELECTED_STATE_ICON = "rolloverSelectedStateIcon";
    private static final String IMAGE_ID_PRESSED_BACKGROUND = "pressedBackground";
    private static final String IMAGE_ID_PRESSED_ICON = "pressedIcon";
    private static final String IMAGE_ID_PRESSED_STATE_ICON = "pressedStateIcon";
    private static final String IMAGE_ID_PRESSED_SELECTED_STATE_ICON = "pressedSelectedStateIcon";
    private static final String IMAGE_ID_STATE_ICON = "stateIcon";
    private static final String IMAGE_ID_SELECTED_STATE_ICON = "selectedStateIcon";
    private static final String CONTAINER_TABLE_CSS_TEXT_DEFAULT = "border:0px none;border-collapse:collapse;";
    private static final String CONTAINER_TABLE_CSS_TEXT_LEFT = "border:0px none;border-collapse:collapse; margin: 0 auto 0 0";
    private static final String CONTAINER_TABLE_CSS_TEXT_CENTER = "border:0px none;border-collapse:collapse; margin: 0 auto;";
    private static final String CONTAINER_TABLE_CSS_TEXT_RIGHT = "border:0px none;border-collapse:collapse; margin: 0 0 0 auto;";
    private static final Service BUTTON_SERVICE = JavaScriptService.forResource((String)"Echo.Button", (String)"/nextapp/echo2/webcontainer/resource/js/Button.js");

    private static String getContainerTableCssText(AbstractButton button) {
        Alignment alignment = (Alignment)button.getRenderProperty("alignment");
        if (alignment != null) {
            int horizontal = AlignmentRender.getRenderedHorizontal(alignment, (Component)button);
            switch (horizontal) {
                case 3: {
                    return CONTAINER_TABLE_CSS_TEXT_LEFT;
                }
                case 4: {
                    return CONTAINER_TABLE_CSS_TEXT_CENTER;
                }
                case 5: {
                    return CONTAINER_TABLE_CSS_TEXT_RIGHT;
                }
            }
        }
        return CONTAINER_TABLE_CSS_TEXT_DEFAULT;
    }

    public String getContainerId(Component child) {
        throw new UnsupportedOperationException("Component does not support children.");
    }

    private Alignment combineAlignment(Alignment primary, Alignment secondary) {
        if (primary == null) {
            return secondary;
        }
        if (secondary == null) {
            return primary;
        }
        int horizontal = primary.getHorizontal();
        int vertical = primary.getVertical();
        Alignment alignment = new Alignment(horizontal == 0 ? secondary.getHorizontal() : horizontal, vertical == 0 ? secondary.getVertical() : vertical);
        return alignment;
    }

    public ImageReference getImage(Component component, String imageId) {
        if (IMAGE_ID_ICON.equals(imageId)) {
            if (component.isRenderEnabled()) {
                return (ImageReference)component.getRenderProperty(IMAGE_ID_ICON);
            }
            ImageReference icon = (ImageReference)component.getRenderProperty("disabledIcon");
            if (icon == null) {
                icon = (ImageReference)component.getRenderProperty(IMAGE_ID_ICON);
            }
            return icon;
        }
        if (IMAGE_ID_ROLLOVER_ICON.equals(imageId)) {
            return (ImageReference)component.getRenderProperty(IMAGE_ID_ROLLOVER_ICON);
        }
        if (IMAGE_ID_PRESSED_ICON.equals(imageId)) {
            return (ImageReference)component.getRenderProperty(IMAGE_ID_PRESSED_ICON);
        }
        if (IMAGE_ID_STATE_ICON.equals(imageId)) {
            return this.getStateIcon((ToggleButton)component);
        }
        if (IMAGE_ID_SELECTED_STATE_ICON.equals(imageId)) {
            return this.getSelectedStateIcon((ToggleButton)component);
        }
        if (IMAGE_ID_BACKGROUND.equals(imageId)) {
            FillImage backgroundImage;
            if (component.isRenderEnabled()) {
                backgroundImage = (FillImage)component.getRenderProperty("backgroundImage");
            } else {
                backgroundImage = (FillImage)component.getRenderProperty("disabledBackgroundImage");
                if (backgroundImage == null) {
                    backgroundImage = (FillImage)component.getRenderProperty("backgroundImage");
                }
            }
            if (backgroundImage == null) {
                return null;
            }
            return backgroundImage.getImage();
        }
        if (IMAGE_ID_ROLLOVER_BACKGROUND.equals(imageId)) {
            FillImage backgroundImage = (FillImage)component.getRenderProperty("rolloverBackgroundImage");
            if (backgroundImage == null) {
                return null;
            }
            return backgroundImage.getImage();
        }
        if (IMAGE_ID_PRESSED_BACKGROUND.equals(imageId)) {
            FillImage backgroundImage = (FillImage)component.getRenderProperty("pressedBackgroundImage");
            if (backgroundImage == null) {
                return null;
            }
            return backgroundImage.getImage();
        }
        if (IMAGE_ID_ROLLOVER_STATE_ICON.equals(imageId)) {
            ImageReference icon = (ImageReference)component.getRenderProperty(IMAGE_ID_ROLLOVER_STATE_ICON);
            return icon == null ? this.getStateIcon((ToggleButton)component) : icon;
        }
        if (IMAGE_ID_ROLLOVER_SELECTED_STATE_ICON.equals(imageId)) {
            ImageReference icon = (ImageReference)component.getRenderProperty(IMAGE_ID_ROLLOVER_SELECTED_STATE_ICON);
            return icon == null ? this.getSelectedStateIcon((ToggleButton)component) : icon;
        }
        if (IMAGE_ID_PRESSED_STATE_ICON.equals(imageId)) {
            ImageReference icon = (ImageReference)component.getRenderProperty(IMAGE_ID_PRESSED_STATE_ICON);
            return icon == null ? this.getStateIcon((ToggleButton)component) : icon;
        }
        if (IMAGE_ID_PRESSED_SELECTED_STATE_ICON.equals(imageId)) {
            ImageReference icon = (ImageReference)component.getRenderProperty(IMAGE_ID_PRESSED_SELECTED_STATE_ICON);
            return icon == null ? this.getSelectedStateIcon((ToggleButton)component) : icon;
        }
        return null;
    }

    private ImageReference getSelectedStateIcon(ToggleButton toggleButton) {
        ImageReference selectedStateIcon = (ImageReference)toggleButton.getRenderProperty(IMAGE_ID_SELECTED_STATE_ICON);
        if (selectedStateIcon == null) {
            if (toggleButton instanceof CheckBox) {
                selectedStateIcon = DEFAULT_SELECTED_CHECKBOX_ICON;
            } else if (toggleButton instanceof RadioButton) {
                selectedStateIcon = DEFAULT_SELECTED_RADIOBUTTON_ICON;
            }
        }
        return selectedStateIcon;
    }

    private ImageReference getStateIcon(ToggleButton toggleButton) {
        ImageReference stateIcon = (ImageReference)toggleButton.getRenderProperty(IMAGE_ID_STATE_ICON);
        if (stateIcon == null) {
            if (toggleButton instanceof CheckBox) {
                stateIcon = DEFAULT_CHECKBOX_ICON;
            } else if (toggleButton instanceof RadioButton) {
                stateIcon = DEFAULT_RADIOBUTTON_ICON;
            }
        }
        return stateIcon;
    }

    public void processAction(ContainerInstance ci, Component component, Element actionElement) {
        ci.getUpdateManager().getClientUpdateManager().setComponentAction(component, "input_click", null);
    }

    public void processPropertyUpdate(ContainerInstance ci, Component component, Element propertyElement) {
        String propertyName = propertyElement.getAttribute("name");
        if ("selected".equals(propertyName)) {
            Boolean propertyValue = new Boolean("true".equals(propertyElement.getAttribute("value")));
            ci.getUpdateManager().getClientUpdateManager().setComponentProperty(component, "selected", (Object)propertyValue);
        }
    }

    public void renderAdd(RenderContext rc, ServerComponentUpdate update, String targetId, Component component) {
        Element domAddElement = DomUpdate.renderElementAdd((ServerMessage)rc.getServerMessage());
        DocumentFragment htmlFragment = rc.getServerMessage().getDocument().createDocumentFragment();
        this.renderHtml(rc, update, htmlFragment, component);
        DomUpdate.renderElementAddContent((ServerMessage)rc.getServerMessage(), (Element)domAddElement, (String)targetId, (DocumentFragment)htmlFragment);
    }

    private Element renderButtonContainer(RenderContext rc, Node parentNode, AbstractButton button) {
        Element divElement = parentNode.getOwnerDocument().createElement("div");
        divElement.setAttribute("id", ContainerInstance.getElementId((Component)button));
        if (button.isFocusTraversalParticipant()) {
            divElement.setAttribute("tabindex", Integer.toString(button.getFocusTraversalIndex()));
        } else {
            divElement.setAttribute("tabindex", "-1");
        }
        boolean renderEnabled = button.isRenderEnabled();
        String toolTipText = (String)button.getRenderProperty("toolTipText");
        if (renderEnabled && toolTipText != null) {
            divElement.setAttribute("title", toolTipText);
        }
        divElement.setAttribute("style", "visibility:hidden;");
        parentNode.appendChild(divElement);
        return divElement;
    }

    private void renderButtonContent(RenderContext rc, Element buttonContainerElement, AbstractButton button) {
        Node contentNode;
        Element stateIconElement;
        Element iconElement;
        Text textNode;
        Document document = rc.getServerMessage().getDocument();
        ToggleButton toggleButton = button instanceof ToggleButton ? (ToggleButton)button : null;
        String elementId = ContainerInstance.getElementId((Component)button);
        String text = (String)button.getRenderProperty("text");
        ImageReference icon = (ImageReference)button.getRenderProperty(IMAGE_ID_ICON);
        Text text2 = textNode = text == null ? null : rc.getServerMessage().getDocument().createTextNode((String)button.getRenderProperty("text"));
        if (icon == null) {
            iconElement = null;
        } else {
            iconElement = ImageReferenceRender.renderImageReferenceElement(rc, this, (Component)button, IMAGE_ID_ICON);
            iconElement.setAttribute("id", elementId + "_icon");
        }
        if (toggleButton == null) {
            stateIconElement = null;
        } else {
            stateIconElement = ImageReferenceRender.renderImageReferenceElement(rc, this, (Component)button, toggleButton.isSelected() ? IMAGE_ID_SELECTED_STATE_ICON : IMAGE_ID_STATE_ICON);
            stateIconElement.setAttribute("id", elementId + "_stateicon");
        }
        int entityCount = (textNode == null ? 0 : 1) + (iconElement == null ? 0 : 1) + (stateIconElement == null ? 0 : 1);
        switch (entityCount) {
            case 1: {
                if (textNode != null) {
                    contentNode = textNode;
                    break;
                }
                if (iconElement != null) {
                    contentNode = iconElement;
                    break;
                }
                contentNode = stateIconElement;
                break;
            }
            case 2: {
                TriCellTable tct;
                Extent iconTextMargin = (Extent)button.getRenderProperty("iconTextMargin", (Object)DEFAULT_ICON_TEXT_MARGIN);
                Alignment textPosition = (Alignment)button.getRenderProperty("textPosition", (Object)DEFAULT_TEXT_POSITION);
                if (stateIconElement == null) {
                    int orientation = TriCellTableConfigurator.convertIconTextPositionToOrientation(textPosition, (Component)button);
                    tct = new TriCellTable(rc, document, elementId, orientation, iconTextMargin);
                    this.renderCellText(tct, textNode, button);
                    this.renderCellIcon(tct, iconElement, 1, button);
                } else {
                    Extent stateMargin = (Extent)button.getRenderProperty("stateMargin", (Object)DEFAULT_ICON_TEXT_MARGIN);
                    Alignment statePosition = (Alignment)button.getRenderProperty("statePosition", (Object)DEFAULT_STATE_POSITION);
                    int orientation = TriCellTableConfigurator.convertStatePositionToOrientation(statePosition, (Component)button);
                    tct = new TriCellTable(rc, document, elementId, orientation, stateMargin);
                    if (textNode == null) {
                        this.renderCellIcon(tct, iconElement, 0, button);
                    } else {
                        this.renderCellText(tct, textNode, button);
                    }
                    this.renderCellState(tct, stateIconElement, 1, button);
                }
                tct.addCellCssText("padding:0px;");
                Element tableElement = tct.getTableElement();
                tableElement.setAttribute("id", elementId + "_table");
                tableElement.setAttribute("style", ButtonPeer.getContainerTableCssText(button));
                contentNode = tableElement;
                break;
            }
            case 3: {
                Extent iconTextMargin = (Extent)button.getRenderProperty("iconTextMargin", (Object)DEFAULT_ICON_TEXT_MARGIN);
                Alignment textPosition = (Alignment)button.getRenderProperty("textPosition", (Object)DEFAULT_TEXT_POSITION);
                Extent stateMargin = (Extent)button.getRenderProperty("stateMargin", (Object)DEFAULT_ICON_TEXT_MARGIN);
                Alignment statePosition = (Alignment)button.getRenderProperty("statePosition", (Object)DEFAULT_STATE_POSITION);
                int stateOrientation = TriCellTableConfigurator.convertStatePositionToOrientation(statePosition, (Component)button);
                int orientation = TriCellTableConfigurator.convertIconTextPositionToOrientation(textPosition, (Component)button);
                TriCellTable tct = new TriCellTable(rc, document, elementId, orientation, iconTextMargin, stateOrientation, stateMargin);
                this.renderCellText(tct, textNode, button);
                this.renderCellIcon(tct, iconElement, 1, button);
                this.renderCellState(tct, stateIconElement, 2, button);
                tct.addCellCssText("padding:0px;");
                Element tableElement = tct.getTableElement();
                tableElement.setAttribute("id", elementId + "_table");
                tableElement.setAttribute("style", ButtonPeer.getContainerTableCssText(button));
                contentNode = tableElement;
                break;
            }
            default: {
                contentNode = null;
            }
        }
        if (contentNode != null) {
            buttonContainerElement.appendChild(contentNode);
        }
    }

    private void renderCellIcon(TriCellTable tct, Element iconElement, int cellIndex, AbstractButton button) {
        Element iconTdElement = tct.getTdElement(cellIndex);
        Alignment alignment = (Alignment)button.getRenderProperty("alignment");
        if (alignment != null) {
            CssStyle style = new CssStyle();
            AlignmentRender.renderToStyle(style, alignment, (Component)button);
            iconTdElement.setAttribute("style", style.renderInline());
        }
        iconTdElement.appendChild(iconElement);
    }

    private void renderCellState(TriCellTable tct, Element stateIconElement, int cellIndex, AbstractButton button) {
        Element stateTdElement = tct.getTdElement(cellIndex);
        CssStyle stateTdCssStyle = new CssStyle();
        AlignmentRender.renderToStyle(stateTdCssStyle, (Alignment)button.getRenderProperty("stateAlignment"), (Component)button);
        stateTdElement.setAttribute("style", stateTdCssStyle.renderInline());
        stateTdElement.appendChild(stateIconElement);
    }

    private void renderCellText(TriCellTable tct, Text textNode, AbstractButton button) {
        Font font;
        Element textTdElement = tct.getTdElement(0);
        CssStyle textTdCssStyle = new CssStyle();
        if (Boolean.FALSE.equals(button.getRenderProperty("lineWrap"))) {
            textTdCssStyle.setAttribute("white-space", "nowrap");
        }
        Alignment alignment = this.combineAlignment((Alignment)button.getRenderProperty("textAlignment"), (Alignment)button.getRenderProperty("alignment"));
        AlignmentRender.renderToStyle(textTdCssStyle, alignment, (Component)button);
        boolean renderEnabled = button.isRenderEnabled();
        if (renderEnabled) {
            font = (Font)button.getRenderProperty("font");
        } else {
            font = (Font)button.getRenderProperty("disabledFont");
            if (font == null) {
                font = (Font)button.getRenderProperty("font");
            }
        }
        FontRender.renderToStyle(textTdCssStyle, font);
        if (textTdCssStyle.hasAttributes()) {
            textTdElement.setAttribute("style", textTdCssStyle.renderInline());
        }
        textTdElement.appendChild(textNode);
    }

    private CssStyle renderDefaultStyle(RenderContext rc, AbstractButton button) {
        Color foreground;
        Border border;
        FillImage backgroundImage;
        Color background;
        int entityCount = (button.getRenderProperty("text") == null ? 1 : 0) + (button.getRenderProperty(IMAGE_ID_ICON) == null ? 1 : 0) + (button instanceof ToggleButton ? 1 : 0);
        CssStyle cssStyle = new CssStyle();
        LayoutDirectionRender.renderToStyle(cssStyle, button.getLayoutDirection(), button.getLocale());
        ExtentRender.renderToStyle(cssStyle, "width", (Extent)button.getRenderProperty("width"));
        Extent height = (Extent)button.getRenderProperty("height");
        if (height != null) {
            ExtentRender.renderToStyle(cssStyle, "height", height);
            cssStyle.setAttribute("overflow", "hidden");
        }
        if (Boolean.FALSE.equals(button.getRenderProperty("lineWrap"))) {
            cssStyle.setAttribute("white-space", "nowrap");
        }
        boolean renderEnabled = button.isRenderEnabled();
        Font font = null;
        if (!renderEnabled) {
            background = (Color)button.getRenderProperty("disabledBackground");
            backgroundImage = (FillImage)button.getRenderProperty("disabledBackgroundImage");
            border = (Border)button.getRenderProperty("disabledBorder");
            foreground = (Color)button.getRenderProperty("disabledForeground");
            if (background == null) {
                background = (Color)button.getRenderProperty(IMAGE_ID_BACKGROUND);
                if (backgroundImage == null) {
                    backgroundImage = (FillImage)button.getRenderProperty("backgroundImage");
                }
            }
            if (border == null) {
                border = (Border)button.getRenderProperty("border");
            }
            if (foreground == null) {
                foreground = (Color)button.getRenderProperty("foreground");
            }
            if (entityCount == 1 && (font = (Font)button.getRenderProperty("disabledFont")) == null) {
                font = (Font)button.getRenderProperty("font");
            }
        } else {
            border = (Border)button.getRenderProperty("border");
            foreground = (Color)button.getRenderProperty("foreground");
            background = (Color)button.getRenderProperty(IMAGE_ID_BACKGROUND);
            backgroundImage = (FillImage)button.getRenderProperty("backgroundImage");
            if (entityCount == 1) {
                font = (Font)button.getRenderProperty("font");
            }
        }
        BorderRender.renderToStyle(cssStyle, border);
        ColorRender.renderToStyle(cssStyle, foreground, background);
        FillImageRender.renderToStyle(cssStyle, rc, this, (Component)button, IMAGE_ID_BACKGROUND, backgroundImage, 1);
        if (entityCount == 1) {
            FontRender.renderToStyle(cssStyle, font);
        }
        InsetsRender.renderToStyle(cssStyle, "padding", (Insets)button.getRenderProperty("insets"));
        AlignmentRender.renderToStyle(cssStyle, (Alignment)button.getRenderProperty("alignment"), (Component)button);
        return cssStyle;
    }

    public void renderDispose(RenderContext rc, ServerComponentUpdate update, Component component) {
        rc.getServerMessage().addLibrary(BUTTON_SERVICE.getId());
        this.renderDisposeDirective(rc, (AbstractButton)component);
    }

    private void renderDisposeDirective(RenderContext rc, AbstractButton button) {
        ServerMessage serverMessage = rc.getServerMessage();
        Element itemizedUpdateElement = serverMessage.getItemizedDirective("preremove", "EchoButton.MessageProcessor", "dispose", new String[0], new String[0]);
        Element itemElement = serverMessage.getDocument().createElement("item");
        itemElement.setAttribute("eid", ContainerInstance.getElementId((Component)button));
        itemizedUpdateElement.appendChild(itemElement);
    }

    public void renderHtml(RenderContext rc, ServerComponentUpdate update, Node parentNode, Component component) {
        ServerMessage serverMessage = rc.getServerMessage();
        serverMessage.addLibrary(BUTTON_SERVICE.getId());
        AbstractButton button = (AbstractButton)component;
        Element containerDivElement = this.renderButtonContainer(rc, parentNode, button);
        this.renderInitDirective(rc, button);
        this.renderButtonContent(rc, containerDivElement, button);
    }

    private void renderInitDirective(RenderContext rc, AbstractButton button) {
        String elementId = ContainerInstance.getElementId((Component)button);
        ServerMessage serverMessage = rc.getServerMessage();
        FillImage backgroundImage = (FillImage)button.getRenderProperty("backgroundImage");
        boolean rolloverEnabled = (Boolean)button.getRenderProperty("rolloverEnabled", (Object)Boolean.FALSE);
        boolean pressedEnabled = (Boolean)button.getRenderProperty("pressedEnabled", (Object)Boolean.FALSE);
        String pressedStyle = "";
        String rolloverStyle = "";
        String defaultIconUri = null;
        String rolloverIconUri = null;
        String pressedIconUri = null;
        if (rolloverEnabled || pressedEnabled) {
            boolean hasIcon;
            boolean bl = hasIcon = button.getRenderProperty(IMAGE_ID_ICON) != null;
            if (hasIcon) {
                defaultIconUri = ImageTools.getUri(rc, this, (Component)button, IMAGE_ID_ICON);
            }
            if (rolloverEnabled) {
                ImageReference rolloverIcon;
                CssStyle rolloverCssStyle = new CssStyle();
                BorderRender.renderToStyle(rolloverCssStyle, (Border)button.getRenderProperty("rolloverBorder"));
                ColorRender.renderToStyle(rolloverCssStyle, (Color)button.getRenderProperty("rolloverForeground"), (Color)button.getRenderProperty(IMAGE_ID_ROLLOVER_BACKGROUND));
                FontRender.renderToStyle(rolloverCssStyle, (Font)button.getRenderProperty("rolloverFont"));
                if (backgroundImage != null) {
                    FillImageRender.renderToStyle(rolloverCssStyle, rc, this, (Component)button, IMAGE_ID_ROLLOVER_BACKGROUND, (FillImage)button.getRenderProperty("rolloverBackgroundImage"), 1);
                }
                if (rolloverCssStyle.hasAttributes()) {
                    rolloverStyle = rolloverCssStyle.renderInline();
                }
                if (hasIcon && (rolloverIcon = (ImageReference)button.getRenderProperty(IMAGE_ID_ROLLOVER_ICON)) != null) {
                    rolloverIconUri = ImageTools.getUri(rc, this, (Component)button, IMAGE_ID_ROLLOVER_ICON);
                }
            }
            if (pressedEnabled) {
                ImageReference pressedIcon;
                CssStyle pressedCssStyle = new CssStyle();
                BorderRender.renderToStyle(pressedCssStyle, (Border)button.getRenderProperty("pressedBorder"));
                ColorRender.renderToStyle(pressedCssStyle, (Color)button.getRenderProperty("pressedForeground"), (Color)button.getRenderProperty(IMAGE_ID_PRESSED_BACKGROUND));
                FontRender.renderToStyle(pressedCssStyle, (Font)button.getRenderProperty("pressedFont"));
                if (backgroundImage != null) {
                    FillImageRender.renderToStyle(pressedCssStyle, rc, this, (Component)button, IMAGE_ID_PRESSED_BACKGROUND, (FillImage)button.getRenderProperty("pressedBackgroundImage"), 1);
                }
                if (pressedCssStyle.hasAttributes()) {
                    pressedStyle = pressedCssStyle.renderInline();
                }
                if (hasIcon && (pressedIcon = (ImageReference)button.getRenderProperty(IMAGE_ID_PRESSED_ICON)) != null) {
                    pressedIconUri = ImageTools.getUri(rc, this, (Component)button, IMAGE_ID_PRESSED_ICON);
                }
            }
        }
        CssStyle defaultCssStyle = this.renderDefaultStyle(rc, button);
        String defaultStyle = defaultCssStyle.renderInline();
        Element itemizedUpdateElement = serverMessage.getItemizedDirective("postupdate", "EchoButton.MessageProcessor", "init", BUTTON_INIT_KEYS, new String[]{defaultStyle, rolloverStyle, pressedStyle});
        Element itemElement = serverMessage.getDocument().createElement("item");
        itemElement.setAttribute("eid", elementId);
        if (defaultIconUri != null) {
            itemElement.setAttribute("default-icon", defaultIconUri);
        }
        if (rolloverIconUri != null) {
            itemElement.setAttribute("rollover-icon", rolloverIconUri);
        }
        if (pressedIconUri != null) {
            itemElement.setAttribute("pressed-icon", pressedIconUri);
        }
        if (!button.hasActionListeners()) {
            itemElement.setAttribute("server-notify", "false");
        }
        if (!button.isRenderEnabled()) {
            itemElement.setAttribute("enabled", "false");
        }
        if (button instanceof ToggleButton) {
            ButtonGroup buttonGroup;
            ToggleButton toggleButton = (ToggleButton)button;
            itemElement.setAttribute("toggle", "true");
            itemElement.setAttribute("selected", toggleButton.isSelected() ? "true" : "false");
            itemElement.setAttribute("state-icon", ImageTools.getUri(rc, this, (Component)toggleButton, IMAGE_ID_STATE_ICON));
            itemElement.setAttribute("selected-state-icon", ImageTools.getUri(rc, this, (Component)toggleButton, IMAGE_ID_SELECTED_STATE_ICON));
            if (rolloverEnabled && toggleButton.getRenderProperty(IMAGE_ID_ROLLOVER_STATE_ICON) != null && toggleButton.getRenderProperty(IMAGE_ID_ROLLOVER_SELECTED_STATE_ICON) != null) {
                itemElement.setAttribute("rollover-state-icon", ImageTools.getUri(rc, this, (Component)toggleButton, IMAGE_ID_ROLLOVER_STATE_ICON));
                itemElement.setAttribute("rollover-selected-state-icon", ImageTools.getUri(rc, this, (Component)toggleButton, IMAGE_ID_ROLLOVER_SELECTED_STATE_ICON));
            }
            if (pressedEnabled && toggleButton.getRenderProperty(IMAGE_ID_PRESSED_STATE_ICON) != null && toggleButton.getRenderProperty(IMAGE_ID_PRESSED_SELECTED_STATE_ICON) != null) {
                itemElement.setAttribute("pressed-state-icon", ImageTools.getUri(rc, this, (Component)toggleButton, IMAGE_ID_PRESSED_STATE_ICON));
                itemElement.setAttribute("pressed-selected-state-icon", ImageTools.getUri(rc, this, (Component)toggleButton, IMAGE_ID_PRESSED_SELECTED_STATE_ICON));
            }
            if (button instanceof RadioButton && (buttonGroup = ((RadioButton)toggleButton).getGroup()) != null) {
                rc.getContainerInstance().getIdTable().register((RenderIdSupport)buttonGroup);
                itemElement.setAttribute("group", buttonGroup.getRenderId());
            }
        }
        itemizedUpdateElement.appendChild(itemElement);
    }

    public boolean renderUpdate(RenderContext rc, ServerComponentUpdate update, String targetId) {
        String parentId = ContainerInstance.getElementId(update.getParent());
        DomUpdate.renderElementRemove((ServerMessage)rc.getServerMessage(), (String)parentId);
        this.renderAdd(rc, update, targetId, update.getParent());
        return false;
    }

    static {
        WebRenderServlet.getServiceRegistry().add(BUTTON_SERVICE);
    }
}

