/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo2.webcontainer.syncpeer;

import java.util.HashSet;
import nextapp.echo2.app.Border;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.Grid;
import nextapp.echo2.app.ImageReference;
import nextapp.echo2.app.Insets;
import nextapp.echo2.app.LayoutData;
import nextapp.echo2.app.layout.CellLayoutData;
import nextapp.echo2.app.layout.GridLayoutData;
import nextapp.echo2.app.update.ServerComponentUpdate;
import nextapp.echo2.webcontainer.ComponentSynchronizePeer;
import nextapp.echo2.webcontainer.ContainerInstance;
import nextapp.echo2.webcontainer.DomUpdateSupport;
import nextapp.echo2.webcontainer.RenderContext;
import nextapp.echo2.webcontainer.SynchronizePeerFactory;
import nextapp.echo2.webcontainer.image.ImageRenderSupport;
import nextapp.echo2.webcontainer.propertyrender.BorderRender;
import nextapp.echo2.webcontainer.propertyrender.CellLayoutDataRender;
import nextapp.echo2.webcontainer.propertyrender.ColorRender;
import nextapp.echo2.webcontainer.propertyrender.ExtentRender;
import nextapp.echo2.webcontainer.propertyrender.FontRender;
import nextapp.echo2.webcontainer.propertyrender.InsetsRender;
import nextapp.echo2.webcontainer.syncpeer.GridProcessor;
import nextapp.echo2.webrender.ServerMessage;
import nextapp.echo2.webrender.output.CssStyle;
import nextapp.echo2.webrender.servermessage.DomUpdate;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class GridPeer
implements ComponentSynchronizePeer,
DomUpdateSupport,
ImageRenderSupport {
    private static final String SIZING_DOTS = ". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . ";

    public String getContainerId(Component child) {
        return ContainerInstance.getElementId(child.getParent()) + "_td_" + ContainerInstance.getElementId(child);
    }

    public ImageReference getImage(Component component, String imageId) {
        return CellLayoutDataRender.getCellLayoutDataBackgroundImage(component, imageId);
    }

    private GridLayoutData getLayoutData(Component child) {
        LayoutData layoutData = (LayoutData)child.getRenderProperty("layoutData");
        if (layoutData == null) {
            return null;
        }
        if (layoutData instanceof GridLayoutData) {
            return (GridLayoutData)layoutData;
        }
        throw new RuntimeException("Invalid LayoutData for Grid Child: " + layoutData.getClass().getName());
    }

    public void renderAdd(RenderContext rc, ServerComponentUpdate update, String targetId, Component component) {
        Element domAddElement = DomUpdate.renderElementAdd((ServerMessage)rc.getServerMessage());
        DocumentFragment htmlFragment = rc.getServerMessage().getDocument().createDocumentFragment();
        this.renderHtml(rc, update, htmlFragment, component);
        DomUpdate.renderElementAddContent((ServerMessage)rc.getServerMessage(), (Element)domAddElement, (String)targetId, (DocumentFragment)htmlFragment);
    }

    private void renderAddChild(RenderContext rc, ServerComponentUpdate update, Element parentElement, Component child) {
        ComponentSynchronizePeer syncPeer = SynchronizePeerFactory.getPeerForComponent(child.getClass());
        if (syncPeer instanceof DomUpdateSupport) {
            ((DomUpdateSupport)((Object)syncPeer)).renderHtml(rc, update, parentElement, child);
        } else {
            syncPeer.renderAdd(rc, update, this.getContainerId(child), child);
        }
    }

    public void renderDispose(RenderContext rc, ServerComponentUpdate update, Component component) {
    }

    public void renderHtml(RenderContext rc, ServerComponentUpdate update, Node parentNode, Component component) {
        Extent borderSize;
        Document document = parentNode.getOwnerDocument();
        Grid grid = (Grid)component;
        Border border = (Border)grid.getRenderProperty("border");
        String elementId = ContainerInstance.getElementId((Component)grid);
        GridProcessor gridProcessor = new GridProcessor(grid);
        int columnCount = gridProcessor.getColumnCount();
        int rowCount = gridProcessor.getRowCount();
        Element tableElement = document.createElement("table");
        tableElement.setAttribute("id", elementId);
        CssStyle tableCssStyle = new CssStyle();
        tableCssStyle.setAttribute("border-collapse", "collapse");
        Insets gridInsets = (Insets)grid.getRenderProperty("insets");
        String defaultInsetsAttributeValue = gridInsets == null ? "0px" : InsetsRender.renderCssAttributeValue(gridInsets);
        ColorRender.renderToStyle(tableCssStyle, component);
        FontRender.renderToStyle(tableCssStyle, component);
        BorderRender.renderToStyle(tableCssStyle, border);
        ExtentRender.renderToStyle(tableCssStyle, "height", (Extent)grid.getRenderProperty("height"));
        Extent width = (Extent)grid.getRenderProperty("width");
        boolean render100PercentWidthWorkaround = false;
        if (rc.getContainerInstance().getClientProperties().getBoolean("quirkIETablePercentWidthScrollbarError") && width != null && width.getUnits() == 2 && width.getValue() == 100) {
            width = null;
            render100PercentWidthWorkaround = true;
        }
        ExtentRender.renderToStyle(tableCssStyle, "width", width);
        Extent extent = borderSize = border == null ? null : border.getSize();
        if (borderSize != null && !rc.getContainerInstance().getClientProperties().getBoolean("quirkCssBorderCollapseInside")) {
            tableCssStyle.setAttribute("margin", ExtentRender.renderCssAttributeValueHalf(borderSize));
        }
        tableElement.setAttribute("style", tableCssStyle.renderInline());
        parentNode.appendChild(tableElement);
        boolean someColumnsHaveWidths = false;
        for (int i = 0; i < columnCount; ++i) {
            if (gridProcessor.getColumnWidth(i) == null) continue;
            someColumnsHaveWidths = true;
        }
        if (someColumnsHaveWidths) {
            Element colGroupElement = document.createElement("colgroup");
            tableElement.appendChild(colGroupElement);
            for (int i = 0; i < columnCount; ++i) {
                Element colElement = document.createElement("col");
                Extent columnWidth = gridProcessor.getColumnWidth(i);
                if (columnWidth != null) {
                    colElement.setAttribute("style", "width:" + ExtentRender.renderCssAttributeValue(columnWidth));
                }
                colGroupElement.appendChild(colElement);
            }
        }
        Element tbodyElement = document.createElement("tbody");
        tbodyElement.setAttribute("id", elementId + "_tbody");
        tableElement.appendChild(tbodyElement);
        HashSet<Component> renderedCells = new HashSet<Component>();
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            Element trElement = document.createElement("tr");
            trElement.setAttribute("id", elementId + "_tr_" + rowIndex);
            if (gridProcessor.getRowHeight(rowIndex) != null) {
                trElement.setAttribute("style", "height:" + ExtentRender.renderCssAttributeValue(gridProcessor.getRowHeight(rowIndex)));
            }
            tbodyElement.appendChild(trElement);
            for (int columnIndex = 0; columnIndex < columnCount; ++columnIndex) {
                int rowSpan;
                Element tdElement;
                Component cell = gridProcessor.getContent(columnIndex, rowIndex);
                if (cell == null) {
                    tdElement = document.createElement("td");
                    trElement.appendChild(tdElement);
                    continue;
                }
                if (renderedCells.contains(cell)) continue;
                renderedCells.add(cell);
                tdElement = document.createElement("td");
                tdElement.setAttribute("id", elementId + "_td_" + ContainerInstance.getElementId(cell));
                trElement.appendChild(tdElement);
                int columnSpan = gridProcessor.getColumnSpan(columnIndex, rowIndex);
                if (columnSpan > 1) {
                    tdElement.setAttribute("colspan", Integer.toString(columnSpan));
                }
                if ((rowSpan = gridProcessor.getRowSpan(columnIndex, rowIndex)) > 1) {
                    tdElement.setAttribute("rowspan", Integer.toString(rowSpan));
                }
                CssStyle tdCssStyle = new CssStyle();
                BorderRender.renderToStyle(tdCssStyle, (Border)grid.getRenderProperty("border"));
                CellLayoutDataRender.renderToElementAndStyle(tdElement, tdCssStyle, cell, (CellLayoutData)this.getLayoutData(cell), defaultInsetsAttributeValue);
                CellLayoutDataRender.renderBackgroundImageToStyle(tdCssStyle, rc, this, (Component)grid, cell);
                tdElement.setAttribute("style", tdCssStyle.renderInline());
                if (rowIndex == 0 && render100PercentWidthWorkaround) {
                    Element sizingDivElement = document.createElement("div");
                    sizingDivElement.setAttribute("style", "font-size:50px;height:0px;overflow:hidden;");
                    sizingDivElement.appendChild(document.createTextNode(SIZING_DOTS));
                    tdElement.appendChild(sizingDivElement);
                }
                this.renderAddChild(rc, update, tdElement, cell);
            }
        }
    }

    public boolean renderUpdate(RenderContext rc, ServerComponentUpdate update, String targetId) {
        String parentId = ContainerInstance.getElementId(update.getParent());
        DomUpdate.renderElementRemove((ServerMessage)rc.getServerMessage(), (String)parentId);
        this.renderAdd(rc, update, targetId, update.getParent());
        return true;
    }
}

