/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo2.webcontainer.syncpeer;

import nextapp.echo2.app.Color;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.FillImage;
import nextapp.echo2.app.Font;
import nextapp.echo2.app.ImageReference;
import nextapp.echo2.app.LayoutData;
import nextapp.echo2.app.LayoutDirection;
import nextapp.echo2.app.Pane;
import nextapp.echo2.app.SplitPane;
import nextapp.echo2.app.layout.SplitPaneLayoutData;
import nextapp.echo2.app.update.ServerComponentUpdate;
import nextapp.echo2.webcontainer.ComponentSynchronizePeer;
import nextapp.echo2.webcontainer.ContainerInstance;
import nextapp.echo2.webcontainer.PartialUpdateManager;
import nextapp.echo2.webcontainer.PartialUpdateParticipant;
import nextapp.echo2.webcontainer.PropertyUpdateProcessor;
import nextapp.echo2.webcontainer.RenderContext;
import nextapp.echo2.webcontainer.RenderState;
import nextapp.echo2.webcontainer.SynchronizePeerFactory;
import nextapp.echo2.webcontainer.image.ImageRenderSupport;
import nextapp.echo2.webcontainer.propertyrender.AlignmentRender;
import nextapp.echo2.webcontainer.propertyrender.ColorRender;
import nextapp.echo2.webcontainer.propertyrender.ExtentRender;
import nextapp.echo2.webcontainer.propertyrender.FillImageRender;
import nextapp.echo2.webcontainer.propertyrender.FontRender;
import nextapp.echo2.webcontainer.propertyrender.InsetsRender;
import nextapp.echo2.webrender.ServerMessage;
import nextapp.echo2.webrender.Service;
import nextapp.echo2.webrender.WebRenderServlet;
import nextapp.echo2.webrender.output.CssStyle;
import nextapp.echo2.webrender.servermessage.DomUpdate;
import nextapp.echo2.webrender.service.JavaScriptService;
import org.w3c.dom.Element;

public class SplitPanePeer
implements ImageRenderSupport,
PropertyUpdateProcessor,
ComponentSynchronizePeer {
    private static final String IMAGE_ID_HORIZONTAL_SEPARATOR = "horizontalSeparator";
    private static final String IMAGE_ID_PANE_0_BACKGROUND = "pane0Background";
    private static final String IMAGE_ID_PANE_1_BACKGROUND = "pane1Background";
    private static final String IMAGE_ID_VERTICAL_SEPARATOR = "verticalSeparator";
    private static final Extent DEFAULT_SEPARATOR_POSITION = new Extent(100);
    private static final Service SPLIT_PANE_SERVICE = JavaScriptService.forResource((String)"Echo.SplitPane", (String)"/nextapp/echo2/webcontainer/resource/js/SplitPane.js");
    private PartialUpdateParticipant separatorPositionUpdate = new PartialUpdateParticipant(){

        public void renderProperty(RenderContext rc, ServerComponentUpdate update) {
            SplitPane splitPane = (SplitPane)update.getParent();
            SplitPanePeer.this.renderSetSeparatorPositionDirective(rc, splitPane);
        }

        public boolean canRenderProperty(RenderContext rc, ServerComponentUpdate update) {
            return true;
        }
    };
    private PartialUpdateManager partialUpdateManager = new PartialUpdateManager();

    private static final boolean equal(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    public SplitPanePeer() {
        this.partialUpdateManager.add("separatorPosition", this.separatorPositionUpdate);
    }

    private int calculateSeparatorSize(SplitPane splitPane) {
        Boolean booleanValue = (Boolean)splitPane.getRenderProperty("resizable");
        boolean resizable = booleanValue == null ? false : booleanValue;
        boolean verticalOrientation = this.isOrientationVertical(splitPane);
        if (resizable) {
            return ExtentRender.toPixels((Extent)splitPane.getRenderProperty(verticalOrientation ? "separatorHeight" : "separatorWidth"), 4);
        }
        return ExtentRender.toPixels((Extent)splitPane.getRenderProperty(verticalOrientation ? "separatorHeight" : "separatorWidth"), 0);
    }

    public String getContainerId(Component child) {
        return ContainerInstance.getElementId(child.getParent()) + "_pane" + child.getParent().visibleIndexOf(child);
    }

    public ImageReference getImage(Component component, String imageId) {
        if (IMAGE_ID_PANE_0_BACKGROUND.equals(imageId)) {
            return this.getPaneBackgroundImage(component.getVisibleComponent(0));
        }
        if (IMAGE_ID_PANE_1_BACKGROUND.equals(imageId)) {
            return this.getPaneBackgroundImage(component.getVisibleComponent(1));
        }
        if (IMAGE_ID_HORIZONTAL_SEPARATOR.equals(imageId)) {
            FillImage fillImage = (FillImage)component.getRenderProperty("separatorHorizontalImage");
            return fillImage == null ? null : fillImage.getImage();
        }
        if (IMAGE_ID_VERTICAL_SEPARATOR.equals(imageId)) {
            FillImage fillImage = (FillImage)component.getRenderProperty("separatorVerticalImage");
            return fillImage == null ? null : fillImage.getImage();
        }
        return null;
    }

    private ImageReference getPaneBackgroundImage(Component component) {
        LayoutData layoutData = (LayoutData)component.getRenderProperty("layoutData");
        if (!(layoutData instanceof SplitPaneLayoutData)) {
            return null;
        }
        FillImage backgroundImage = ((SplitPaneLayoutData)layoutData).getBackgroundImage();
        if (backgroundImage == null) {
            return null;
        }
        return backgroundImage.getImage();
    }

    private int getRenderOrientation(SplitPane splitPane) {
        int orientation;
        Integer orientationValue = (Integer)splitPane.getRenderProperty("orientation");
        int n = orientation = orientationValue == null ? 1 : orientationValue;
        if (orientation == 1 || orientation == 2) {
            LayoutDirection layoutDirection = splitPane.getRenderLayoutDirection();
            orientation = orientation == 1 ? (layoutDirection.isLeftToRight() ? 3 : 4) : (layoutDirection.isLeftToRight() ? 4 : 3);
        }
        return orientation;
    }

    private boolean isOrientationVertical(SplitPane splitPane) {
        Integer orientationValue = (Integer)splitPane.getRenderProperty("orientation");
        int orientation = orientationValue == null ? 1 : orientationValue;
        return orientation == 5 || orientation == 6;
    }

    public void processPropertyUpdate(ContainerInstance ci, Component component, Element propertyElement) {
        if ("separatorPosition".equals(propertyElement.getAttribute("name"))) {
            Extent newValue = ExtentRender.toExtent(propertyElement.getAttribute("value"));
            ci.getUpdateManager().getClientUpdateManager().setComponentProperty(component, "separatorPosition", (Object)newValue);
        }
    }

    public void renderAdd(RenderContext rc, ServerComponentUpdate update, String targetId, Component component) {
        ServerMessage serverMessage = rc.getServerMessage();
        serverMessage.addLibrary(SPLIT_PANE_SERVICE.getId());
        SplitPane splitPane = (SplitPane)component;
        this.renderInitDirective(rc, splitPane, targetId);
        Component[] children = splitPane.getVisibleComponents();
        for (int i = 0; i < children.length; ++i) {
            this.renderChild(rc, update, splitPane, children[i]);
        }
        this.updateRenderState(rc, splitPane);
    }

    private void renderAddChildDirective(RenderContext rc, ServerComponentUpdate update, SplitPane splitPane, int index) {
        String elementId = ContainerInstance.getElementId((Component)splitPane);
        ServerMessage serverMessage = rc.getServerMessage();
        Element partElement = serverMessage.addPart("update", "EchoSplitPane.MessageProcessor");
        Element addChildElement = serverMessage.getDocument().createElement("add-child");
        addChildElement.setAttribute("eid", elementId);
        addChildElement.setAttribute("index", Integer.toString(index));
        Component child = splitPane.getVisibleComponent(index);
        this.renderLayoutData(rc, addChildElement, child, index);
        partElement.appendChild(addChildElement);
        this.renderChild(rc, update, splitPane, child);
    }

    private void renderAddChildren(RenderContext rc, ServerComponentUpdate update) {
        SplitPane splitPane = (SplitPane)update.getParent();
        RenderStateImpl currentRenderState = new RenderStateImpl(splitPane);
        Component[] addedChildren = update.getAddedChildren();
        for (int i = 0; i < addedChildren.length; ++i) {
            String id = ContainerInstance.getElementId(addedChildren[i]);
            if (SplitPanePeer.equal(id, currentRenderState.pane0)) {
                this.renderAddChildDirective(rc, update, splitPane, 0);
                continue;
            }
            if (!SplitPanePeer.equal(id, currentRenderState.pane1)) continue;
            this.renderAddChildDirective(rc, update, splitPane, 1);
        }
    }

    private void renderChild(RenderContext rc, ServerComponentUpdate update, SplitPane splitPane, Component child) {
        ComponentSynchronizePeer syncPeer = SynchronizePeerFactory.getPeerForComponent(child.getClass());
        syncPeer.renderAdd(rc, update, this.getContainerId(child), child);
    }

    public void renderDispose(RenderContext rc, ServerComponentUpdate update, Component component) {
        ServerMessage serverMessage = rc.getServerMessage();
        serverMessage.addLibrary(SPLIT_PANE_SERVICE.getId());
        this.renderDisposeDirective(rc, (SplitPane)component);
    }

    private void renderDisposeDirective(RenderContext rc, SplitPane splitPane) {
        String elementId = ContainerInstance.getElementId((Component)splitPane);
        ServerMessage serverMessage = rc.getServerMessage();
        Element initElement = serverMessage.appendPartDirective("preremove", "EchoSplitPane.MessageProcessor", "dispose");
        initElement.setAttribute("eid", elementId);
    }

    private int getSeparatorPosition(SplitPane splitPane) {
        Extent separatorPosition = (Extent)splitPane.getRenderProperty("separatorPosition", (Object)DEFAULT_SEPARATOR_POSITION);
        return ExtentRender.toPixels(separatorPosition, 100);
    }

    private boolean hasRelocatedChildren(RenderContext rc, ServerComponentUpdate update) {
        SplitPane splitPane;
        ContainerInstance ci = rc.getContainerInstance();
        RenderStateImpl previous = (RenderStateImpl)ci.getRenderState((Component)(splitPane = (SplitPane)update.getParent()));
        if (previous == null) {
            return false;
        }
        RenderStateImpl current = new RenderStateImpl(splitPane);
        return previous.pane0 != null && previous.pane0.equals(current.pane1) || previous.pane1 != null && previous.pane1.equals(current.pane0);
    }

    private void renderInitDirective(RenderContext rc, SplitPane splitPane, String targetId) {
        FillImage separatorImage;
        Boolean booleanValue;
        Font font;
        Color foreground;
        Color background;
        String elementId = ContainerInstance.getElementId((Component)splitPane);
        boolean vertical = this.isOrientationVertical(splitPane);
        ServerMessage serverMessage = rc.getServerMessage();
        Element partElement = serverMessage.addPart("update", "EchoSplitPane.MessageProcessor");
        Element initElement = serverMessage.getDocument().createElement("init");
        initElement.setAttribute("container-eid", targetId);
        initElement.setAttribute("eid", elementId);
        initElement.setAttribute("position", Integer.toString(this.getSeparatorPosition(splitPane)));
        int orientation = this.getRenderOrientation(splitPane);
        switch (orientation) {
            case 3: {
                initElement.setAttribute("orientation", "l-r");
                break;
            }
            case 4: {
                initElement.setAttribute("orientation", "r-l");
                break;
            }
            case 5: {
                initElement.setAttribute("orientation", "t-b");
                break;
            }
            case 6: {
                initElement.setAttribute("orientation", "b-t");
                break;
            }
            default: {
                throw new IllegalStateException("Invalid orientation: " + orientation);
            }
        }
        if (!splitPane.isRenderEnabled()) {
            initElement.setAttribute("enabled", "false");
        }
        if ((background = (Color)splitPane.getRenderProperty("background")) != null) {
            initElement.setAttribute("background", ColorRender.renderCssAttributeValue(background));
        }
        if ((foreground = (Color)splitPane.getRenderProperty("foreground")) != null) {
            initElement.setAttribute("foreground", ColorRender.renderCssAttributeValue(foreground));
        }
        if ((font = (Font)splitPane.getRenderProperty("font")) != null) {
            CssStyle fontCssStyle = new CssStyle();
            FontRender.renderToStyle(fontCssStyle, font);
            initElement.setAttribute("font", fontCssStyle.renderInline());
        }
        boolean resizable = (booleanValue = (Boolean)splitPane.getRenderProperty("resizable")) == null ? false : booleanValue;
        initElement.setAttribute("resizable", resizable ? "true" : "false");
        initElement.setAttribute("separator-size", Integer.toString(this.calculateSeparatorSize(splitPane)));
        Color separatorColor = (Color)splitPane.getRenderProperty("separatorColor");
        if (separatorColor != null) {
            initElement.setAttribute("separator-color", ColorRender.renderCssAttributeValue(separatorColor));
        }
        FillImage fillImage = separatorImage = vertical ? (FillImage)splitPane.getRenderProperty("separatorVerticalImage") : (FillImage)splitPane.getRenderProperty("separatorHorizontalImage");
        if (separatorImage != null) {
            CssStyle fillImageCssStyle = new CssStyle();
            FillImageRender.renderToStyle(fillImageCssStyle, rc, this, (Component)splitPane, vertical ? IMAGE_ID_VERTICAL_SEPARATOR : IMAGE_ID_HORIZONTAL_SEPARATOR, separatorImage, 0);
            initElement.setAttribute("separator-image", fillImageCssStyle.renderInline());
        }
        Component[] children = splitPane.getVisibleComponents();
        for (int i = 0; i < children.length; ++i) {
            this.renderLayoutData(rc, initElement, children[i], i);
        }
        partElement.appendChild(initElement);
    }

    private void renderLayoutData(RenderContext rc, Element containerElement, Component component, int index) {
        SplitPaneLayoutData layoutData = (SplitPaneLayoutData)component.getRenderProperty("layoutData");
        if (layoutData == null) {
            return;
        }
        Element layoutDataElement = rc.getServerMessage().getDocument().createElement("layout-data");
        layoutDataElement.setAttribute("index", Integer.toString(index));
        if (layoutData.getAlignment() != null) {
            CssStyle alignmentStyle = new CssStyle();
            AlignmentRender.renderToStyle(alignmentStyle, layoutData.getAlignment(), component);
            layoutDataElement.setAttribute("alignment", alignmentStyle.renderInline());
        }
        if (layoutData.getBackground() != null) {
            layoutDataElement.setAttribute("background", ColorRender.renderCssAttributeValue(layoutData.getBackground()));
        }
        if (layoutData.getBackgroundImage() != null) {
            CssStyle backgroundImageStyle = new CssStyle();
            FillImageRender.renderToStyle(backgroundImageStyle, rc, this, component.getParent(), index == 0 ? IMAGE_ID_PANE_0_BACKGROUND : IMAGE_ID_PANE_1_BACKGROUND, layoutData.getBackgroundImage(), 0);
            layoutDataElement.setAttribute("background-image", backgroundImageStyle.renderInline());
        }
        if (!(component instanceof Pane) && layoutData.getInsets() != null) {
            layoutDataElement.setAttribute("insets", InsetsRender.renderCssAttributeValue(layoutData.getInsets()));
        }
        switch (layoutData.getOverflow()) {
            case 0: {
                layoutDataElement.setAttribute("overflow", "auto");
                break;
            }
            case 1: {
                layoutDataElement.setAttribute("overflow", "hidden");
                break;
            }
            case 2: {
                layoutDataElement.setAttribute("overflow", "scroll");
            }
        }
        if (layoutData.getMinimumSize() != null) {
            layoutDataElement.setAttribute("min-size", Integer.toString(ExtentRender.toPixels(layoutData.getMinimumSize(), -1)));
        }
        if (layoutData.getMaximumSize() != null) {
            layoutDataElement.setAttribute("max-size", Integer.toString(ExtentRender.toPixels(layoutData.getMaximumSize(), -1)));
        }
        containerElement.appendChild(layoutDataElement);
    }

    private void renderRemoveChildren(RenderContext rc, ServerComponentUpdate update) {
        ContainerInstance ci = rc.getContainerInstance();
        SplitPane splitPane = (SplitPane)update.getParent();
        RenderStateImpl previousRenderState = (RenderStateImpl)ci.getRenderState((Component)splitPane);
        Component[] removedChildren = update.getRemovedChildren();
        for (int i = 0; i < removedChildren.length; ++i) {
            String id = ContainerInstance.getElementId(removedChildren[i]);
            if (SplitPanePeer.equal(id, previousRenderState.pane0)) {
                this.renderRemoveChildDirective(rc, splitPane, 0);
                continue;
            }
            if (!SplitPanePeer.equal(id, previousRenderState.pane1)) continue;
            this.renderRemoveChildDirective(rc, splitPane, 1);
        }
    }

    private void renderRemoveChildDirective(RenderContext rc, SplitPane splitPane, int index) {
        String elementId = ContainerInstance.getElementId((Component)splitPane);
        ServerMessage serverMessage = rc.getServerMessage();
        Element partElement = serverMessage.addPart("remove", "EchoSplitPane.MessageProcessor");
        Element removeChildElement = serverMessage.getDocument().createElement("remove-child");
        removeChildElement.setAttribute("eid", elementId);
        removeChildElement.setAttribute("index", Integer.toString(index));
        partElement.appendChild(removeChildElement);
    }

    private void renderSetSeparatorPositionDirective(RenderContext rc, SplitPane splitPane) {
        String elementId = ContainerInstance.getElementId((Component)splitPane);
        ServerMessage serverMessage = rc.getServerMessage();
        Element partElement = serverMessage.addPart("remove", "EchoSplitPane.MessageProcessor");
        Element setSeparatorPositionElement = serverMessage.getDocument().createElement("set-separator-position");
        setSeparatorPositionElement.setAttribute("eid", elementId);
        setSeparatorPositionElement.setAttribute("position", Integer.toString(this.getSeparatorPosition(splitPane)));
        partElement.appendChild(setSeparatorPositionElement);
    }

    public boolean renderUpdate(RenderContext rc, ServerComponentUpdate update, String targetId) {
        boolean fullReplace = false;
        if (update.hasUpdatedLayoutDataChildren()) {
            fullReplace = true;
        } else if (update.hasUpdatedProperties()) {
            if (!this.partialUpdateManager.canProcess(rc, update)) {
                fullReplace = true;
            }
        } else if (this.hasRelocatedChildren(rc, update)) {
            fullReplace = true;
        }
        if (fullReplace) {
            this.renderDisposeDirective(rc, (SplitPane)update.getParent());
            DomUpdate.renderElementRemove((ServerMessage)rc.getServerMessage(), (String)ContainerInstance.getElementId(update.getParent()));
            this.renderAdd(rc, update, targetId, update.getParent());
        } else {
            this.partialUpdateManager.process(rc, update);
            if (update.hasAddedChildren() || update.hasRemovedChildren()) {
                this.renderRemoveChildren(rc, update);
                this.renderAddChildren(rc, update);
            }
        }
        this.updateRenderState(rc, (SplitPane)update.getParent());
        return fullReplace;
    }

    private void updateRenderState(RenderContext rc, SplitPane splitPane) {
        rc.getContainerInstance().setRenderState((Component)splitPane, new RenderStateImpl(splitPane));
    }

    static {
        WebRenderServlet.getServiceRegistry().add(SPLIT_PANE_SERVICE);
    }

    static class RenderStateImpl
    implements RenderState {
        private String pane0;
        private String pane1;

        private RenderStateImpl(SplitPane splitPane) {
            int componentCount = splitPane.getVisibleComponentCount();
            this.pane0 = componentCount < 1 || splitPane.getVisibleComponent(0) == null ? null : ContainerInstance.getElementId(splitPane.getVisibleComponent(0));
            this.pane1 = componentCount < 2 || splitPane.getVisibleComponent(1) == null ? null : ContainerInstance.getElementId(splitPane.getVisibleComponent(1));
        }
    }
}

